<x-app-layout>
    @section('title', 'Student Fee List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

<style type="text/css">
.select2-container {
}

.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}

.dont-break-out {
    white-space: break-word !important;
/* These are technically the same, but use both */
overflow-wrap: break-word !important;
word-wrap: break-word !important;

-ms-word-break: break-all !important;
/* This is the dangerous one in WebKit, as it breaks things wherever */
word-break: break-all !important;
/* Instead use this non-standard one: */
word-break: break-word !important;

/* Adds a hyphen where the word breaks, if supported (No Blink) */
-ms-hyphens: auto;
-moz-hyphens: auto;
-webkit-hyphens: auto;
hyphens: auto;

}
</style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <x-card title="{{ __('translation.Students Fee Details') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-1/4 mb-6 lg:mb-0">
                <a href="{{route('student_fee.create')}}">
                    <x-button color="green" id="BtnInsert">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="ml-2">
                            {{ __('translation.Add Fee') }}
                        </span>
                    </x-button>
                </a>
            </div>
            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                    <option value=""  disabled>
                        {{ '- ' . __('translation.Select Class') . ' -' }}
                    </option>
                    @if (isset($classes))
                        @foreach ($classes as $class)
                            <option  @if($student->currentAcademicStatus->class_id==$class->id) selected @endif value="{{$class->id}}">{{$class->class_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                    <option value="">
                        {{ '- ' . __('translation.Select Session') . ' -' }}
                    </option>
                    @if (isset($sessions))
                        @foreach ($sessions as $session)
                            <option @if($student->currentAcademicStatus->session_id==$session->id) selected @endif value="{{$session->id}}">{{$session->session_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <div class="flex items-left justify-left">
                    <img name="upload_photo" style="max-width: 115px;margin-top: -38px;" src="{{ URL::asset('/uploads/students/'.$student->profile_photo) }}" class="profile_photo__thumbnail w-full h-auto border border-solid border-gray-300 rounded-md">
                </div>
                <div>
                    <strong>{{$student->name}}</strong>
                </div>

                <input type="hidden" id="__student_code" type="text" class="block w-full h-10 px-2 py-2 rounded-md shadow-sm border border-solid border-gray-300  mt-1 bg-white" value="{{$student->student_code}}">
            </div>

        </div>

        <div class="overflow-x-none">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.#Receipt') }}
                        </th>
                        <th>
                            {{ __('translation.Entry Date') }}
                        </th>
                        <th>
                            {{ __('translation.Monthly Fee') }}
                        </th>

                        <th>
                            {{ __('translation.Others Fee') }}
                        </th>

                        <th>
                            {{ __('translation.Details') }}
                        </th>

                        <th>
                            {{ __('translation.Amount') }}
                        </th>
                        <th>
                            {{ __('translation.Action') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
   @endif

    <div class="modal fade" id="fee_status_chnage_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="POST" action="{{url('fee_status_approve/')}}" enctype="multipart/form-data">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title font-bold text-lg">
                            Change Status
                        </h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true" class="text-xl">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p class="text-center mb-4">Do you want to approve it now ?</p>
                        @csrf
                        <input type="hidden" name="id" id="fee_id">
                        <div class="row">
                            <div class="col-lg-4 offset-lg-4">
                                <x-select class="form-control" id="exampleFormControlSelect1" name='status'>
                                    <option value="paid">{{ __('translation.Approved') }}</option>
                                </x-select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-center pb-4">
                        <x-button type="button" color="green" data-dismiss="modal">
                            {{ __('translation.Close') }}
                        </x-button>
                        <x-button type="submit" color="red" class="ml-1">
                            {{ __('translation.Yes') }}
                        </x-button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    {{-- modal-receipt --}}
<x-modal.modal-full class="modal-hide modal-receipt">
    <x-modal.header>
        <x-modal.title>
            {{ __('translation.Money Receipt') }}
        </x-modal.title>
        <x-modal.close-button id="closeModalReceipt" />
    </x-modal.header>
    <x-modal.body>
        <div class="pb-6 data-wrapper">

        </div>
    </x-modal.body>
 </x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('fee_list_by_student_id') }}';
            var status = 'all';

            function loadStudentsTable(url) {
                $('#__studentTable').dataTable({
                    processing: true,
                    serverSide: true,
                    ajax: url,
                    "ajax": {
                        "url": url,
                        type : 'POST',
                        data: {
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                            student_code: $("#__student_code").val(),
                        },
                        "dataSrc": function ( json ) {
                        if(json){
                                for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                                    json.data[i][0] = json.data[i][0];
                                }
                                console.log(json);
                                if(json.draw=='1'){
                                $(".all .order-purchase__filter-total").html(" ("+json.suppliersCountAll+")");
                                $(".open .order-purchase__filter-total").html(" ("+json.suppliersCountOpen+")");
                                $(".arrive .order-purchase__filter-total").html(" ("+json.suppliersCountArrive+")");

                                $(".closes .order-purchase__filter-total").html(" ("+json.suppliersCountClose+")");
                                }
                                return json.data;
                            }
                        }
                    },
                    columns: [

                        {
                            name: 'receipt_no',
                            data: 'receipt_no'
                        },

                        {
                            name: 'entry_date',
                            data: 'entry_date'
                        },

                        {
                            name: 'monthly_fee',
                            data: 'monthly_fee'
                        },

                        {
                            name: 'others_fee',
                            data: 'others_fee'
                        },
                        {
                            name: 'payment_details',
                            data: 'payment_details'
                        },
                        {
                            name: 'amount',
                            data: 'amount'
                        },
                        {
                            name: 'action',
                            data: 'action'
                        },
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                       {
                            targets: [3,4,5],
                            orderable: false,
                            className: 'text-center'
                        },
                        { "width": "10%", "targets": 0 },
                        { "width": "15%", "targets": 1 },
                        { "width": "25%", "targets": 2 },
                        { "width": "20%", "targets": 3 },
                        { "width": "20%", "targets": 4 },
                        { "width": "10%", "targets": 4 },

                    ],
                    order: [
                        [ 0, 'desc' ]
                    ]
                });
            }

            loadStudentsTable(studentTableUrl);

            $('#__selectClassFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__rollNo').keyup(function() {
                $('#__studentTable').dataTable().fnDestroy();
                loadStudentsTable(studentTableUrl);

            });

            $('#__rollNo').click(function() {
                $('#__studentTable').dataTable().fnDestroy();
                loadStudentsTable(studentTableUrl);

            });



            $('input[type="search"]').on('keyup', function(e) {
                $("#arrive_or_over_due").select2('val', '0')
                $("#supplier_id").select2("val", "0");
            });




            $(document).on('click', '.BtnChangeStatus', function() {
                var fee_id = $(this).attr('data-id');
                $('#fee_status_chnage_modal').modal('show');
                $('#fee_id').val(fee_id);
            });

            $('#__selectSessionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Session -',
                allowClear: true
            });

            $('#__selectClassFilter').select2({
                width: 'resolve',
                placeholder: '- Select Class -',
                allowClear: true
            });

            $('#__selectSectionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Section -',
                allowClear: true
            });

            $('#__selectStatusFilter').select2({
                width: 'resolve',
                placeholder: '- Select Status -',
                allowClear: true,
            });


            $(document).on('click', '#BtnDelete', function() {
                let drop = confirm('Are you sure?');
                if (drop) {
                    //remove from data table
                    $(this).closest('tr').remove();
                    $.ajax({
                        url: '{{ route('student_fee.delete') }}',
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            alert('Data deleted successfully');

                            $('#__studentTable').dataTable().fnDestroy();
                            loadStudentsTable(studentTableUrl);

                        } else {
                            alert(result.message);
                        }
                    });
                }
            });


            $(document).on('click', '#BtnPrintMoneyReceipt', function() {
                var receipt_id = $(this).data('id');
                fn_show_receipt(receipt_id);
            });

            function fn_show_receipt(receipt_id){

                $('.modal-receipt').removeClass('modal-hide');
                $.ajax({
                        url: '{{ route('get_money_receipt') }}',
                        type: 'post',
                        data: {
                            'receipt_id': receipt_id,
                        },
                        beforeSend: function() {
                            $('.data-wrapper').html("Processing....");
                        }
                    }).done(function(result) {
                        console.log(result);
                        $('.data-wrapper').html(result);
                        if (result === 'success') {
                        // fn_print_receipt();
                        } else {

                        }
                    });

                }


                jQuery("#closeModalReceipt").on("click", function(){
                    $('.modal-receipt').addClass('modal-hide');
                });

        </script>
    @endpush
</x-app-layout>
