<x-app-layout>
    @section('title', 'Inventory Sync')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
    @endpush

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Product'))
        <x-card title="Payment Details - ({{ $student->id }})">

        <div>
            @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

            <div class="flex flex-col sm:flex-row justify-between items-start mb-6 p-3 border-solid border-gray-300">
                <div class="flex flex-row gap-4">
                    <div class="w-1/2 sm:w-1/3 md:w-1/4 lg:w-1/5">
                        <div class="mb-3">
                            <img class="w-full h-auto rounded-md border border-solid border-gray-200" src="{{ $productSync->image_url }}" alt="{{ $productSync->product_name }}">
                        </div>
                        <div class="mb-3">
                            <span class="text-blue-500 font-bold">ID: {{ $student->id }}</span>
                        </div>
                    </div>
                    <div class="w-1/2 sm:w-1/2 md:w-3/4 lg:w-4/5">
                        <div class="grid grid-col-1 lg:gap-y-1">
                            <div>                               
                                <span class="font-bold text-lg">{{ $student->name }}</span><br>
                                <span class="text-blue-500 font-bold">Roll No. {{ $student->roll_no }}</span>
                                <span class="text-blue-500 font-bold">({{ $student->section->section_name }})</span>
                            </div>
                            <div>
                                <span class="font-bold">Class: {{ $student->class->class_name }}</span>
                            </div>
                            <div>
                                <label class="text-gray-700">Total:</label> {{ number_format($productSync->quantity) }}
                            </div>
                            <div>
                                <label class="text-gray-700">Paid:</label> {{ number_format($productSync->pack) }}
                            </div>
                            <div>
                                <label class="text-gray-700">Due:</label> {{ number_format($productSync->total_incoming) }}
                            </div>
                            <div>
                                <label class="text-gray-700">Last Updated:</label> {{ date('F d, Y', strtotime($productSync->updated_at)) }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-4">
                <div class="w-full md:w-1/2 lg:w-3/5 mb-6 sm:mb-0">
                    <div class="flex flex-row">
                        <div class="w-1/3 relative -top-1">
                            <x-select class="text-sm" id="__selectChannelFilter">
                                <option disabled>
                                    - {{ __('translation.Select Sales Channel') }} -
                                </option>
                                <option value="woo" selected>
                                    Woocommerce ({{ $wooProductSelectedCount }})
                                </option>
                                <option value="shopee">
                                    Shopee ({{ $shopeeProductsSelectedCount }})
                                </option>
                                <option value="lazada">
                                    Lazada ({{ $lazadaProductsSelectedCount }})
                                </option>
                            </x-select>
                        </div>

                        <div class="w-1/3 relative -top-1">
                            <x-select class="text-sm" id="__selectShopFilter">
                                <option value="0">
                                    - {{ __('translation.Select Shop') }} -
                                </option>
                                @if(isset($shops))
                                    @foreach($shops as $shop)
                                        <option value="{{$shop->id}}">{{$shop->shops->name}}</option>
                                    @endforeach
                                @endif
                            </x-select>
                        </div>

                        <div class="w-1/3 pl-1 relative -top-1">
                            <x-select class="text-sm" id="__selectionFilter">
                                <option disabled>
                                    - {{ __('translation.Sort by') }} -
                                </option>
                                <option value="all" selected>
                                    All ({{ $wooProductsCount }})
                                </option>
                                <option value="selected">
                                    Selected ({{ $wooProductSelectedCount }})
                                </option>
                                <option value="available">
                                    Available ({{ $wooProductAvailableCount }})
                                </option>
                                <option value="unavailable">
                                    Unavailable ({{ $wooProductUnavailableCount }})
                                </option>
                            </x-select>
                        </div>
                    </div>
                </div>

                <div class="w-full md:w-1/2 lg:w-2/5 flex flex-row sm:justify-end">
                    <x-button color="yellow" id="__btnAutoLink" class="mb-2 ml-2">
                        Auto-link
                    </x-button>

                    <x-button color="green" id="__btnSaveProductLinks" class="mb-2 ml-1">
                        Save Links
                    </x-button>

                    <x-button color="blue" id="__btnSyncQuantity" class="ml-1">
                        Sync Quantity
                    </x-button>
                </div>
            </div>
        </div>


        <div class="w-full overflow-x-auto">
            <table class="w-full table" id="datatable">
                <thead>
                <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                    <th></th>
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Image') }}
                    </th>
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Product Name') }}
                    </th>
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Website') }}
                    </th>
                    <th class="px-4 py-2 text-center">
                        {{ __('translation.Type') }}
                    </th>
                    <th class="px-4 py-2">
                        {{ __('translation.Price/Pack') }}
                    </th>
                    <th class="px-4 py-2">
                        {{ __('translation.Quantity') }}
                    </th>
                    <th class="px-4 py-2">
                        {{ __('translation.Inventory Link') }}
                    </th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
    @endif

    @push('bottom_js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>

        <script>
            const productSyncId = {{ $productSync->id }};
            const inventoryTableUrl = '{{ route('product.inventory_sync.datatable') }}';
            const loadShopListUrl = '{{route('product.inventory_sync.shop_list')}}';
            const loadFilterQuantitiesUrl = '{{route('product.inventory_sync.filter_quantities')}}';
            const autoLinkUrl = '{{route('product.inventory_auto_link')}}';
            const syncQuantityUrl = '{{route('product.inventory_sync.quantity')}}';
            const saveProductLinkUrl = '{{route('product.save_link')}}';
            const saveMultipleProductLinksUrl = '{{route('product.save_multiple_links')}}';
            var inventoryTable = '';
            var selectedRows = [];

            const loadPermissionTable = (salesChannel, shopFilter, selectionFilter) => {
                inventoryTable = $('#datatable').DataTable({
                    serverSide: true,
                    processing: true,
                    bDestroy: true,
                    pageLength: 10,
                    pagingType: 'numbers',
                    ajax: {
                        type: 'GET',
                        url: inventoryTableUrl,
                        data: {
                            productSyncId: productSyncId,
                            salesChannel: salesChannel,
                            shopFilter: shopFilter,
                            selectionFilter: selectionFilter
                        }
                    },
                    columnDefs: [
                        {
                            targets: [0],
                            orderable: false,
                            render: function(data, type, row, meta) {
                                data = '<input type="checkbox" class="dt-checkboxes sync_product_id" name="sync_product_id" id="'+row[0]+'">'
                                if (row[2].includes('checked')) {
                                    data = '<input type="checkbox" class="dt-checkboxes sync_product_id" name="sync_product_id" id="'+row[0]+'" checked>';
                                } else if (row[2].includes('linked')) {
                                    data = '<input type="checkbox" class="dt-checkboxes sync_product_id" name="sync_product_id" id="'+row[0]+'" disabled>';
                                }

                                return data;
                            },
                            checkboxes: {
                                selectRow: true,
                            },
                        },
                    ],
                    select: {
                        style: 'multiple',
                    },
                    bDeferRender: true,
                    order: [
                        [1, 'desc']
                    ],
                });
            }

            loadPermissionTable();

            function loadShopsList(salesChannel){
                $.ajax({
                    url: loadShopListUrl,
                    type: "POST",
                    data: {
                        salesChannel: salesChannel,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (result) {
                        $('#__selectShopFilter').html('<option selected value="0">- Select Shop -</option>');

                        if (salesChannel === 'woo'){
                            $.each(result.shopList, function (key, value) {
                                $("#__selectShopFilter").append('<option value="' + value
                                    .id + '">' + value.shops.name + '</option>');
                            });
                        } else {
                            $.each(result.shops, function (key, value) {
                                $("#__selectShopFilter").append('<option value="' + value
                                    .id + '">' + value.name + '</option>');
                            });
                        }
                    }
                });
            }

            function loadFilterQuantities(salesChannel){
                $.ajax({
                    url: loadFilterQuantitiesUrl,
                    type: "POST",
                    data: {
                        productSyncId: productSyncId,
                        salesChannel: salesChannel,
                        _token: '{{csrf_token()}}'
                    },
                    dataType: 'json',
                    success: function (result) {
                        $('#__selectionFilter').html('<option disabled value="0">- Sort By -</option>');
                        $("#__selectionFilter").append('<option selected value="all">All (' + result.productsCount + ')</option>');
                        $("#__selectionFilter").append('<option value="selected">Selected (' + result.productSelectedCount + ')</option>');
                        $("#__selectionFilter").append('<option value="available">Available (' + result.productAvailableCount + ')</option>');
                        $("#__selectionFilter").append('<option value="unavailable">Unavailable(' + result.productUnavailableCount + ')</option>');
                    }
                });
            }

            $('#__selectChannelFilter').on('change', function() {
                let salesChannel = $(this).val();
                $('#__selectionFilter').val('all');

                loadShopsList(salesChannel);
                loadFilterQuantities(salesChannel);
                loadPermissionTable(salesChannel);
            });

            $('#__selectShopFilter').on('change', function() {
                let shop = $(this).val();
                let salesChannel = $('#__selectChannelFilter').val();
                $('#__selectionFilter').val('all');

                loadPermissionTable(salesChannel, shop);
            });

            $('#__selectionFilter').on('change', function() {
                let salesChannel = $('#__selectChannelFilter').val();
                let shop = $('#__selectShopFilter').val();
                let selectionFilter = $(this).val();

                loadPermissionTable(salesChannel, shop, selectionFilter);
            });

            $('#__btnAutoLink').click(function() {
                let drop = confirm('Do you want to auto link products?');

                if (drop) {
                    $.ajax({
                        url: autoLinkUrl,
                        type: 'POST',
                        data: {
                            productSyncId: productSyncId,
                            '_token': $('meta[name=csrf-token]').attr('content')
                        },
                        beforeSend: function() {
                            // Pesan yang muncul ketika memproses delete
                        }
                    }).done(function(result) {
                        location.reload();
                    });
                }
            });

            $('#__btnSaveProductLinks').on('click',function() {
                let drop = confirm('Confirm product links?');

                if (drop) {
                    location.reload();
                }
            });


            $('#__btnSyncQuantity').click(function() {
                let drop = confirm('Do you want to sync product quantity?');

                if (drop) {
                    $.ajax({
                        url: syncQuantityUrl,
                        type: 'POST',
                        data: {
                            productSyncId: productSyncId,
                            '_token': $('meta[name=csrf-token]').attr('content')
                        },
                        beforeSend: function() {
                            // Pesan yang muncul ketika memproses delete
                        }
                    }).done(function(result) {
                        location.reload();
                    });
                }
            });

            $(document).on('change', 'input.sync_product_id', function(e){
                var target = e.target;
                var sync_product_id = target.id;
                let salesChannel = $('#__selectChannelFilter').val();
                if($(target).is(":checked")){
                    $.ajax({
                        url: saveProductLinkUrl,
                        type: 'post',
                        data: {
                            'productSyncId': productSyncId,
                            'sync_product_id': sync_product_id,
                            'action': 'attach',
                            'salesChannel': salesChannel,
                            '_token': $('meta[name=csrf-token]').attr('content')
                        },
                    }).done(function(result) {
                        if (result.status === 1) {
                        } else {
                            alert(result.message);
                        }
                    });
                } else{
                    $.ajax({
                        url: saveProductLinkUrl,
                        type: 'post',
                        data: {
                            'productSyncId': productSyncId,
                            'sync_product_id': sync_product_id,
                            'action': 'detach',
                            'salesChannel': salesChannel,
                            '_token': $('meta[name=csrf-token]').attr('content')
                        },
                    }).done(function(result) {
                        if (result.status !== 1) {
                            alert(result.message);
                        }
                    });
                }
            });

            $(document).on('change', '.dt-checkboxes-select-all', function(e){
                var target = e.target;
                var sync_product_id = [];
                let salesChannel = $('#__selectChannelFilter').val();
                if($(target).is(":checked")){
                    $("input:checkbox[name=sync_product_id]:checked").each(function(){
                        sync_product_id.push($(this).attr('id'));
                    });
                    $.ajax({
                        url: saveMultipleProductLinksUrl,
                        type: 'post',
                        data: {
                            'productSyncId': productSyncId,
                            'sync_product_id': sync_product_id,
                            'action': 'attach',
                            'salesChannel': salesChannel,
                            '_token': $('meta[name=csrf-token]').attr('content')
                        },
                    }).done(function(result) {
                        if (result.status !== 1) {
                            alert(result.message);
                        }
                    });
                } else{
                    $("input:checkbox[name=sync_product_id]").each(function(){
                        sync_product_id.push($(this).attr('id'));
                    });
                    $.ajax({
                        url: saveMultipleProductLinksUrl,
                        type: 'post',
                        data: {
                            'productSyncId': productSyncId,
                            'sync_product_id': sync_product_id,
                            'action': 'detach',
                            'salesChannel': salesChannel,
                            '_token': $('meta[name=csrf-token]').attr('content')
                        },
                    }).done(function(result) {
                        if (result.status !== 1) {
                            alert(result.message);
                        }
                    });
                }
            });

        </script>
    @endpush
</x-app-layout>
