<x-app-layout>
    @section('title', 'Student Fee List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

<style type="text/css">
.select2-container {
}

.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}

.dont-break-out {
    white-space: break-word !important;
/* These are technically the same, but use both */
overflow-wrap: break-word !important;
word-wrap: break-word !important;

-ms-word-break: break-all !important;
/* This is the dangerous one in WebKit, as it breaks things wherever */
word-break: break-all !important;
/* Instead use this non-standard one: */
word-break: break-word !important;

/* Adds a hyphen where the word breaks, if supported (No Blink) */
-ms-hyphens: auto;
-moz-hyphens: auto;
-webkit-hyphens: auto;
hyphens: auto;

}
</style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <x-card title="{{ __('translation.Students Fee') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-1/4 mb-6 lg:mb-0">
                <a href="{{route('student_fee.create')}}">
                    <x-button color="green" id="BtnInsert">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="ml-2">
                            {{ __('translation.Add Fee') }}
                        </span>
                    </x-button>
                </a>
            </div>



            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Class') . ' -' }}
                    </option>
                    @if (isset($classes))
                        @foreach ($classes as $classe)
                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                    <option value="" disabled>
                        {{ '- ' . __('translation.Select Section') . ' -' }}
                    </option>
                    @if (isset($sections))
                        @foreach ($sections as $section)
                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                    <option value="" disabled>
                        {{ '- ' . __('translation.Select Session') . ' -' }}
                    </option>
                    @if (isset($sessions))
                        @foreach ($sessions as $session)
                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <x-select name="status_id"   id="__selectStatusFilter" class="status_id" style="width: 100%;">
                    <option value="" disabled>
                        {{ '- ' . __('translation.Select Status') . ' -' }}
                    </option>
                    <option value="1">Paid</option>
                    <option value="0">Due</option>
                </x-select>
            </div>

        </div>

        <div class="overflow-x-none">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.Details') }}
                        </th>
                        <th>
                            {{ __('translation.Monthly Fee') }}
                        </th>

                        <th>
                            {{ __('translation.Others Fee') }}
                        </th>

                        <th>
                            {{ __('translation.Amount') }}
                        </th>
                        <th>
                            {{ __('translation.Action') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
   @endif

    <div class="modal fade" id="po_chnage_status_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form method="POST" action="{{url('change_otder_purchase_status/')}}" id="form-importss" enctype="multipart/form-data">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title font-bold text-lg">
                            Change Status
                        </h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true" class="text-xl">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p class="text-center mb-4">Do you want to change this order purchase status ?</p>
                        @csrf
                        <input type="hidden" name="id" id="order_id">
                        <div class="row">
                            <div class="col-lg-4 offset-lg-4">
                                <x-select class="form-control" id="exampleFormControlSelect1" name='status'>
                                    <option value="open">{{ __('translation.Open') }}</option>
                                    <option value="arrive">{{ __('translation.Arrive') }}</option>
                                    <option value="close">{{ __('translation.Close') }}</option>
                                </x-select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-center pb-4">
                        <x-button type="button" color="green" data-dismiss="modal">
                            {{ __('translation.Close') }}
                        </x-button>
                        <x-button type="submit" color="red" class="ml-1">
                            {{ __('translation.Yes') }}
                        </x-button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <x-modal.modal-full class="modal-mark-sheet modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Mark Sheet
            </x-modal.title>
            <x-modal.close-button id="closeModalMarkSheet" />
        </x-modal.header>
        <x-modal.body>
        <div id="mark-sheet-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('fee_list') }}';
            var status = 'all';

            function loadStudentsTable(url) {
                $('#__studentTable').dataTable({
                    processing: true,
                    serverSide: true,
                   // ajax: url,
                    "ajax": {
                        "url": url,
                        data: {
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                        console.log(json);
                        if(json.supplier !='' && json.draw=='1'){
                        $(".all .order-purchase__filter-total").html(" ("+json.suppliersCountAll+")");
                        $(".open .order-purchase__filter-total").html(" ("+json.suppliersCountOpen+")");
                        $(".arrive .order-purchase__filter-total").html(" ("+json.suppliersCountArrive+")");

                        $(".closes .order-purchase__filter-total").html(" ("+json.suppliersCountClose+")");
                        }
                         return json.data;
                        }
                    },
                    columns: [

                        {
                            name: 'details',
                            data: 'details'
                        },

                        {
                            name: 'monthly_fee',
                            data: 'monthly_fee'
                        },

                        {
                            name: 'others_fee',
                            data: 'others_fee'
                        },
                        {
                            name: 'amount',
                            data: 'amount'
                        },
                        {
                            name: 'action',
                            data: 'action'
                        },
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                       {
                            targets: [3],
                            orderable: false,
                            className: 'text-center'
                        },
                        { "width": "15%", "targets": 0 },
                        { "width": "20%", "targets": 1 },
                        { "width": "40%", "targets": 2 },
                        { "width": "10%", "targets": 3 },

                    ],
                    order: [
                        [ 0, 'asc' ]
                    ]
                });
            }

            loadStudentsTable(studentTableUrl);

            $('#__selectClassFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });


            $('input[type="search"]').on('keyup', function(e) {
                $("#arrive_or_over_due").select2('val', '0')
                $("#supplier_id").select2("val", "0");
            });




            $(document).on('click', '#purchase_status_chnage', function() {
                var order_id = $(this).attr('data-id');
                $('#po_chnage_status_modal').modal('show');
                $('#order_id').val(order_id);
            });

            $('#__selectSessionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Session -',
                allowClear: true
            });

            $('#__selectClassFilter').select2({
                width: 'resolve',
                placeholder: '- Select Class -',
                allowClear: true
            });

            $('#__selectSectionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Section -',
                allowClear: true
            });

            $('#__selectStatusFilter').select2({
                width: 'resolve',
                placeholder: '- Select Status -',
                allowClear: true,
            });


            $(document).on('click', '#BtnDelete', function() {
                let drop = confirm('Are you sure?');
                if (drop) {
                    //remove from data table
                    $(this).closest('tr').remove();

                    $.ajax({
                        url: '',
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            alert('Data deleted successfully');

                            $('#__studentTable').dataTable().fnDestroy();
                            loadStudentsTable(studentTableUrl);

                        } else {
                            alert(result.message);
                        }
                    });
                }
            });






            const markSheetUrl = '{{ route('mark_sheet_view') }}';
                $(document).on('click', '.exportMarkSheet', function() {
                var exam_id = $(this).data('exam_id');
                var session_id = $(this).data('session_id');
                var class_id = $(this).data('class_id');
                var student_id = $(this).data('student_id');
                $.ajax({
                       type: 'GET',
                        url: markSheetUrl,
                        data: {
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id,
                            student_id : student_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('processing...');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);

                    $('#mark-sheet-wrapper').html(result);
                });

            });

            $(document).on('change', '#exam_id', function() {
                var exam_id = $(this).val();
                var session_id = $("#session_id").val();
                var class_id = $("#class_id").val();
                var student_id = $("#student_id").val();
                $.ajax({
                       type: 'GET',
                        url: markSheetUrl,
                        data: {
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id,
                            student_id : student_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('processing...');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);

                    $('#mark-sheet-wrapper').html(result);
                });

            });


            $('#closeModalMarkSheet').click(function() {
                $('.modal-mark-sheet').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
