<x-app-layout>
    @section('title', 'Fee')

    @push('top_css')
        <link type="text/css" href="{{ asset('css/dataTables.checkboxes.css')}}" rel="stylesheet" />
        <link rel="stylesheet" href="{{ asset('css/jquery-ui.css')}}">
        <link rel="stylesheet" href="{{ asset('css/select2.min.css')}}">
    @endpush

    <style type="text/css">
        table{
            position: relative;
        }

       #AjaxOthersPayment ul li {
            border: 1px solid #ddd;
            margin-top: -1px;
            padding: 2px 12px;
            text-decoration: none;
            color: black;
            display: block;
            position: relative;
            text-align: left;
        }

        #AjaxOthersPayment input[type=checkbox], input[type=radio] {
            width: 28px !important;
            padding: 23px;
            height: 20px;
            margin-top: 1px;
            float: left;
        }

        select option:checked {
            border-bottom: 1px solid #c9c9c9 !important;
            background: #1a73e8 !important;;
            color: #fff !important;;
        }

        .entry_date{
            font-size: 0.9rem;
        }
         input[type=text],
         input[type=date],
         select,
         textarea {
                margin: 0;
                font-family: inherit;
                font-size: inherit;
                line-height: inherit;
                width: 100%;
            }


    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Student'))
        <x-card title="Take New Fee">

        <div>
            @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

    <input type="hidden" name="id" id="id" value="{{$studentFee->id}}" />
    <input type="hidden" name="student_id" id="student_id" value="{{$studentFee->student_id}}" />
    <input type="hidden" name="session_id" id="session_id" value="{{$studentFee->session_id}}" />
    <input type="hidden" name="class_id" id="class_id" value="{{$studentFee->class_id}}" />
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-4 sm:gap-x-8 mt-0">
        <div class="text-center lg:col-span-1 justify-between items-start mb-6 p-3 border-solid border-gray-300">

            <div class="mb-3">
                <img src="http://127.0.0.1:8000/No-Image-Found.png" style="width:100% !important" class="w-full h-auto rounded-md border border-solid border-gray-200">
            </div>
            <div class="mb-1">
                <span class="text-blue-500 font-bold">{{$student_details->name}}</span>
            </div>
            <div class="mb-1">
                <span class="text-black-500 font-bold">Roll No. </span>
                <span class="text-blue-500 font-bold">{{$student_details->roll_no}}</span>
            </div>

        </div>



        <div class="lg:col-span-1">
            <label class="block font-medium text-sm text-gray-700 mb-1">
            Select Month <span class="text-red-600">*</span></label>

            <div class="col-md-12" style="background: #a7e7de;box-shadow: 0px 3px 13px 0px #785682;text-align: center;padding: 10px;border-radius:20px; ">
                <?php  ?>
                <label class='label-control' for="exampleInputName">Monthly Fee</label>
                <select multiple size="12" id="monthlyFee" name="monthlyFee" class="form-control">

                @foreach($monthListArr as $key=>$monthName)
                    @php
                        if(in_array($monthName,$arr_monthly_fee_fields_paid)){
                            $selected='selected';
                        }else{
                            $selected='';
                        }
                    @endphp
                    <option {{$selected}} style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" data-fee="200" value="{{$monthName}}">{{$monthName}}</option>';                @endforeach
                </select>
                <div class="col-md-12">
                <span class="mb-0">
                    <svg style="cursor:pointer" onclick="clearMonthlyFee();" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-5 h-5 bi bi-arrow-repeat" viewBox="0 0 16 16"><path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path><path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path></svg>
                </span>
                </div>
            </div>
        </div>

        <div class="lg:col-span-2">
            <label class="block font-medium text-sm text-gray-700 mb-1">
            Other's Payment <span class="text-red-600">*</span></label>


            <div class="col-md-12" style="background: #a7e7de;box-shadow: 0px 3px 13px 0px #785682;text-align: center;padding: 10px;border-radius:20px; ">

                <label class='label-control' for="exampleInputName">Other's Payment</label>
                <label id="remove_area" class="label-control" for="exampleInputName" style="background: yellow;padding: 2px 13px;border-radius: 5px;color: #000;">
                <input type="checkbox" name="remove_item"> Add/Remove Field</label>
                    <div id='AjaxOthersPayment'>
                    <select multiple size="12" id="othersFee" name="othersFee" class="form-control">
                        @php
                            $amount = 0;
                        @endphp
                        @foreach($feeTypes as $feeType)
                        @if(!empty($feeType->fee_types_amount))
                            @php
                                $amount = isset($feeType->fee_types_amount[0]->amount) ? $feeType->fee_types_amount[0]->amount : 0;
                            @endphp
                        @endif

                        @php
                            if(in_array($feeType->name,$arr_others_fee_fields_paid)){
                                $selected='selected';
                            }else{
                                $selected='';
                            }
                        @endphp
                        <option {{$selected}} style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" data-title="{{$feeType->name}}"  data-fee="{{$amount}}" value="{{$feeType->name}}">{{$feeType->name}}</option>';
                        @endforeach
                    </select>
                    </div>
                <div class="col-md-12">
                <span class="mb-0">
                    <svg style="cursor:pointer" onclick="clearOthersFee();" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-5 h-5 bi bi-arrow-repeat" viewBox="0 0 16 16"><path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path><path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path></svg>
                </span>
                </div>
            </div>
        </div>

        <div class="lg:col-span-1">

            <input type="hidden" id="monthly_fee_fields" name="monthly_fee_fields" class="" value="{{$studentFee->monthly_fee_fields}}">
            <input type="hidden" id="others_fee_fields" name="others_fee_fields" class="" value="{{$studentFee->others_fee_fields}}">
            <input type="hidden" id="others_fee_details" name="others_fee_details" class="" value="{{$studentFee->others_fee_details}}">
            <input type="hidden" id="monthly_fee_total" name="monthly_fee_total" class="" value="{{$studentFee->monthly_fee_total}}">
            <input type="hidden" id="other_amount_total" name="other_amount_total" class="" value="{{$studentFee->other_amount_total}}">
            <input type="hidden" id="amount" name="amount" class="" value="{{$studentFee->amount}}">
            <label class="block font-medium text-sm text-gray-700 mb-1"> &nbsp </label>
            <div class="col-md-12" style="background: #9e93b9fa;box-shadow: 3px -4px 13px 0px #c6c6c6;text-align: center;padding: 5px 5px 1px 5px;color: #f5f5f5 !important;border: double;">

                <label class="block font-bold text-sm text-gray-700 mb-1"style="float: left;" >Total Amount</label>
                <div id="lebelAmount" class="block font-bold text-sm text-gray-700 mb-1"> {{$studentFee->amount}} </div>
            </div>

            <div class="col-md-12" style="background: #f59e0b00;padding: 0px;border-radius:20px;">
            <label class="block font-bold text-sm text-gray-700 mb-1">Entry Date</label>
            @php $entry_date = date("Y-m-d", strtotime($studentFee->entry_date)); @endphp
            <input type="date" id="entry_date" name="entry_date" class="form-control font-bold" value="{{$entry_date}}">
            </div>

            <div class="col-md-12" style="background: #f59e0b00;text-align: left;padding: 0px;border-radius:20px;">
                <label class="block font-bold text-sm text-gray-700 mb-1">Payment Method</label>
                <select id="payment_method" name="payment_method" class="form-control1">
                    <option @if($studentFee->payment_method=='cash') selected @endif value='cash'>Cash</option>
                    <option @if($studentFee->payment_method=='cheque') selected @endif value='cheque'>Cheque</option>
                    <option @if($studentFee->payment_method=='mobile_banking') selected @endif value='mobile_banking'>Mobile Banking</option>
                </select>
            </div>

            <div id="pm_cheque_wrapper" @if($studentFee->payment_method=='cash' || $studentFee->payment_method=='mobile_banking') hidden @endif>
                <div class="col-md-12" style="background: #f59e0b00;text-align: left;padding: 0px;border-radius:20px;">
                    <label class="block font-bold text-sm text-gray-700 mt-1">Bank Name</label>
                    <select id="bank_name" name="bank_name" class="form-control1">
                        <option value="">Select</option>
                        @if($banks)
                        @foreach($banks as $bank)
                            <option @if($studentFee->payment_method=='cheque' && $bank->id==$studentFee->bank_or_wallet_id) selected @endif  style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" value="{{$bank->id}}">{{$bank->name}}</option>';
                        @endforeach
                        @endif
                    </select>
                </div>

                @php
                if($studentFee->payment_method=='cheque'){
                    $acc_or_mobile_no = $studentFee->acc_or_mobile_no;
                }else{
                    $acc_or_mobile_no = '';
                }
                @endphp

                <div class="col-md-12" style="background: #f59e0b00;text-align: left;padding: 0px;border-radius:20px;">
                    <label class="block font-bold text-sm text-gray-700 mt-1">Cheque No</label>
                    <input type="text" id="cheque_no" name="cheque_no" class="form-control1 font-bold" value="{{$acc_or_mobile_no}}">
                </div>
            </div>

            <div id="pm_mobile_banking_wrapper" @if($studentFee->payment_method=='cash' || $studentFee->payment_method=='cheque') hidden @endif>
                <div class="col-md-12" style="background: #f59e0b00;text-align: left;padding: 0px;border-radius:20px;">
                    <label class="block font-bold text-sm text-gray-700 mt-1">Mobile Walet</label>
                    <select id="wallet_name" name="wallet_name" class="form-control1">
                        <option value="">Select</option>
                        @if($mobile_wallets)
                        @foreach($mobile_wallets as $mobile_wallet)
                            <option @if($studentFee->payment_method=='mobile_banking' && $mobile_wallet->id==$studentFee->bank_or_wallet_id) selected @endif  style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" value="{{$mobile_wallet->id}}">{{$mobile_wallet->name}}</option>';
                        @endforeach
                        @endif
                    </select>
                </div>

                @php
                if($studentFee->payment_method=='mobile_banking'){
                    $acc_or_mobile_no = $studentFee->acc_or_mobile_no;
                }else{
                    $acc_or_mobile_no = '';
                }
                @endphp

                <div class="col-md-12" style="background: #f59e0b00;text-align: left;padding: 0px;border-radius:20px;">
                    <label class="block font-bold text-sm text-gray-700 mt-1">Mobile No</label>
                    <input type="text" id="mobile_no" name="mobile_no" class="form-control1" value="{{$studentFee->acc_or_mobile_no}}">
                </div>
            </div>

            @php
            if($studentFee->discount>0){
                $checked='checked';
                $hide='';
            }else{
                $checked='';
                $hide='hide';
            }
            @endphp
            <div id="discount_wrapper {{$hide}}" class="col-md-12 mt-0" style="background: #ffa5a5;width: 100%;padding: 5px;border-radius: 10px;">
                <div class="col-md-12">
                    <input type="checkbox" {{$checked}} name="have_discount" id="have_discount" />
                    <label>
                        {{ __('translation.Have any discount ?') }}
                    </label>
                </div>

                <div class="have_discount_wrapper col-md-12 mt-2" style="background: #f59e0b00;text-align: left;padding: 0px;border-radius:20px;">
                    <label class="block font-bold text-sm text-gray-700 mb-1">Discount Amount ( Fixed)</label>
                    <input type="text" id="discount" name="discount" class="form-control1 font-bold" value="{{$studentFee->discount}}">
                </div>

                <div class="have_discount_wrapper col-md-12 mt-2" style="background: #f59e0b00;text-align: left;padding: 0px;border-radius:20px;">
                    <label class="block font-bold text-sm text-gray-700 mb-1">Note</label>
                    <input type="text" id="note" name="note" class="form-control1 font-bold" value="{{$studentFee->note}}">
                </div>
            </div>


            <div class="col-md-12" style="text-aign:left;background: #f59e0b00;text-align: center;padding: 30px;border-radius:20px;">
                <label class="block font-bold text-sm text-gray-700 mb-1">To Be Paid</label>
                <input type="text" id="paid" name="paid" class="form-control font-bold" value="{{$studentFee->paid}}">
            </div>

            <div class="text-center">
                <x-button color="green" id="__btnUpdateFee" class="mb-2 ml-1">
                    Update
                </x-button>
            </div>
        </div>
    </div>




    </x-card>
    @endif




{{-- modal-receipt --}}
<x-modal.modal-full class="modal-hide modal-receipt">
   <x-modal.header>
       <x-modal.title>
           {{ __('translation.Money Receipt') }}
       </x-modal.title>
       <x-modal.close-button id="closeModalReceipt" />
   </x-modal.header>
   <x-modal.body>
       <div class="pb-6 data-wrapper">

       </div>
   </x-modal.body>
</x-modal.modal-full>

@push('bottom_js')
<script type="text/javascript">


    jQuery("#have_discount").on("click", function(){
            check = $("#have_discount").is(":checked");
            $("#discount").val('');
            $("#note").val('');
            if(check) {
                $(".have_discount_wrapper").removeClass('hide');
            } else {
                $(".have_discount_wrapper").addClass('hide');
            }
        });


        jQuery("#discount").on("keyup", function(){
            let total_amount = $("#lebelAmount").html();
            let discount = $(this).val();
            let paid = total_amount-discount;
            if(paid) {
                $("#paid").val(paid);
            }
        });

   jQuery(".active_deactive_item").on("click", function(){
                   var id = $(this).data('id');
                   if($(this).prop("checked") == true){
                       jQuery('#others_fee').hide();
                       jQuery.ajax({
                                   type : 'POST',
                                   url: '{{ route('status_change_others_fee_field') }}',
                                   data : {id:id,status:'1'},
                                   success :  function(data)
                                   {
                                   //jQuery("#AjaxOthersPayment").html(data);
                                   //console.log(data);
                                   }
                                   });

                   }
                   else if($(this).prop("checked") == false){
                       jQuery('#others_fee').show();
                       jQuery.ajax({
                                   type : 'POST',
                                   url: '{{ route('status_change_others_fee_field') }}',
                                   data : {id:id,status:'0'},
                                   success :  function(data)
                                   {
                                  // jQuery("#AjaxOthersPayment").html(data);
                                   //console.log(data);
                                   }
                                   });
                   }
               });


               jQuery('#remove_area input[type="checkbox"]').click(function(){
                   var class_id = jQuery( "#class_id" ).val();
                   var session_id = jQuery( "#session_id" ).val();
                   if($(this).prop("checked") == true){

                       jQuery('#others_fee').hide();
                       jQuery.ajax({
                                   type : 'POST',
                                   url: '{{ route('add_remove_others_fee_field') }}',
                                   data : {class_id:class_id,session_id:session_id,checked:'true'},
                                   success :  function(data)
                                   {
                                   jQuery("#AjaxOthersPayment").html(data);
                                   //console.log(data);
                                   }
                                   });

                   }
                   else if($(this).prop("checked") == false){
                       jQuery('#others_fee').show();
                       jQuery.ajax({
                                   type : 'POST',
                                   url: '{{ route('add_remove_others_fee_field') }}',
                                   data : {class_id:class_id,session_id:session_id,checked:'false'},
                                   success :  function(data)
                                   {
                                   jQuery("#AjaxOthersPayment").html(data);
                                  // console.log(data);
                                   }
                                   });
                   }
               });


               jQuery(".active_deactive_item").on("click", function(){
                   alert($(this).val());
                   var class_id = jQuery( "#class_id" ).val();
                   var session_id = jQuery( "#session_id" ).val();
                   if($(this).prop("checked") == true){

                       jQuery('#others_fee').hide();
                       jQuery.ajax({
                                   type : 'POST',
                                   url: '{{ route('add_remove_others_fee_field') }}',
                                   data : {class_id:class_id,session_id:session_id,checked:'true'},
                                   success :  function(data)
                                   {
                                   jQuery("#AjaxOthersPayment").html(data);
                                   //console.log(data);
                                   }
                                   });

                   }
                   else if($(this).prop("checked") == false){
                       jQuery('#others_fee').show();
                       jQuery.ajax({
                                   type : 'POST',
                                   url: '{{ route('add_remove_others_fee_field') }}',
                                   data : {class_id:class_id,session_id:session_id,checked:'false'},
                                   success :  function(data)
                                   {
                                   jQuery("#AjaxOthersPayment").html(data);
                                   //console.log(data);
                                   }
                                   });
                   }
               });

               jQuery("#__btnUpdateFee").on("click", function(){
                   if($("#entry_date").val()==''){
                       alert("Please enter Date...");
                       return false;
                   }
                   if($("#paid").val()=='0'){
                       alert("Paid Amount can't be Zero...");
                       return false;
                   }

                   $.ajax({
                           url: '{{ route('studentFee.update') }}',
                           type: 'post',
                           data: {
                               'id': $("#id").val(),
                               'student_id': $("#student_id").val(),
                               'session_id': $("#session_id").val(),
                               'class_id': $("#class_id").val(),
                               'roll_no': $("#roll_no").val(),
                               'monthly_fee_fields': $("#monthly_fee_fields").val(),
                               'others_fee_fields': $("#others_fee_fields").val(),
                               'others_fee_details': $("#others_fee_details").val(),
                               'monthly_fee_total': $("#monthly_fee_total").val(),
                               'other_amount_total': $("#other_amount_total").val(),
                               'amount': $("#amount").val(),
                               'entry_date': $("#entry_date").val(),
                               'payment_method': $("#payment_method").val(),
                                'bank_name': $("#bank_name").val(),
                                'cheque_no': $("#cheque_no").val(),
                                'wallet_name': $("#wallet_name").val(),
                                'mobile_no': $("#mobile_no").val(),
                                'discount': $("#discount").val(),
                                'note': $("#note").val(),
                                'paid': $("#paid").val()
                           },
                           beforeSend: function() {

                           }
                       }).done(function(response) {

                           fn_show_receipt($("#id").val());
                       });
               });

               function fn_show_receipt(receipt_id){

                   $('.modal-receipt').removeClass('modal-hide');
                   $.ajax({
                           url: '{{ route('get_money_receipt') }}',
                           type: 'post',
                           data: {
                               'receipt_id': receipt_id,
                           },
                           beforeSend: function() {
                               $('.data-wrapper').html("Processing....");
                           }
                       }).done(function(result) {
                           console.log(result);
                           $('.data-wrapper').html(result);
                           if (result === 'success') {
                              // fn_print_receipt();
                           } else {

                           }
                       });

                   }

                   jQuery("#closeModalReceipt").on("click", function(){
                       $('.modal-receipt').addClass('modal-hide');
                   });

                   function clearMonthlyFee(){
				var elements = document.getElementById("monthlyFee").options;

				for(var i = 0; i < elements.length; i++){
				  elements[i].selected = false;
				}
                $("#monthly_fee_total").val('0');
                var TotalPayableFee = 0 + parseFloat($( "#other_amount_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);
			}

			function clearOthersFee(){
				var elements = document.getElementById("othersFee").options;

				for(var i = 0; i < elements.length; i++){
				  elements[i].selected = false;
				}
                $("#other_amount_total").val('0');
                var TotalPayableFee = parseFloat($( "#monthly_fee_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);
			}

                jQuery(document).on('change','#monthlyFee', { passive: true } ,function( e ) {
                    var MonthlyFeeTotalAmount = 0;
                    var fieldName = [];
                $( "#monthlyFee option:selected" ).each(function() {
                    MonthlyFeeTotalAmount += parseFloat($( this ).data('fee')) || 0;
                    fieldName.push($( this ).val());

                });

                $( "#monthly_fee_total" ).val(MonthlyFeeTotalAmount);
                $( "#monthly_fee_fields" ).val(fieldName.join(","));

                var TotalPayableFee = MonthlyFeeTotalAmount + parseFloat($( "#other_amount_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);

                });


                jQuery(document).on('change','#othersFee', { passive: true } ,function( e ) {
                    var othersFee = 0;
                    var fieldName = [];
                    var fieldValue = [];
                $( "#othersFee option:selected" ).each(function() {
                    othersFee += parseFloat($( this ).data('fee')) || 0;
                    fieldName.push($( this ).val());
                    fieldValue.push($( this ).data('fee'));

                });

                $( "#other_amount_total" ).val(othersFee);
                $( "#others_fee_fields" ).val(fieldName.join("@"));
                $( "#others_fee_details" ).val(fieldValue.join("@"));


                var TotalPayableFee = othersFee + parseFloat($( "#monthly_fee_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);

            });

            $(document).ready(function(){
                jQuery("#payment_method").on("change", function(){
                    if($(this).val()=='cheque'){
                        $("#pm_mobile_banking_wrapper").attr("hidden","hidden");
                        $("#pm_cheque_wrapper").removeAttr("hidden");
                    }
                    else if($(this).val()=='mobile_banking'){
                        $("#pm_cheque_wrapper").attr("hidden","hidden");
                        $("#pm_mobile_banking_wrapper").removeAttr("hidden");
                        $("#pm_mobile_banking_wrapper").removeAttr("hidden");
                    }else{
                        $("#pm_mobile_banking_wrapper").attr("hidden","hidden");
                        $("#pm_cheque_wrapper").attr("hidden","hidden");

                    }
                });
            });
</script>
@endpush
</x-app-layout>
