<x-app-layout>
    @section('title', 'Fee')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
    @endpush

    <style type="text/css">
       #AjaxOthersPayment ul li {
            border: 1px solid #ddd;
            margin-top: -1px;
            padding: 2px 12px;
            text-decoration: none;
            color: black;
            display: block;
            position: relative;
            text-align: left;
        }

        #AjaxOthersPayment input[type=checkbox], input[type=radio] {
            width: 28px !important;
            padding: 23px;
            height: 20px;
            margin-top: 1px;
            float: left;
        }

    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Student'))
        <x-card title="Take New Fee">

        <div>
            @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

            <div class="flex flex-col sm:flex-row sm:justify-between items-start mb-1">
                <div class="w-full md:w-1/2 lg:w-4/5 mb-6 sm:mb-0">
                    <div class="flex flex-row">
                        <div class="lg:col-span-1 mr-4">
                            <x-label>
                                {{ __('translation.Select Session') }}
                            </x-label>
                            <select name="session_id" id="__selectSessionFilter" class="session_id block w-full h-8 px-2 py-1 rounded-sm shadow-sm border border-solid border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 bg-white form-control">
                                <option value="" disabled>
                                    {{ '- ' . __('translation.Select Session') . ' -' }}
                                </option>
                                @if (isset($sessions))
                                    @foreach($sessions as $row)
                                        <option value="{{$row->id}}">{{$row->session_name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="lg:col-span-1 mr-4">
                            <x-label>
                                {{ __('translation.Select Class') }}
                            </x-label>
                            <select name="class_id" id="__selectClassFilter" class="class_id block w-full h-8 px-2 py-1 rounded-sm shadow-sm border border-solid border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 bg-white form-control">
                                <option value="" disabled>
                                    {{ '- ' . __('translation.Select Class') . ' -' }}
                                </option>
                                @if (isset($classes))
                                    @foreach($classes as $row)
                                        <option value="{{$row->id}}">{{$row->class_name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>


                        <div class="lg:col-span-1 mr-4">
                            <x-label>
                                {{ __('translation.Select Section') }}
                            </x-label>
                            <select name="section_id" id="__selectSectionFilter" class="section_id block w-full h-8 px-2 py-1 rounded-sm shadow-sm border border-solid border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 bg-white form-control">
                                <option value="" disabled>
                                    {{ '- ' . __('translation.Select Section') . ' -' }}
                                </option>
                                @if (isset($sections))
                                    @foreach($sections as $row)
                                        <option value="{{$row->id}}">{{$row->section_name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>



                        <div class="lg:col-span-1 mr-4">
                            <x-label>
                                {{ __('translation.Select Group') }}
                            </x-label>
                            <select name="group_id" id="__selectGroupFilter" class="group_id block w-full h-8 px-2 py-1 rounded-sm shadow-sm border border-solid border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 bg-white form-control">
                                <option value="" >
                                    {{ '- ' . __('translation.Select Group') . ' -' }}
                                </option>
                                @if (isset($groups))
                                    @foreach($groups as $row)
                                        <option value="{{$row->id}}">{{$row->group_name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>

                        <div class="lg:col-span-1 mr-4">
                            <x-label>
                                {{ __('translation.Roll No') }} <x-form.required-mark/>
                            </x-label>
                            <input type="text" name="roll_no" id="roll_no" class=" block w-full h-8 px-2 py-1 rounded-sm shadow-sm border border-solid border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 mt-1 bg-white form-control" required />
                        </div>
                    </div>
                </div>

                <div class="w-full md:w-1/2 lg:w-1/5 flex flex-row sm:justify-end py-5">
                    <button color="yellow" id="__btnResetLocalStorage" class="h-[1.5rem] relative top-[0.10rem] inline-flex items-center justify-center px-3 py-2 whitespace-nowrap bg-yellow-500 disabled:bg-yellow-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-yellow-600 active:bg-yellow-600 outline-none focus:outline-none focus:border-yellow-600 focus:ring ring-yellow-300 cursor-pointer disabled:opacity-50 disabled:cursor-not-allowed transition ease-in-out duration-150 mb-0 ml-2">
                        Reset
                    </button>
                </div>
            </div>



			<div id="__formCreateFee">
				<div id='AjaxFeePaymentWrapper'></div>
            </div>

    </x-card>
    @endif

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>

        <script>

            jQuery(document).on('change','#__selectSessionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_session', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectClassFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_class', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectSectionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_section', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectGroupFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_group', $(this).val());
                filterOthersFee();
            });

            if(localStorage.getItem('fee_taken_session')){
                var session_id = localStorage.getItem('fee_taken_session');
                $("#__selectSessionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_class')){
                var session_id = localStorage.getItem('fee_taken_class');
                $("#__selectClassFilter option[value='"+session_id+"']").prop('selected', true);
            }


            if(localStorage.getItem('fee_taken_section')){
                var session_id = localStorage.getItem('fee_taken_section');
                $("#__selectSectionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_group')){
                var session_id = localStorage.getItem('fee_taken_group');
                $("#__selectGroupFilter option[value='"+session_id+"']").prop('selected', true);
            }



            jQuery(document).on('click','#__btnResetLocalStorage', { passive: true } ,function( e ) {
                localStorage.removeItem('fee_taken_session');
                localStorage.removeItem('fee_taken_class');
                localStorage.removeItem('fee_taken_section');
                localStorage.removeItem('fee_taken_group');

                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectGroupFilter').val('').trigger('change');

            });


            $('#roll_no').on('keyup',function() {
                filterOthersFee();
            });


            function filterOthersFee(){

                var session_id = jQuery( "#__selectSessionFilter" ).val();
                var class_id = jQuery( "#__selectClassFilter" ).val();
                var section_id = jQuery( "#__selectSectionFilter" ).val();
                var group_id = jQuery( "#__selectGroupFilter" ).val();
				var roll_no = $('#roll_no').val();
                if(class_id && session_id){
                    jQuery('#others_fee').hide();
                    jQuery.ajax({
                                type : 'POST',
                                url: '{{ route('filter_others_fee') }}',
                                data : {class_id:class_id,session_id:session_id,section_id:section_id,group_id:group_id,roll_no:roll_no},
                                beforeSend: function() {
                                        $('#AjaxFeePaymentWrapper').html('processing...');
                                    }
                                }).done(function(data) {
                                    jQuery("#AjaxFeePaymentWrapper").html(data);

                                });

                }
            }

			function clearMonthlyFee(){
				var elements = document.getElementById("monthlyFee").options;

				for(var i = 0; i < elements.length; i++){
				  elements[i].selected = false;
				}
                $("#monthly_fee_total").val('0');
                var TotalPayableFee = 0 + parseFloat($( "#other_amount_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);
			}

			function clearOthersFee(){
				var elements = document.getElementById("othersFee").options;

				for(var i = 0; i < elements.length; i++){
				  elements[i].selected = false;
				}
                $("#other_amount_total").val('0');
                var TotalPayableFee = parseFloat($( "#monthly_fee_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);
			}

                jQuery(document).on('change','#monthlyFee', { passive: true } ,function( e ) {
                    var MonthlyFeeTotalAmount = 0;
                    var fieldName = [];
                $( "#monthlyFee option:selected" ).each(function() {
                    MonthlyFeeTotalAmount += parseFloat($( this ).data('fee')) || 0;
                    fieldName.push($( this ).val());

                });

                $( "#monthly_fee_total" ).val(MonthlyFeeTotalAmount);
                $( "#monthly_fee_fields" ).val(fieldName.join(","));

                var TotalPayableFee = MonthlyFeeTotalAmount + parseFloat($( "#other_amount_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);

                });


                jQuery(document).on('change','#othersFee', { passive: true } ,function( e ) {
                    var othersFee = 0;
                    var fieldName = [];
                    var fieldValue = [];
                $( "#othersFee option:selected" ).each(function() {
                    othersFee += parseFloat($( this ).data('fee')) || 0;
                    fieldName.push($( this ).val());
                    fieldValue.push($( this ).data('fee'));

                });

                $( "#other_amount_total" ).val(othersFee);
                $( "#others_fee_fields" ).val(fieldName.join("@"));
                $( "#others_fee_details" ).val(fieldValue.join("@"));


                var TotalPayableFee = othersFee + parseFloat($( "#monthly_fee_total" ).val());
                $( "#amount" ).val(TotalPayableFee);
                $( "#paid" ).val(TotalPayableFee);
                $( "#lebelAmount" ).html(TotalPayableFee);

                });

        </script>
    @endpush
</x-app-layout>
