<x-app-layout>
    @section('title', 'Staff')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.css">
    @endpush

    <style type="text/css">
        .nav>li a.active{
            background: #dbeafe;
        }
        .nav>li>a {
            position: relative;
            display: block;
            padding: 10px 15px;
            border: 1px solid #adb0b3;
            margin-right: 15px;
            background: #f9ffa5;
            color: black;
            border-radius: 7px;
        }
        #__formStaff {
            background: #90ebff;
            padding: 15px;
            border-radius: 20px;
        }
    </style>

    @if(\App\Models\Role::checkRolePermissions("Can access menu: Staff's - Staff's"))
        <div class="col-span-12">

        @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

        <x-card.card-default>
            <x-card.header>
                <x-card.back-button href="{{ route('staffs.index') }}" />
                <x-card.title>
                    {{ __('translation.Add Staff') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>

                <x-alert-danger class="alert mb-5 hidden" id="__alertDanger">
                    <span id="__content_alertDanger"></span>
                </x-alert-danger>

                <x-alert-success class="alert mb-5 hidden" id="__alertSuccess">
                    <span id="__content_alertSuccess"></span>
                </x-alert-success>

                <form method="POST" action="{{ route('staffs.store') }}" id="__formStaff" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" id="timestamp" name="timestamp" value="{{$timestamp}}">
                    <ul class="nav nav-pills">
                        <li>
                            <a class="active"  href="#po-info" data-toggle="tab">{{ __('translation.Personal Information') }}</a>
                        </li>

                        <li>
                            <a  href="#academic-background" data-toggle="tab">{{ __('translation.Academic Background') }}</a>
                        </li>

                        <li>
                            <a  href="#professional-info" data-toggle="tab">{{ __('translation.Professional Information') }}</a>
                        </li>

                        <li>
                            <a href="#account-details" data-toggle="tab">{{ __("translation.Account Details") }}</a>
                        </li>
                    </ul>

                    <div class="tab-content clearfix">
                        <div class="tab-pane active" id="po-info">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        Staff's Info
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>


                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-x-8">

                                    <div class="sm:col-span-2 lg:col-span-4 grid grid-cols-4 lg:grid-cols-4 gap-4 sm:gap-x-8">
                                        <div class="lg:col-span-3">
                                            <div class="sm:col-span-2 lg:col-span-3 grid grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8">

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Full Name') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="name" id="name" value="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        Father's Name <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="fathers_name" id="fathers_name" value="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        Mother's Name <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="mothers_name" id="mothers_name" value="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Mobile No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="mobile_no" id="mobile_no" value="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Email') }}
                                                    </x-label>
                                                    <x-input type="email" name="email" id="email" value="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.NID No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="nid" id="nid" class="nid" value="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Date Of Birth') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="dob" id="dob" class="datepicker-1" value="" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Nationality') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="nationality" id="nationality" value="Bangladeshi" required />
                                                </div>


                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Religion') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-select id="religion" name="religion" required style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select Relegion') }} -
                                                        </option>
                                                        <option value="Islam" >
                                                        - {{ __('translation.Islam') }} -
                                                        </option>
                                                        <option value="Hindu" >
                                                        - {{ __('translation.Hindu') }} -
                                                        </option>
                                                        <option value="Buddist" >
                                                        - {{ __('translation.Buddist') }} -
                                                        </option>
                                                        <option value="Christian" >
                                                        - {{ __('translation.Christian') }} -
                                                        </option>
                                                    </x-select>
                                                </div>


                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Blood Group') }}
                                                    </x-label>
                                                    <x-select id="blood_group" name="blood_group" style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Blood Group') }} -
                                                        </option>
                                                        <option value="A+" >
                                                            {{ __('translation.A+') }}
                                                        </option>
                                                        <option value="A-" >
                                                            {{ __('translation.A-') }}
                                                        </option>
                                                        <option value="B+" >
                                                            {{ __('translation.B+') }}
                                                        </option>
                                                        <option value="AB+" >
                                                            {{ __('translation.AB+') }}
                                                        </option>
                                                        <option value="AB-" >
                                                            {{ __('translation.AB-') }}
                                                        </option>
                                                        <option value="O+" >
                                                            {{ __('translation.O+') }}
                                                        </option>
                                                        <option value="O-" >
                                                            {{ __('translation.O-') }}
                                                        </option>

                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Gender') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-select id="gender" name="gender" style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select Gender') }} -
                                                        </option>
                                                        <option value="male" >
                                                            {{ __('translation.Male') }}
                                                        </option>
                                                        <option value="female" >
                                                            {{ __('translation.FeMale') }}
                                                        </option>
                                                        <option value="other" >
                                                            {{ __('translation.Other') }}
                                                        </option>
                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Marital Status') }}
                                                    </x-label>
                                                    <div class="flex flex-row">
                                                        <div>
                                                            <input type="radio" name="marital_status" id="unmerried" value="0" >
                                                                {{ __('translation.UnMerried') }}
                                                        </div>
                                                        <div class="ml-5">
                                                            <input type="radio" name="marital_status" id="merried" value="1" >
                                                                {{ __('translation.Merried') }}
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <div class="mb-2 sm:text-center">
                                                <x-label for="profile_photo">
                                                    {{ __('translation.Proifle Picture') }}
                                                </x-label>
                                            </div>


                                            <label for="profile_photo" class="profile_photo__wrapper block w-full sm:w-50 sm:mx-auto mt-2 border border-dashed border-gray-400 rounded-md relative bg-white shadow-sm cursor-pointer">
                                                <input type="file" name="profile_photo" id="profile_photo" class="profile_photo__field hidden" accept="image/*">
                                                <div class="p-2">
                                                    <div class="h-44 flex items-center justify-center">
                                                        <img name="upload_photo" style="max-width: 150px;margin-top: 25px;" src="" class="profile_photo__thumbnail w-full h-auto border border-solid border-gray-300 rounded-md">
                                                    </div>
                                                </div>
                                                <div class="h-7">
                                                    <button type="button" class="profile_photo__remove_button hidden1 pt-1 pb-2 w-full border-0 outline-none focus:outline-none bg-transparent text-center text-xs text-red-500 hover:underline">
                                                        {{ __('translation.Remove') }}
                                                    </button>
                                                </div>
                                            </label>
                                        </div>



                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                                {{ __('translation.Current Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Village') }}
                                            </x-label>
                                            <x-input type="text" name="village" id="village" value="" />
                                        </div>

                                        <div  class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code" id="__selectPostcodeFilter" class="post_code" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }}
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}" >{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila" id="__selectUpazilaFilter" class="upazila" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }}
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['name']}}" >{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.District') }}
                                            </x-label>
                                            <x-select name="district" id="__selectDistrictFilter" class="district" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['name']}}" >{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                                {{ __('translation.Permanent Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="lg:col-span-4">
                                            <input type="checkbox" name="same_as_current" id="same_as_current" />
                                            <label>
                                                {{ __('translation.Same as Current') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Village') }}
                                            </x-label>
                                            <x-input type="text" name="village_permanent" id="village_permanent" value="" />
                                        </div>


                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code_permanent" id="__selectPostcodeFilterPermanent" class="post_code_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }}
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}" >{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila_permanent" id="__selectUpazilaFilterPermanent" class="upazila_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }}
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" >{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.District') }}
                                            </x-label>
                                            <x-select name="district_permanent" id="__selectDistrictFilterPermanent" class="district_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" >{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane" id="academic-background">
                            @php $educational_qualifications = [
                                                                'ssc'=>'SSC',
                                                                'hsc'=>'HSC',
                                                                'honours'=>'Honours',
                                                                'masters'=>'Masters',
                                                            ];
                        // dd($educational_qualifications);
                            @endphp

                            @foreach($educational_qualifications as $key=>$value)
                                <div class="mb-10">
                                    <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                        <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                            {{$value}} Details
                                        </h2>
                                        <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                    </div>

                                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                        <div>
                                            <x-label>
                                                {{ __("Group/Subject") }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="group_or_subject[]" name="group_or_subject" style="width: 100%" value="" ></x-input>
                                        </div>

                                        <div>
                                            <x-label>
                                                {{ __("Institute Name") }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="text" name="institute[]" style="width: 100%" value=""></x-input>
                                        </div>

                                        <div>
                                            <x-label>
                                                {{ __("GPA") }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="text" name="gpa[]" style="width: 100%" value=""></x-input>
                                        </div>

                                        <div>
                                            <x-label>
                                                {{ __("Year In Completed") }} <x-form.required-mark/>
                                            </x-label>
                                            <x-input type="text" name="year_in_completed[]" style="width: 100%" value=""></x-input>
                                        </div>

                                        <div>
                                            <x-label>
                                                {{ __("Board") }}
                                            </x-label>
                                            <x-input type="text" name="board[]" style="width: 100%" value=""></x-input>
                                        </div>

                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <div class="tab-pane" id="professional-info">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Professional Details') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Designation") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-select name="designation">
                                            <option value="Staff" >Staff</option>
                                            <option value="Assistant Staff" >Assistant Staff</option>
                                            <option value="Head Staff" >Head Staff</option>
                                        </x-select>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Designation Type") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-select name="designation_type">
                                            <option value="" >Select</option>
                                            <option value="Regular" >Regular</option>
                                            <option value="Sectional" >Sectional</option>
                                            <option value="Surplus" >Surplus</option>
                                        </x-select>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Subject/Course") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="subject_or_course_name" id="subject_or_course_name" value="" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Index No") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="index_no" id="index_no" style="width: 100%" value="" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Payment/Salary Stataus") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="salary_status" id="salary_status" style="width: 100%" value=""></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Pay Code") }}
                                        </x-label>
                                        <x-input type="text" name="pay_code" id="pay_code" style="width: 100%" value=""></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Basic Salary") }}
                                        </x-label>
                                        <x-input type="text" name="basic_salary" id="basic_salary" style="width: 100%" value=""></x-input>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="account-details">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Bank Details') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Bank Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="bank_name" id="bank_name" value="" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Branch Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="branch_name" id="branch_name" value=""></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Routing No") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="routing_no" id="routing_no" value=""></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Bank Account Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="bank_account_name" id="bank_account_name" value=""></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Bank Account No.") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="bank_account_no" id="bank_account_no" value=""></x-input>
                                    </div>

                                </div>
                            </div>
                        </div>


                    </div>


                    <div class="text-center pb-5">
                        <x-button type="submit" color="blue" id="__btnSubmitStaff">
                            {{ __('translation.Submit Data') }}
                        </x-button>
                    </div>

                </form>

            </x-card.body>
        </x-card.card-default>
    </div>
    @endif



    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
        <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.js"></script>
        <script src="{{ asset('pages/admin/staff/form_update.js?_=' . rand()) }}"></script>

        <script>

			$('#__selectDivisionFilter').select2({
                width: 'resolve'
            });

            $('#__selectDistrictFilter').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilter').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilter').select2({
                width: 'resolve'
            });

            //Permanent
            $('#__selectDistrictFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilterPermanent').select2({
                width: 'resolve'
            });




			$(".datepicker-1").datepicker({
                dateFormat: 'yy-mm-dd',
				 changeMonth: true,
				 changeYear: true,
				 yearRange: "-20:+0",
            });

            $("#is_phyically_disabled").on("click", function(){
                check = $("#is_phyically_disabled").is(":checked");
                if(check) {
                    $(".phyically_disabled_box").removeClass('hide');
                } else {
                    $(".phyically_disabled_box").addClass('hide');
                }
            });


            $("#is_siblings_study_here").on("click", function(){
                check = $("#is_siblings_study_here").is(":checked");
                if(check) {
                    $(".siblings_box").removeClass('hide');
                    $("#AjaxSiblingsInfoWrapper").removeClass('hide');

                } else {
                    $(".siblings_box").addClass('hide');
                    $("#AjaxSiblingsInfoWrapper").addClass('hide');
                }
            });


            jQuery(document).on('change','#__selectClassFilter', { passive: true } ,function( e ) {
               let class_name = $("#__selectClassFilter  option:selected").text().toLowerCase();
            // Show JSC OR PSC Area
               fn_jsc_psc_wrapper_view(class_name);

                localStorage.setItem('fee_taken_class', $(this).val());
            });

            function fn_jsc_psc_wrapper_view(class_name){
                if(class_name =='six'){
                    $(".psc_info").removeClass('hide');
                    $(".jsc_info").addClass('hide');
                }else if(class_name=='nine'){
                    $(".jsc_info").removeClass('hide');
                    $(".psc_info").addClass('hide');
                }else{
                    $(".jsc_info").addClass('hide');
                    $(".psc_info").addClass('hide');
                }
            }



            $("#same_as_current").on("click", function(){
                check = $("#same_as_current").is(":checked");
                if(check) {
                    $(".permanent").addClass('hide');
                } else {
                    $(".permanent").removeClass('hide');
                }
            });


            $('#__formStaff').submit(function(event) {
                event.preventDefault();
                let formData = new FormData($(this)[0]);
                $.ajax({
                    type: $(this).attr('method'),
                    url: $(this).attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('#__btnSubmitStudent').attr('disabled', true).html('{{ __('translation.Processing') }}');
                        $('.alert').addClass('hidden');
                    },
                    success: function(responseJson) {
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        console.log(responseJson);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        $('.alert').addClass('hidden');
                        $('#__alertSuccess').removeClass('hidden');
                        $('#__content_alertSuccess').html(null);
                        $('#__content_alertSuccess').html(responseJson.message);
                        setTimeout(() => {
                           window.location.href = '{{ route('staffs.index') }}';
                        }, 1500);
                    },
                    error: function(response) {
                        let responseJson = response.responseJSON;
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        $('.alert').addClass('hidden');
                        $('#__alertDanger').removeClass('hidden');
                        $('#__content_alertDanger').html(null);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        if (response.status == 422) {
                            let errorFields = Object.keys(responseJson.errors);
                            errorFields.map(field => {
                                $('#__content_alertDanger').append(
                                    $('<div/>', {
                                        html: responseJson.errors[field][0],
                                        class: 'mb-2'
                                    })
                                );
                            });
                        }
                        else {
                            $('#__content_alertDanger').html(responseJson.message);
                        }
                    }
                });
                return false;
            });
        </script>
    @endpush

</x-app-layout>
