<x-app-layout>
    @section('title')
    School Information Settings
    @endsection

    @push('top_css')
	    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.css">
    @endpush

    <div class="col-span-12">
        <x-card.card-default>
            <x-card.body>
                @include('settings.menu')
            </x-card.body>
        </x-card.card-default>

        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    School Information Settings
                </x-card.title>
            </x-card.header>
            <x-card.body>
                <div class="pb-3 w-full lg:w-3/5 lg:mx-auto">
                    <form action="{{ route('school-info-settings.update') }}" method="post" id="__formUpdateSchoolInfo">
                        @csrf
                        <div class="mb-5">
                            <div class="mb-2 sm:text-center">
                                <x-label for="school_logo">
                                    {{ __('translation.Logo') }}
                                </x-label>
                            </div>
                            <label for="school_logo" class="school_logo__wrapper block w-full sm:w-60 sm:mx-auto mt-2 border border-dashed border-gray-400 rounded-md relative bg-white shadow-sm cursor-pointer">
                                <input type="file" name="school_logo" id="school_logo" class="school_logo__field hidden" accept="image/*">
                                <div class="p-2">
                                    <div class="h-44 flex items-center justify-center">
                                        <img src="{{asset($settings->school_logo)}}" class="school_logo__thumbnail w-full h-auto border border-solid border-gray-300 rounded-md">
                                    </div>
                                </div>
                                <div class="h-7">
                                    <button type="button" class="school_logo__remove_button hidden pt-1 pb-2 w-full border-0 outline-none focus:outline-none bg-transparent text-center text-xs text-red-500 hover:underline">
                                        {{ __('translation.Remove') }}
                                    </button>
                                </div>
                            </label>
                        </div>

                        <div class="mb-5">
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-x-8">
                                <div class="sm:col-span-2">
                                    <x-label>
                                        School Name <x-form.required-mark/>
                                    </x-label>
                                    <x-input type="text" name="school_name" id="__school_nameUpdateSchoolInfo" value="{{$settings->school_name}}" />
                                </div>
                                <div>
                                    <x-label>
                                        Established <x-form.required-mark/>
                                    </x-label>
                                    <x-input type="text" name="established" id="__tax_numberUpdateSchoolInfo" value="{{$settings->established}}" />
                                </div>
                                <div>
                                    <x-label>
                                        Phone Number <x-form.required-mark/>
                                    </x-label>
                                    <x-input type="text" name="school_phone" id="__school_phoneUpdateSchoolInfo" value="{{$settings->school_phone}}" />
                                </div>
                                <div class="sm:col-span-2">
                                    <x-label>
                                        Address <x-form.required-mark/>
                                    </x-label>
                                    <x-textarea name="school_address" id="__school_addressUpdateSchoolInfo" rows="3">{{$settings->school_address}}</x-textarea>
                                </div>
                            </div>
                        </div>

                        <div class="text-center">
                            <x-button type="submit" color="blue" id="__btnSubmitUpdateSchoolInfo">
                                Update Data
                            </x-button>
                        </div>
                    </form>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>

    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.js"></script>

        <script src="{{ asset('pages/admin/settings/school_info_settings/form_update.js?_=' . rand()) }}"></script>
    @endpush
</x-app-layout>
