<x-app-layout>
    @section('title', 'Students')

    @push('top_css')
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
    @endpush

    <style type="text/css">
        .nav>li a.active{
            background: #dbeafe;
        }
        .nav>li>a {
            position: relative;
            display: block;
            padding: 10px 15px;
            border: 1px solid #adb0b3;
            margin-right: 15px;
            box-shadow: -2px 4px 9px 0px #aeacac;
        }
    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
        <div class="col-span-12">
        @if ($errors->any())
            <x-alert-danger class="mb-5">
                <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                    @foreach ($errors->all() as $error)
                        <li>
                            {{ $error }}
                        </li>
                    @endforeach
                </ul>
            </x-alert-danger>

        @endif

        <x-card.card-default>
            <x-card.header>
                <x-card.back-button href="" />
                <x-card.title>
                {{ __('Set Fee') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>

                <x-alert-danger class="alert mb-5 hidden" id="__alertDanger">
                    <span id="__content_alertDanger"></span>
                </x-alert-danger>

                @if(session()->has('success'))
                <x-alert-success class="alert mb-5" id="__alertSuccess">
                    {{ session()->get('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    </x-alert-success>
            @endif



                <form method="POST" action="{{ route('settings.fee.store') }}" id="__formFeeSettings" enctype="multipart/form-data">
                    @csrf

                    <ul  class="nav nav-pills">
                        @foreach($classes as $key=>$class)
                            <li @if($key==0) class="active" @endif>
                                <a  class="{{$class->active}}" href="#fee-{{$class->id }}" data-toggle="tab">{{$class->class_name }}</a>
                            </li>
                        @endforeach
                    </ul>



                    <div class="lg:col-span-1 mb-5 mt-10">
                        <x-label>
                            {{ __('translation.Session') }} <x-form.required-mark/>
                        </x-label>

                        <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                            <option value="" disabled>
                                {{ '- ' . __('translation.Select Session') . ' -' }}
                            </option>
                            @if (isset($sessions))
                                @foreach($sessions as $row)
                                    <option @if($currentSession_id =='{{$row->id}}') selected @endif value="{{$row->id}}">{{$row->session_name}}</option>
                                @endforeach
                            @endif
                        </x-select>
                    </div>

                    <div id="Ajaxfee-wrapper">
						<div class="tab-content clearfix">
							@foreach($classes as $class)
							<div class="tab-pane {{$class->active}}" id="fee-{{$class->id}}">
								<div class="mb-10">
									<div class="flex flex-row items-center justify-between mb-3 mt-3">
										<h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
											{{ __('translation.Class') }} {{$class->class_name}}
										</h2>
										<hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
									</div>

									<div class="sm:col-span-2 lg:col-span-4 grid grid-cols-4 lg:grid-cols-4 gap-4 sm:gap-x-8">

									 @foreach($feeTypes as $feeType)
										<div class="lg:col-span-1">
											<x-label>
											{{$feeType->name }} <x-form.required-mark/>
											</x-label>
										   @if(!empty($feeType->fee_types_amount))
											   @foreach($feeType->fee_types_amount as $feeAmount)
													@php
														if($feeAmount->class_id==$class->id){
															$amount = $feeAmount->amount;
															break;
														}else{
															$amount = 0;
														}
													@endphp
												@endforeach
											<x-input type="number" name="{{$class->class_name}}[{{$feeType->id }}]" id="fee" class="" placeholder="Enter Amount" value='{{$amount}}'/>
											@else
											<x-input type="number" name="{{$class->class_name}}[{{$feeType->id }}]" id="fee" class="" placeholder="Enter Amount" />
											@endif

										</div>
										@endforeach
									</div>


								</div>

							</div>
							@endforeach

						</div>

					</div>
                    <div class="text-center pb-5">
                        <x-button type="submit" color="blue" id="__btnSubmitPurchaseOrder">
                            {{ __('translation.Submit Data') }}
                        </x-button>
                    </div>

                </form>

            </x-card.body>
        </x-card.card-default>

    @endif



	</div>


    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
        <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script>

            window.localStorage.removeItem('newPOProducts'); // Clear on Page Reload
            window.localStorage.removeItem('newShippingDetails'); // Clear on Page Reload

            $('#__selectSessionFilter').select2({
                width: 'resolve'
            });

            $('#__selectSessionFilter').on('change',function() {
                let sessionId = $('#__selectSessionFilter').val();
                $.ajax({
                       type: 'POST',
                        url: '{{ route('settings.fee.getFeeBySessionId') }}',
                        data: {
                            sessionId : sessionId
                        },
                    beforeSend: function() {

                        $('#Ajaxfee-wrapper').html('processing...');
                    }
                }).done(function(result) {
                    $('#Ajaxfee-wrapper').html(result);


                });
            });
        </script>
    @endpush

</x-app-layout>
