<x-app-layout>

    @section('title')
        {{ __('translation.Marks Import Excel') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

 @endpush


<style type="text/css">
.select2-container {
}

.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}
</style>
    @if(\App\Models\Role::checkRolePermissions('Can access menu: Marks - Marks'))
    <div class="col-span-12">
        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    {{ __('translation.Marks Import Excel') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>
            <div class="mt-6">
        @if (session('success'))
            <x-alert-success>
                {{ session('success') }}
            </x-alert-success>
        @endif

        @if (session('danger'))
            <x-alert-danger>
                {{ session('danger') }}
            </x-alert-danger>
        @endif

        @if (session('error'))
            <x-alert-danger>
                {{ session('error') }}
            </x-alert-danger>
        @endif
    </div>
                <div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">
                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Class') . ' -' }}
                                    </option>
                                    @if (isset($classes))
                                        @foreach ($classes as $classe)
                                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                    <option value="0" disabled>
                                        {{ '- ' . __('translation.Select Section') . ' -' }}
                                    </option>
                                    @if (isset($sections))
                                        @foreach ($sections as $section)
                                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                                        @endforeach
                                    @endif

                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="session_id" id="__selectSessionFilter" class="session" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Session') . ' -' }}
                                    </option>
                                    @if (isset($sessions))
                                        @foreach ($sessions as $session)
                                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>


                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="subject_id" id="__selectSubjectFilter" class="subject_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Subject ') . ' -' }}
                                    </option>
                                    @if (isset($subjects))
                                        @foreach ($subjects as $subject)
                                            <option value="{{$subject->id}}">{{$subject->name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>


                            
                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="mark_types" id="__selectMarkTypeFilter"  multiple="multiple" class="mark_types" style="width: 100%;">
                                    <option value="0" disabled>
                                        {{ '- ' . __('translation.Select Mark Type') . ' -' }}
                                    </option>
                                    @if (isset($mark_types))
                                        @foreach ($mark_types as $mark_type)
                                            <option value="{{$mark_type->id}}">{{$mark_type->type}}</option>
                                        @endforeach
                                    @endif

                                </x-select>
                            </div>


                            <div class="w-full md:w-1/4 lg:w-1/3 xl:w-1/2 flex items-center justify-end lg:justify-start lg:ml-2 mt-2">
                            <x-button type="button" color="blue" class="relative -top-1 order-last md:order-first mx-1" id="__btnSubmitFilter">
                                {{ __('translation.Search') }}
                            </x-button>
                            <x-button type="button" color="yellow" class="relative -top-1 reset-filter" id="__btnResetFilter">
                                {{ __('translation.Reset') }}
                            </x-button>

                            <x-button type="button" color="green" class="relative -top-1 reset-filter" id="__btnExcelExport">
                                {{ __('translation.Export') }}
                            </x-button>
                        </div>

                        </div>

                    </div>
                </div>



                <form action="{{ route('marks.excel_import_file') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="file" name="file" class="form-control">
                <br>
                <button class="btn btn-success">{{ __('translation.Import Marks') }}</button>
                </form>

                <button data-session_id="15" data-class_id="15" data-student_id="4" id="exportMarkSheet" class="btn btn-success">{{ __('translation.Mark Sheet') }}</button>
                <div class="overflow-x-auto">
                    <table class="w-full" id="datatable">
                        <thead>
                            <tr>
                                <th class="text-center">ID</th>
                                <th class="text-left">Student Name</th>
                                <th class="text-center">Roll No</th>
                                <th class="text-center">Class Name</th>
                                <th class="text-center">Section</th>
                                <th class="text-center">Session</th>
                                @if (isset($mark_types))
                                    @foreach ($mark_types as $mark_type)
                                    <th hidden id="type_{{$mark_type->id}}" class="text-center">{{$mark_type->type}}</th>
                                    @endforeach
                                @endif
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>
    @endif

    <x-modal.modal-large class="modal-excel modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Excel Export
            </x-modal.title>
            <x-modal.close-button id="closeModalproduct" />
        </x-modal.header>
        <x-modal.body>
        <div id="excel-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-large>


    <x-modal.modal-full class="modal-mark-sheet modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Mark Sheet
            </x-modal.title>
            <x-modal.close-button id="closeModalMarkSheet" />
        </x-modal.header>
        <x-modal.body>
        <div id="mark-sheet-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-full>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            const dataTabletUrl = '{{ route('marks_entry_form_datatable') }}';
            const excelExportUrl = '{{ route('excel_export_marks_entry_form') }}';
            const markSheetUrl = '{{ route('mark_sheet_view') }}';

            const loadOrderAnalysisDataTable = (classId,sectionId, sessionId,subjectId,markTypes) => {
                //console.log(sectionId);
                $('#datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    ajax: {
                        type: 'GET',
                        url: dataTabletUrl,
                        data: {
                            classId: classId,
                            sectionId: sectionId,
                            sessionId: sessionId,
                            subjectId: subjectId,
                            markTypes : markTypes
                        },
                        dataSrc: function ( json ) {
                            const markTypes_arr = json.input.markTypes;
                            if(markTypes_arr){
                                for (let i = 0; i < markTypes_arr.length; i++) {                            
                                    $("#type_"+markTypes_arr[i]).removeAttr("hidden");
                                }
                            }
                            return json.data;
                        }
                    },


                    columns: [
                        {
                            name: 'id',
                            data: 'id'
                        },
                        {
                            name: 'name',
                            data: 'name'
                        },
                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },
                        {
                            name: 'class_name',
                            data: 'class_name'
                        },
                        {
                            name: 'section_name',
                            data: 'section_name'
                        },
                        {
                            name: 'session_name',
                            data: 'session_name'
                        }
                    ],
                    columnDefs: [
                        {
                            targets: [1, 4],
                            orderable: false
                        },
                        {
                            targets: [0,2,3,4,5],
                            className: 'text-center'
                        },
                        { "width": "22%", "targets": 1 },
                        { "width": "23%", "targets": 3 },
                    ],
                    paginationType: 'numbers'
                });
            }

            let classId = $('#__selectClassFilter').val();
            let sectionId = $('#__selectSectionFilter').val();
            let sessionId = $('#__selectSessionFilter').val();
            let subjectId = $('#__selectSubjectFilter').val();
            let markTypes = $('#__selectMarkTypeFilter').val();
            if(classId==null){ classId=0; }
            if(sectionId==null){ sectionId=0; }
            if(sessionId==null){ sessionId=0; }
            if(subjectId==null){ subjectId=0; }               
             

            loadOrderAnalysisDataTable(classId,sectionId, sessionId,subjectId,markTypes);


            $(document).ready(function() {

                $('#__selectSectionFilter').select2({
                    placeholder: '- Select Section -',
                    allowClear: true
                });

                $('#__selectClassFilter').select2({
                    placeholder: '- Select Class -',
                    allowClear: true
                });

                $('#__selectSessionFilter').select2({
                    placeholder: '- Select Session -',
                    allowClear: true
                });
                
                $('#__selectSubjectFilter').select2({
                    placeholder: '- Select Subject -',
                    allowClear: true
                });

                
                
                $('#__selectMarkTypeFilter').select2({
                    placeholder: '- Select Mark Type -',
                    allowClear: true
                });

                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
                $('#__selectMarkTypeFilter').val('').trigger('change');
                
            });


            $('#__btnSubmitFilter').click(function() {
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let markTypes = $('#__selectMarkTypeFilter').val();
                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }
                
             

            loadOrderAnalysisDataTable(classId,sectionId, sessionId,subjectId,markTypes);

            });

            // Handle to Reset Dropdown,Input fields
            $('#__btnResetFilter').on('click',function() {
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let markTypes = $('#__selectMarkTypeFilter').val();
                
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }

                loadOrderAnalysisDataTable(classId,sectionId, sessionId,subjectId,markTypes);

                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
                $('#__selectMarkTypeFilter').val('').trigger('change');
            });


           // Handle to Export as a excel file
            $(document).on('click', '#__btnExcelExport', function() {

                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let markTypes = $('#__selectMarkTypeFilter').val();
                
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }


                $.ajax({
                       type: 'GET',
                        url: excelExportUrl,
                        data: {
                            excel: 1,
                            excelSearch: excelSearch,
                            classId: classId,
                            sectionId: sectionId,
                            sessionId: sessionId,
                            subjectId: subjectId,
                            markTypes : markTypes
                        },
                    beforeSend: function() {
                        $('#excel-wrapper').html('processing...');
                        $('.modal-excel').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);
                    let downloadLink = '<a href="'+result+'" download >Download Now</a>';
                    $('#excel-wrapper').html(downloadLink);
                });
            });




            $('#closeModalproduct').click(function() {
                $('.modal-excel').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

            $('#exportMarkSheet').click(function() {
                var session_id = $(this).data('session_id');
                var class_id = $(this).data('class_id');
                var student_id = $(this).data('student_id');
               
                $.ajax({
                       type: 'GET',
                        url: markSheetUrl,
                        data: {
                            session_id: session_id,
                            class_id: class_id,
                            student_id : student_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('processing...');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);
                    
                    $('#mark-sheet-wrapper').html(result);
                });

            });
            
            $('#closeModalMarkSheet').click(function() {
                $('.modal-mark-sheet').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush

</x-app-layout>
