<x-app-layout>
    @section('title', 'Merit List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">


    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

@if(\App\Models\Role::checkRolePermissions('Can access menu: Results - Results'))


    <x-card title="{{ __('translation.Merit List') }}">
        <div class="col-span-12">
            @if (session('success'))
                <x-alert-success>
                    {!! session('success') !!}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif
        </div>



        <form method="POST" action="{{route('download_merit_list')}}" enctype="multipart/form-data">
            @csrf
        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <label class="mb-0">
                    {{ __('translation.Exam Name') }} :
                </label>
                <x-select class="exam_id"  id="__selectExamFilter" name="exam_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Exam') . ' -' }}
                    </option>
                    @if (isset($exams))
                        @foreach ($exams as $exam)
                          <option value="{{$exam->id}}">
                            {{$exam->exam_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <label class="mb-0">
                    {{ __('translation.Class') }} :
                </label>
                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Class') . ' -' }}
                    </option>
                    @if (isset($classes))
                        @foreach ($classes as $classe)
                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <label class="mb-0">
                    {{ __('translation.Section') }} :
                </label>
                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Section') . ' -' }}
                    </option>
                    @if (isset($sections))
                        @foreach ($sections as $section)
                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <label class="mb-0">
                    {{ __('translation.Session') }} :
                </label>
                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Session') . ' -' }}
                    </option>
                    @if (isset($sessions))
                        @foreach ($sessions as $session)
                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-1/4 mb-6 lg:mb-0 ml-2 mt-6">
                <x-button color="green" id="BtnPDFMarkSheet" data-toggle="modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-download" viewBox="0 0 16 16">
                        <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                        <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
                    </svg>
                    <span class="ml-2">
                        {{ __('translation.Download') }}
                    </span>
                </x-button>
            </div>
        </div>
        </form>

        <div class="overflow-x-none">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.Details') }}
                        </th>

                        <th>
                            {{ __('translation.Name') }}
                        </th>

                        <th>
                            {{ __('translation.Student Id') }}
                        </th>

                        <th>
                            {{ __('translation.Roll No') }}
                        </th>

                        <th>
                            {{ __('translation.Class') }}
                        </th>

                        <th>
                            {{ __('translation.Section') }}
                        </th>

                        <th>
                            {{ __('translation.Session') }}
                        </th>

                        <th>
                            {{ __('translation.Academic Result') }}
                        </th>


                        <th>
                            {{ __('translation.Merit Position') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
   @endif



    <x-modal.modal-full class="modal-mark-sheet modal-hide">
        <x-modal.header>
            <x-modal.title>
                Processing...
            </x-modal.title>
            <x-modal.close-button id="closeModalMarkSheet" />
        </x-modal.header>
        <x-modal.body>
        <div id="mark-sheet-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('result.merit_list_datatable') }}';
            var status = 'all';

            function loadStudentsTable(url) {
                $('#__studentTable').dataTable({
                    processing: true,
                    serverSide: true,
                   // ajax: url,
                    "ajax": {
                        "url": url,
                        data: {
                            examId: $("#__selectExamFilter").val(),
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                        console.log(json);
                        if(json.supplier !='' && json.draw=='1'){
                        $(".all .order-purchase__filter-total").html(" ("+json.suppliersCountAll+")");
                        $(".open .order-purchase__filter-total").html(" ("+json.suppliersCountOpen+")");
                        $(".arrive .order-purchase__filter-total").html(" ("+json.suppliersCountArrive+")");

                        $(".closes .order-purchase__filter-total").html(" ("+json.suppliersCountClose+")");
                        }
                         return json.data;
                        }
                    },
                    columns: [

                        {
                            name: 'details',
                            data: 'details'
                        },

                        {
                            name: 'name',
                            data: 'name'
                        },

                        {
                            name: 'student_code',
                            data: 'student_code'
                        },

                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },

                        {
                            name: 'class_name',
                            data: 'class_name'
                        },

                        {
                            name: 'section_name',
                            data: 'section_name'
                        },

                        {
                            name: 'session_name',
                            data: 'session_name'
                        },

                        {
                            name: 'academic_result',
                            data: 'academic_result'
                        },
                        {
                            name: 'merit_position',
                            data: 'merit_position'
                        }
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                       {
                            targets: [0,1,2,3,4,5,6,7],
                            orderable: false,
                            className: 'text-center'
                        },

                        {
                            targets: [8],
                            orderable: true,
                            className: 'text-center'
                        },


                    ],
                    order: [
                        [ 8, 'asc' ]
                    ]
                });
            }

            loadStudentsTable(studentTableUrl);

            $('#__selectExamFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectClassFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });


            $('input[type="search"]').on('keyup', function(e) {
                $("#arrive_or_over_due").select2('val', '0')
                $("#supplier_id").select2("val", "0");
            });


            $('#__selectExamFilter').select2({
                width: 'resolve',
                placeholder: '- Select Exam -',
                allowClear: true
            });

            $('#__selectSessionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Session -',
                allowClear: true
            });

            $('#__selectClassFilter').select2({
                width: 'resolve',
                placeholder: '- Select Class -',
                allowClear: true
            });

            $('#__selectSectionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Section -',
                allowClear: true
            });



            const meritListDownloadUrl = '{{ route('download_merit_list') }}';
            $(document).on('click', '#BtnPDFMarkSheet', function() {
                var exam_id = $("#__selectExamFilter").val();
                var session_id = $("#session_id").val();
                var class_id = $("#class_id").val();
                $.ajax({
                       type: 'POST',
                        url: meritListDownloadUrl,
                        data: {
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('Merit List Processing...Please wait....');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                    $('#mark-sheet-wrapper').html(result);
                });
            });

            $('#closeModalMarkSheet').click(function() {
                $('.modal-mark-sheet').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
