<x-app-layout>

    @section('title')
        {{ __('translation.Marks Entry Form') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

 @endpush
 @push('top_css')

<style type="text/css">
.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}

.select2-container .select2-search--inline .select2-search__field {
    box-sizing: border-box;
    border: none;
    font-size: 100%;
    margin-top: 9px !important;
    margin-left: 5px;
    vertical-align: bottom;
    font-family: unset !important;
}

.even {
    background: #f7d2d8;
}
td table td{
    border:1px solid red !important;
}

</style>
@endpush
    @if(\App\Models\Role::checkRolePermissions('Can access menu: Results - Results'))
    <div class="col-span-12">
        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    {{ __('translation.Marks Report By Subject') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>
            <div class="mt-6">
        @if (session('success'))
            <x-alert-success>
                {{ session('success') }}
            </x-alert-success>
        @endif

        @if (session('danger'))
            <x-alert-danger>
                {{ session('danger') }}
            </x-alert-danger>
        @endif

        @if (session('error'))
            <x-alert-danger>
                {{ session('error') }}
            </x-alert-danger>
        @endif
    </div>
                <div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="exam_id" id="__selectExamFilter" class="exam_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Exam') . ' -' }}
                                    </option>
                                    @if (isset($exams))
                                        @foreach ($exams as $exam)
                                            <option value="{{$exam->id}}">{{$exam->exam_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Class') . ' -' }}
                                    </option>
                                    @if (isset($classes))
                                        @foreach ($classes as $classe)
                                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                    <option value="0" disabled>
                                        {{ '- ' . __('translation.Select Section') . ' -' }}
                                    </option>
                                    @if (isset($sections))
                                        @foreach ($sections as $section)
                                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                                        @endforeach
                                    @endif

                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Session') . ' -' }}
                                    </option>
                                    @if (isset($sessions))
                                        @foreach ($sessions as $session)
                                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>
                        </div>
                    </div>
                </div>

				<div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">
                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="subject_id" id="__selectSubjectFilter" class="subject_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Subject ') . ' -' }}
                                    </option>
                                    @if (isset($subjects))
                                        @foreach ($subjects as $subject)
                                            <option value="{{$subject->id}}">{{$subject->name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>


                            <div class="w-full md:w-1/4 lg:w-1/3 xl:w-1/2 flex items-center justify-end lg:justify-start lg:ml-2 mt-2">
                            <x-button type="button" color="blue" class="relative -top-1 order-last md:order-first mx-1" id="__btnSubmitFilter">
                                {{ __('translation.Search') }}
                            </x-button>
                            <x-button id="__btnResetFilter" type="button" color="yellow" class="ml-1 relative -top-1 reset-filter">
                                {{ __('translation.Reset') }}
                            </x-button>
                            <x-button id="__btnPDFExport" type="button" color="green" class="ml-2 relative -top-1">
                                {{ __('translation.PRINT PDF') }}
                            </x-button>
                            <!--
                            <x-button id="__btnPDFPublish" type="button" color="yellow" class="ml-2 relative -top-1">
                                {{ __('translation.Publish') }}
                            </x-button>
                            -->
							</div>

                        </div>
                    </div>
                </div>

                <div class="overflow-x-none">
                    <table class="w-full" id="datatable">
                        <thead>
                            <tr>
                                <th class="text-left">Student Name</th>
                                <th class="text-center">Roll No</th>
                                <th class="text-center">Class Name</th>
                                <th class="text-center">Section</th>
                                <th class="text-center">Session</th>
                                <th class="text-center">Marks</th>
                                <th class="text-center">Total</th>
                                <th class="text-center">GPA</th>
                                <th class="text-center">Grade</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>
    @endif

    <x-modal.modal-large class="modal-excel modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Marks Sheet PDF Export
            </x-modal.title>
            <x-modal.close-button id="closeModalPDF" />
        </x-modal.header>
        <x-modal.body>
        <div id="excel-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-large>


    <x-modal.modal-large class="modal-edit-mark modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Add/Edit Mark
            </x-modal.title>
            <x-modal.close-button id="closeModalEditMark" />
        </x-modal.header>
        <x-modal.body>
        <div id="mark-edit-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-large>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            const dataTabletUrl = '{{ route('marks_datatable_by_subject') }}';
            const excelExportUrl = '{{ route('excel_export_marks_sheet_by_subject_id') }}';

            const loadMarksBySubjectDataTable = (examId,classId,sectionId, sessionId,subjectId) => {

                $('#datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    ajax: {
                        type: 'GET',
                        url: dataTabletUrl,
                        data: {
                            examId: examId,
                            classId: classId,
                            sectionId: sectionId,
                            sessionId: sessionId,
                            subjectId: subjectId
                        },
                        dataSrc: function ( json ) {
                            return json.data;
                        }
                    },

                    order: [[2, 'asc']],
                    columns: [
                        {
                            name: 'name',
                            data: 'name'
                        },
                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },
                        {
                            name: 'class_name',
                            data: 'class_name'
                        },
                        {
                            name: 'section_name',
                            data: 'section_name'
                        },
                        {
                            name: 'session_name',
                            data: 'session_name'
                        },
                        {
                            name: 'marks',
                            data: 'marks'
                        },
                        {
                            name: 'total',
                            data: 'total'
                        },
                        {
                            name: 'gpa',
                            data: 'gpa'
                        },
                        {
                            name: 'grade',
                            data: 'grade'
                        }
                    ],
                    columnDefs: [
                        {
                            targets: [1, 4],
                            orderable: false
                        },
                        {
                            targets: [1,2,3,4,5,6,7,8],
                            className: 'text-center'
                        },
                        { "width": "30%", "targets": 0 },
                        { "width": "40%", "targets": 5 },
                    ],
                    paginationType: 'numbers'
                });
            }

            let examId = $('#__selectExamFilter').val();
            let classId = $('#__selectClassFilter').val();
            let sectionId = $('#__selectSectionFilter').val();
            let sessionId = $('#__selectSessionFilter').val();
            let subjectId = $('#__selectSubjectFilter').val();

            let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
            let fullmarks = $("#fullmarks").val();

            if(classId==null){ classId=0; }
            if(sectionId==null){ sectionId=0; }
            if(sessionId==null){ sessionId=0; }
            if(subjectId==null){ subjectId=0; }





            $(document).ready(function() {

                $('#__selectExamFilter').select2({
                    placeholder: '- Select Exam -',
                    allowClear: true
                });

                $('#__selectSectionFilter').select2({
                    placeholder: '- Select Section -',
                    allowClear: true
                });

                $('#__selectClassFilter').select2({
                    placeholder: '- Select Class -',
                    allowClear: true
                });

                $('#__selectSessionFilter').select2({
                    placeholder: '- Select Session -',
                    allowClear: true
                });

                $('#__selectSubjectFilter').select2({
                    placeholder: '- Select Subject -',
                    allowClear: true
                });


                $('#__selectIsFourthSubjectFilter').select2({
                    placeholder: '- Select Subject Type -',
                    allowClear: false
                });


                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
            });

            $("#datatable").hide();
            $('#__btnSubmitFilter').click(function() {
                $("#datatable").show();
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }



                loadMarksBySubjectDataTable(examId,classId,sectionId,sessionId,subjectId);

            });

            // Handle to Reset Dropdown,Input fields
            $('#__btnResetFilter').on('click',function() {
                $("#datatable").hide();
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }

                loadMarksBySubjectDataTable(examId,classId,sectionId, sessionId,subjectId);

                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
            });


           // Handle to Export as a excel file
            $(document).on('click', '#__btnPDFExport', function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();

                if(examId==null || classId==null || sectionId==null || sessionId==null || subjectId==null){
                    alert('Please Select required field/s...');
                    return;
                }


                $.ajax({
                       type: 'GET',
                        url: excelExportUrl,
                        data: {
                            examId : examId,
                            classId : classId,
                            sectionId : sectionId,
                            sessionId : sessionId,
                            subjectId : subjectId
                        },
                    beforeSend: function() {
                        $('#excel-wrapper').html('processing...');
                        $('.modal-excel').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result.message);

                    $('#excel-wrapper').html(result.message);
                });
            });




            $('#closeModalPDF').click(function() {
                $('.modal-excel').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });


            // Handle to edit mark
            $(document).on('click', '.add_or_edit', function() {
                let exam_id = $(this).data('exam_id');
                let student_id = $(this).data('student_id');
                let subject_id = $(this).data('subject_id');
                let class_id = $(this).data('class_id');
                let section_id = $(this).data('section_id');
                let session_id = $(this).data('session_id');
                $.ajax({
                       type: 'GET',
                        url: '{{ route('load_mark_form_to_edit_by_student_id_and_subject_id') }}',
                        data: {
                            exam_id: exam_id,
                            student_id : student_id,
                            subject_id : subject_id,
                            class_id : class_id,
                            section_id : section_id,
                            session_id : session_id
                        },
                    beforeSend: function() {
                        $('#mark-edit-wrapper').html('processing...');
                        $('.modal-edit-mark').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);

                    $('#mark-edit-wrapper').html(result);
                });
            });

            $('#closeModalEditMark').click(function() {
                $('.modal-edit-mark').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });



    // Handle to Export as a excel file
    $(document).on('click', '.edit_mark', function() {
       let action = $('#action').val();
       let mark_id = $('#mark_id').val();
       let is_fourth_subject = $('#is_fourth_subject').val();
       let fullmarks = $('#fullmarks').val();
       let pass_mark = $('#pass_mark').val();
       let exam_id = $('#exam_id').val();
       let student_id = $('#student_id').val();
       let subject_id = $('#subject_id').val();
       let class_id = $('#class_id').val();
       let section_id = $('#section_id').val();
       let session_id = $('#session_id').val();
       var fields = {};
       var inputs = $("#mark_table :input");
       var obj = $.map(inputs, function(x, y) {
           return {
               id: x.name,
               mark: $(x).val()
           };
       });
     //  console.log(obj);
       $.ajax({
               type: 'POST',
               url: '{{ route('store_mark_by_student_id_and_subject_id') }}',
               data: {
                   action: action,
                   mark_id: mark_id,
                   is_fourth_subject: is_fourth_subject,
                   fullmarks: fullmarks,
                   pass_mark: pass_mark,
                   exam_id: exam_id,
                   student_id : student_id,
                   subject_id : subject_id,
                   class_id : class_id,
                   section_id : section_id,
                   session_id : session_id,
                   json_mark_type_id : JSON.stringify(obj),
               },
           beforeSend: function() {
               $('#excel-wrapper').html('processing...');
               $('.modal-edit-mark').removeClass('modal-hide');
           }
       }).done(function(result) {
           // console.log(result);

           $('#mark-edit-wrapper').html(result.message);
           setTimeout(function() {
                $("#__btnSubmitFilter").trigger('click');
                $('.modal-edit-mark').addClass('modal-hide');
            }, 300);
       });
   });



        </script>
    @endpush

</x-app-layout>
