<x-app-layout>

    @section('title')
        {{ __('translation.Marks Report By Class') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

 @endpush


<style type="text/css">

    #mark_table {
        margin: auto;
    }
    #mark_table td {
        padding: 0px 3px !important;
        height: 7px !important;
        font-size: 12px;
        border: 1px solid #000 !important;
        height: 20px !important;
    }

</style>
    @if(\App\Models\Role::checkRolePermissions('Can access menu: Results - Results'))
    <div class="col-span-12">
        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    {{ __('translation.Marks Report By Class') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>
            <div class="mt-6">
        @if (session('success'))
            <x-alert-success>
                {{ session('success') }}
            </x-alert-success>
        @endif

        @if (session('danger'))
            <x-alert-danger>
                {{ session('danger') }}
            </x-alert-danger>
        @endif

        @if (session('error'))
            <x-alert-danger>
                {{ session('error') }}
            </x-alert-danger>
        @endif
    </div>
                <form method="POST" action="{{route('PDF_export_marks_by_class')}}" id="form-import" enctype="multipart/form-data">
                @csrf
				<div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="exam_id" id="__selectExamFilter" class="exam_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Exam') . ' -' }}
                                    </option>
                                    @if (isset($exams))
                                        @foreach ($exams as $exam)
                                            <option value="{{$exam->id}}">{{$exam->exam_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Class') . ' -' }}
                                    </option>
                                    @if (isset($classes))
                                        @foreach ($classes as $classe)
                                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                    <option value="0" disabled>
                                        {{ '- ' . __('translation.Select Section') . ' -' }}
                                    </option>
                                    @if (isset($sections))
                                        @foreach ($sections as $section)
                                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                                        @endforeach
                                    @endif

                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Session') . ' -' }}
                                    </option>
                                    @if (isset($sessions))
                                        @foreach ($sessions as $session)
                                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>
                        </div>
                    </div>
                </div>

				<div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">

                            <div class="w-full md:w-1/4 lg:w-1/3 xl:w-1/2 flex items-center justify-end lg:justify-start lg:ml-2 mt-2">
                            <x-button type="button" color="blue" class="relative -top-1 order-last md:order-first mx-1" id="__btnSubmitFilter">
                                {{ __('translation.Search') }}
                            </x-button>
                            <x-button type="button" color="yellow" class="ml-1 relative -top-1 reset-filter" id="__btnResetFilter">
                                {{ __('translation.Reset') }}
                            </x-button>

                            <x-button type="submit" color="green" class="ml-2 relative -top-1 reset-filter" id="__btnExcelExport">
                                {{ __('translation.PDF EXPORT') }}
                            </x-button>
							</div>

                        </div>
                    </div>
                </div>

			</form>

                <div class="overflow-x-auto">
                    <table class="w-full" id="datatable">
                        <thead>
                            <tr>
                                <th class="text-center">ID</th>
                                <th class="text-left">Student Name</th>
                                <th class="text-center">Roll No</th>
                                <th class="text-center">Marks</th>
                                <th class="text-center">Total</th>
                                <th class="text-center">GPA</th>
                                <th class="text-center">Grade</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>
    @endif

    <x-modal.modal-large class="modal-excel modal-hide">
        <x-modal.header>
            <x-modal.title>
                Marks Sheet Excel Export
            </x-modal.title>
            <x-modal.close-button id="closeModalproduct" />
        </x-modal.header>
        <x-modal.body>
        <div id="excel-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-large>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            const dataTabletUrl = '{{ route('marks_datatable_by_class') }}';
            const excelExportUrl = '{{ route('PDF_export_marks_by_class') }}';

            const loadMarksBySubjectDataTable = (examId,classId,sectionId, sessionId,subjectId) => {

                $('#datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    ajax: {
                        type: 'GET',
                        url: dataTabletUrl,
                        data: {
                            examId: examId,
                            classId: classId,
                            sectionId: sectionId,
                            sessionId: sessionId,
                            subjectId: subjectId
                        },
                        dataSrc: function ( json ) {
                            return json.data;
                        }
                    },


                    columns: [
                        {
                            name: 'id',
                            data: 'id'
                        },
                        {
                            name: 'name',
                            data: 'name'
                        },
                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },
                        {
                            name: 'marks',
                            data: 'marks'
                        },
                        {
                            name: 'total',
                            data: 'total'
                        },
                        {
                            name: 'gpa',
                            data: 'gpa'
                        },
                        {
                            name: 'grade',
                            data: 'grade'
                        }
                    ],
                    columnDefs: [
                        {
                            targets: [0],
                            visible: false
                        },
                        {
                            targets: [1, 4],
                            orderable: false
                        },
                        {
                            targets: [0,2,3,4,5,6],
                            className: 'text-center'
                        },
                        { "width": "22%", "targets": 1 },
                        { "width": "23%", "targets": 2 },
                        { "width": "40%", "targets": 3 },
                    ],
                    paginationType: 'numbers'
                });
            }

            let examId = $('#__selectExamFilter').val();
            let classId = $('#__selectClassFilter').val();
            let sectionId = $('#__selectSectionFilter').val();
            let sessionId = $('#__selectSessionFilter').val();
            let subjectId = $('#__selectSubjectFilter').val();

            let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
            let fullmarks = $("#fullmarks").val();

            if(classId==null){ classId=0; }
            if(sectionId==null){ sectionId=0; }
            if(sessionId==null){ sessionId=0; }
            if(subjectId==null){ subjectId=0; }


            loadMarksBySubjectDataTable(examId,classId,sectionId, sessionId,subjectId);


            $(document).ready(function() {

                $('#__selectExamFilter').select2({
                    placeholder: '- Select Exam -',
                    allowClear: true
                });

                $('#__selectSectionFilter').select2({
                    placeholder: '- Select Section -',
                    allowClear: true
                });

                $('#__selectClassFilter').select2({
                    placeholder: '- Select Class -',
                    allowClear: true
                });

                $('#__selectSessionFilter').select2({
                    placeholder: '- Select Session -',
                    allowClear: true
                });

                $('#__selectSubjectFilter').select2({
                    placeholder: '- Select Subject -',
                    allowClear: true
                });


                $('#__selectIsFourthSubjectFilter').select2({
                    placeholder: '- Select Subject Type -',
                    allowClear: false
                });


                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
            });


            $('#__btnSubmitFilter').click(function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }



                loadMarksBySubjectDataTable(examId,classId,sectionId,sessionId,subjectId);

            });

            // Handle to Reset Dropdown,Input fields
            $('#__btnResetFilter').on('click',function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }

                loadMarksBySubjectDataTable(examId,classId,sectionId, sessionId,subjectId);

                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
            });


           // Handle to Export as a excel file
            $(document).on('click', '#__btnExcelExport111', function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }


                $.ajax({
                       type: 'POST',
                        url: excelExportUrl,
                        data: {
                            excel: 1,
                            excelSearch : excelSearch,
                            examId : examId,
                            classId : classId,
                            sectionId : sectionId,
                            sessionId : sessionId,
                            subjectId : subjectId
                        },
                    beforeSend: function() {
                       // $('#excel-wrapper').html('processing...');
                       // $('.modal-excel').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);
                    let downloadLink = '<a href="'+result+'" download >Download Now</a>';
                    $('#excel-wrapper').html(downloadLink);
                });
            });




            $('#closeModalproduct').click(function() {
                $('.modal-excel').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush

</x-app-layout>
