<x-app-layout>
    @section('title', 'Student Fee List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

<style type="text/css">
.select2-container {
}

.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}

.dont-break-out {
    white-space: break-word !important;
/* These are technically the same, but use both */
overflow-wrap: break-word !important;
word-wrap: break-word !important;

-ms-word-break: break-all !important;
/* This is the dangerous one in WebKit, as it breaks things wherever */
word-break: break-all !important;
/* Instead use this non-standard one: */
word-break: break-word !important;

/* Adds a hyphen where the word breaks, if supported (No Blink) */
-ms-hyphens: auto;
-moz-hyphens: auto;
-webkit-hyphens: auto;
hyphens: auto;

}
</style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <x-card title="{{ __('translation.Students Fee Report') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        <form method="POST" action="{{route('PDF_export_fee_list')}}" id="form-import" enctype="multipart/form-data">
        @csrf
        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <x-select name="classId" id="__selectClassFilter" class="class_id" style="width: 100%;">
                    <option value="" selected disabled>
                        {{ '- ' . __('translation.Select Class') . ' -' }}
                    </option>
                    @if (isset($classes))
                        @foreach ($classes as $classe)
                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="sectionId" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                    <option value="" disabled>
                        {{ '- ' . __('translation.Select Section') . ' -' }}
                    </option>
                    @if (isset($sections))
                        @foreach ($sections as $section)
                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                <x-select name="sessionId" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                    <option value="" disabled>
                        {{ '- ' . __('translation.Select Session') . ' -' }}
                    </option>
                    @if (isset($sessions))
                        @foreach ($sessions as $session)
                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <x-select name="status"   id="__selectStatusFilter" class="status_id" style="width: 100%;">
                    <option value="" disabled>
                        {{ '- ' . __('translation.Select Status') . ' -' }}
                    </option>
                    <option value="1">Paid</option>
                    <option value="0">Due</option>
                </x-select>
            </div>

            <div class="w-full lg:w-1/4 mb-6 lg:mb-0 ml-5">
                <x-button color="green" id="BtnPdfExport">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span class="ml-2">
                        {{ __('translation.Print') }}
                    </span>
                </x-button>
            </div>

        </div>
        </form>

        <div class="overflow-x-auto">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>
                            {{ __('translation.Roll') }}
                        </th>

                        <th>
                            {{ __('translation.Name') }}
                        </th>
                        <th>
                            {{ __('translation.Months') }}
                        </th>

                        <th>
                            {{ __('translation.Count') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
   @endif

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const studentTableUrl = '{{ route('report_fee_list') }}';
            var status = 'all';

            function loadStudentsTable(url) {
                $('#__studentTable').dataTable({
                    processing: true,
                    serverSide: true,
                   // ajax: url,
                    "ajax": {
                        "url": url,
                        data: {
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                            status: $("#__selectStatusFilter").val(),

                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                        console.log(json);

                         return json.data;
                        }
                    },
                    columns: [

                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },

                        {
                            name: 'name',
                            data: 'name'
                        },


                        {
                            name: 'months',
                            data: 'months'
                        },

                        {
                            name: 'count',
                            data: 'count'
                        },
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                       {
                            targets: [2],
                            orderable: false,
                            className: 'text-center'
                        },
                        { "width": "7%", "targets": 0 },
                        { "width": "15%", "targets": 1 },
                        { "width": "75%", "targets": 2 },

                    ],
                    order: [
                        [ 0, 'asc' ]
                    ]
                });
            }

            loadStudentsTable(studentTableUrl);

            $('#__selectClassFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectStatusFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });



            $('input[type="search"]').on('keyup', function(e) {
                $("#arrive_or_over_due").select2('val', '0')
                $("#supplier_id").select2("val", "0");
            });




            $(document).on('click', '#purchase_status_chnage', function() {
                var order_id = $(this).attr('data-id');
                $('#po_chnage_status_modal').modal('show');
                $('#order_id').val(order_id);
            });

            $('#__selectSessionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Session -',
                allowClear: true
            });

            $('#__selectClassFilter').select2({
                width: 'resolve',
                placeholder: '- Select Class -',
                allowClear: true
            });

            $('#__selectSectionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Section -',
                allowClear: true
            });

            $('#__selectStatusFilter').select2({
                width: 'resolve',
                placeholder: '- Select Status -',
                allowClear: true,
            });


            $(document).on('click', '#BtnDelete', function() {
                let drop = confirm('Are you sure?');
                if (drop) {
                    //remove from data table
                    $(this).closest('tr').remove();

                    $.ajax({
                        url: '',
                        type: 'post',
                        data: {
                            'id': $(this).data('id'),
                            '_token': $('meta[name=csrf-token]').attr('content')
                        }
                    }).done(function(result) {
                        if (result.status === 1) {
                            alert('Data deleted successfully');

                            $('#__studentTable').dataTable().fnDestroy();
                            loadStudentsTable(studentTableUrl);

                        } else {
                            alert(result.message);
                        }
                    });
                }
            });


            $(document).on('change', '#exam_id', function() {
                var exam_id = $(this).val();
                var session_id = $("#session_id").val();
                var class_id = $("#class_id").val();
                var student_id = $("#student_id").val();
                $.ajax({
                       type: 'GET',
                        url: markSheetUrl,
                        data: {
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id,
                            student_id : student_id
                        },
                    beforeSend: function() {
                        $('#mark-sheet-wrapper').html('processing...');
                        $('.modal-mark-sheet').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);

                    $('#mark-sheet-wrapper').html(result);
                });

            });


            $('#closeModalMarkSheet').click(function() {
                $('.modal-mark-sheet').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
