<x-app-layout>
    @section('title', 'Transaction List')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap.min.css">
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    @endpush

    <style type="text/css">
        .dataTables_filter {
        display: none;
        }
        main {
            background-color: #fff !important;
        }
        .dataTable thead tr th {
            --tw-bg-opacity: 1!important;
            background-color: #758daf !important;
            --tw-text-opacity: 1!important;
            color: rgba(255,255,255,var(--tw-text-opacity))!important;
            --tw-border-opacity: 1!important;
            border: solid rgba(30,64,175,var(--tw-border-opacity))!important;
            border-width: 0 0 1px!important;
            padding-top: 0.5rem!important;
            padding-bottom: 0.5rem!important;
        }
    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <x-card title="{{ __('translation.Transaction Report') }}">
        @if(session()->has('error'))
            <div class="alert alert-danger mb-3 background-danger" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if(session()->has('success'))
            <div class="alert alert-success mb-3 background-success" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <label class="block font-bold text-sm text-gray-700 mb-1">Start Date</label>
                <input type="date" name="start_date" id="__start_date" class="form-control font-bold" value="<?php echo date('Y-m-d');?>">
            </div>

            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <label class="block font-bold text-sm text-gray-700 mb-1">End Date</label>
                <input type="date" name="end_date" id="__end_date" class="form-control font-bold" value="<?php echo date('Y-m-d');?>">
            </div>

            <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                <label class="block font-bold text-sm text-gray-700 mb-1">Select Expense Type</label>
                <x-select name="expense_type_id" id="__selectExpenseTypeFilter" class="expense_type_id" style="width: 100%;">
                    <option value="" selected>
                        {{ '- ' . __('translation.Select Expense Type') . ' -' }}
                    </option>
                    @if (isset($expenses_types))
                        @foreach ($expenses_types as $expense_type)
                            <option value="{{$expense_type->id}}">{{$expense_type->name}}</option>
                        @endforeach
                    @endif
                </x-select>
            </div>


            <div class="w-full lg:w-1/4 mb-6 lg:mb-0 ml-5 mt-5">
                <x-button color="green" id="BtnDownloadPDF">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span class="ml-2">
                        {{ __('translation.Print') }}
                    </span>
                </x-button>
            </div>

        </div>



        <div class="overflow-x-none">
            <table class="w-full" id="__expenseTable">
                <thead>
                    <tr>
                        <th colspan=4 style="background-color: #fff0 !important;color: #000 !important;text-align: center;font-size: 20px;border: 1px solid #d5d5d5 !important;">
                            {{ __('translation.Expense Report') }}
                        </th>
                    </tr>
                    <tr>
                        <th>
                            {{ __('translation.Entry date') }}
                        </th>
                        <th>
                            {{ __('translation.Expense Type') }}
                        </th>

                        <th>
                            {{ __('translation.Payment Method') }}
                        </th>

                        <th>
                            {{ __('translation.Amount') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                    <tr>
                        <th colspan="3" style="text-align:right !important">Total:</th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>


    </x-card>
   @endif

   <x-modal.modal-full class="modal-expense-list modal-hide">
    <x-modal.header>
        <x-modal.title>
             Download PDF
        </x-modal.title>
        <x-modal.close-button id="closeModal" />
    </x-modal.header>
    <x-modal.body>
    <div id="expense-list-wrapper"></div>
    </x-modal.body>
</x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>

        <script>
            const expenseURL = '{{ route('report_expense_list') }}';


            function loadExpenseTable(url) {
                $('#__expenseTable').dataTable({
                    processing: true,
                    serverSide: true,
                    "paging":   false,
                    "ordering": false,
                    "info":     false,
                    "ajax": {
                        "url": url,
                        data: {
                            start_date: $("#__start_date").val(),
                            end_date: $("#__end_date").val(),
                            expense_type_id: $("#__selectExpenseTypeFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                        //console.log(json);

                         return json.data;
                        }
                    },
                    columns: [
                        {
                            name: 'entry_date',
                            data: 'entry_date'
                        },

                        {
                            name: 'id',
                            data: 'id'
                        },

                        {
                            name: 'payment_method',
                            data: 'payment_method'
                        },

                        {
                            name: 'amount',
                            data: 'amount'
                        },
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                        {
                            targets: [3],
                            orderable: false,
                            className: 'text-right'
                        },
                        { "width": "25%", "targets": 0 },
                        { "width": "25%", "targets": 1 },
                        { "width": "25%", "targets": 2 },
                        { "width": "25%", "targets": 3 },

                    ],
                    order: [
                        [ 0, 'asc' ]
                    ],
                    footerCallback: function (row, data, start, end, display) {
                        var api = this.api();
                        fn_footer_sum(api,3);
                    }
                });
            }



            loadExpenseTable(expenseURL);
            $('#__start_date').change(function() {
                $('#__expenseTable').dataTable().fnDestroy();

                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");
                loadExpenseTable(expenseURL);

            });

            $('#__end_date').change(function() {
                $('#__expenseTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");
                loadExpenseTable(expenseURL);
            });

            $('#__selectExpenseTypeFilter').change(function() {
                $('#__expenseTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");
                loadExpenseTable(expenseURL);
            });


            $('#__selectExpenseTypeFilter').select2({
                width: 'resolve',
                placeholder: '- Select Expense Type -',
                allowClear: true,
            });



            function fn_footer_sum(api,column){
                 // Remove the formatting to get integer data for summation
                 var intVal = function (i) {
                            return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                        };
                // Total over all pages
                total = api
                    .column(column)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Total over this page
                pageTotal = api
                    .column(column, { page: 'current' })
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                $(api.column(column).footer()).html('৳ ' + total);
            }


            const PDF_export_expenses = '{{ route('PDF_export_expenses') }}';
            $(document).on('click', '#BtnDownloadPDF', function() {
                $.ajax({
                       type: 'POST',
                        url: PDF_export_expenses,
                        data: {
                            start_date: $("#__start_date").val(),
                            end_date: $("#__end_date").val(),
                            expense_type_id: $("#__selectExpenseTypeFilter").val(),
                        },
                    beforeSend: function() {
                        $('#expense-list-wrapper').html('PDF generating...Please wait....');
                        $('.modal-expense-list').removeClass('modal-hide');
                    }
                }).done(function(result) {
                    $('#expense-list-wrapper').html(result);
                });
            });

            $('#closeModal').click(function() {
                $('.modal-expense-list').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
