<x-app-layout>
    @section('title', 'Promotion')
        @push('bottom_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
    @endpush

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Manage Users - Users'))
        <x-card class="mt-0">


            <card class="bg-gray-500 ">
                <div class="card-title my-4">
                    <h4><strong>Promotion</strong></h4>
                </div>
                <div class="mt-6">
                    @if(session('success'))
                        <x-alert-success>{{ session('success') }}</x-alert-success>
                    @endif
                    @if (session()->has('error'))
                        <x-alert-danger>{{ session('error') }}</x-alert-danger>
                    @endif
                    @if ($errors->any())
                        <x-alert-danger>
                            <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </x-alert-danger>
                    @endif

                    <x-button class="mb-6" color="green" id="BtnPromotion">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span class="ml-2">{{ __('translation.Promote to Next Class') }}</span>
                    </x-button>

                </div>


                <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">


                    <div class="w-full lg:w-3/5 mb-6 lg:mb-0 ml-5">
                        <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                            <option value="" selected disabled>
                                {{ '- ' . __('translation.Select Class') . ' -' }}
                            </option>
                            @if (isset($classes))
                                @foreach ($classes as $classe)
                                    <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                                @endforeach
                            @endif
                        </x-select>
                    </div>

                    <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                        <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                            <option value="0" disabled>
                                {{ '- ' . __('translation.Select Section') . ' -' }}
                            </option>
                            @if (isset($sections))
                                @foreach ($sections as $section)
                                    <option value="{{$section->id}}">{{$section->section_name}}</option>
                                @endforeach
                            @endif
                        </x-select>
                    </div>

                    <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                        <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                            <option value="" selected disabled>
                                {{ '- ' . __('translation.Select Session') . ' -' }}
                            </option>
                            @if (isset($sessions))
                                @foreach ($sessions as $session)
                                    <option data-session="{{$session->session_name}}" value="{{$session->id}}">{{$session->session_name}}</option>
                                @endforeach
                            @endif
                        </x-select>
                    </div>

                </div>

                <div class="flex justify-between flex-col">
                    <div class="overflow-x-auto">
                        <table class="w-full" id="__studentTable">
                            <thead>
                            <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                                <th class="px-4 py-2 border-2"></th>
                                <th class="px-4 py-1 border-2">Profile</th>
                                <th class="px-4 py-2 border-2">Details</th>
                                <th class="px-4 py-2 border-2">Mark Details</th>
                                <th class="px-4 py-2 border-2">Payment Status</th>
                                <th class="px-4 py-2 border-2">Status</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </card>
        </x-card>
    @endif

    {{-- update promotion --}}
    <x-modal.modal-small class="modal-hide modal-approve-promotion">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Promotion') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalPromotion" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form style="max-height:90vh" method="POST" action="{{ route('promotion.confirm_promotion') }}" id="form-status"></form>
            </div>
        </x-modal.body>
    </x-modal.modal-small>


    @push('bottom_js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="{{asset('js/dataTables.checkboxes.min.js')}}"></script>
        <script>
            const studentTableUrl = '{{ route('promotion.data') }}';
            var datatable;
                function loadStudentsTable(url) {
                     datatable = $('#__studentTable').DataTable({
                        processing: true,
                        serverSide: true,
                        "ajax": {
                        "url": url,
                        data: {
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                            for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                                json.data[i][0] = json.data[i][0];
                            }
                           // console.log(json);
                            if(json.supplier !='' && json.draw=='1'){
                            $(".all .order-purchase__filter-total").html(" ("+json.suppliersCountAll+")");
                            $(".open .order-purchase__filter-total").html(" ("+json.suppliersCountOpen+")");
                            $(".arrive .order-purchase__filter-total").html(" ("+json.suppliersCountArrive+")");

                            $(".closes .order-purchase__filter-total").html(" ("+json.suppliersCountClose+")");
                            }
                            return json.data;
                            }
                        },
                        columnDefs: [
                            {
                                'targets': 0,
                                orderable: false,
                                'checkboxes': {
                                    'selectRow': true
                                }
                            },

                        ],

                        columns: [

                            {
                                name: 'checkbox',
                                data: 'id'
                            },
                            {
                                name: 'profile_pic',
                                data: 'profile_pic'
                            },
                            {
                                name: 'details',
                                data: 'details'
                            },
                            {
                            name: 'mark_details',
                            data: 'mark_details'
                            },

                            {
                                name: 'payment_status',
                                data: 'payment_status'
                            },

                            {
                                name: 'status',
                                data: 'status'
                            }
                        ]
                    });
                }

                loadStudentsTable(studentTableUrl);
                $('#__selectClassFilter').change(function() {
                    $('#__studentTable').dataTable().fnDestroy();
                    $('.btn-status-filter').removeClass('active');
                    $(this).addClass("active");

                    loadStudentsTable(studentTableUrl);
                });


            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });



                $(document).on('click', '#BtnPromotion', function() {

                    var rows_selected = datatable.column(0).checkboxes.selected();
                    var arr = [];

                    $.each(rows_selected, function(index, rowId) {
                        arr[index] = rowId;
                    });

                    if (arr.length === 0) {
                        alert("Please Select At Least 1 Row...");
                        return;
                    }
                    $('.modal-approve-promotion').removeClass('modal-hide');
                    var ids = arr.join(",");
                    var current_session = $("#__selectSessionFilter  option:selected").data('session');
                    $.ajax({
                        type: 'GET',
                        url: '{{ route('promotion.promotion_modal') }}',
                        data: {
                            ids: ids,
                            current_session: current_session,
                            class_id: $("#__selectClassFilter").val(),
                            section_id: $("#__selectSectionFilter").val(),
                            session_id: $("#__selectSessionFilter").val(),
                        },
                        beforeSend: function() {
                            $('#form-status').html('Loading');
                        }
                    }).done(function(result) {
                        $('#form-status').html(result);
                    });
                });

                $('#closeModalPromotion').click(function() {
                    $('.modal-approve-promotion').addClass('modal-hide');
                });


        </script>
    @endpush

</x-app-layout>
