
    <style>
        table.dataTable tbody td img{
            padding: 0;
        }
    </style>

<div class="w-full overflow-hidden col-span-12 md:col-span-4">
    <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
        <div class="flex flex-col justify-center ml-0 flex-shrink-0 h-25 w-25 rounded-xl bg-blue-100 text-gray-500">
            <img src="{{ URL::asset('/uploads/students/'.$student->student_details->profile_photo) }}" class="profile_photo__thumbnail w-full h-auto border border-solid border-gray-300 rounded-md">
            <span class="flex flex-col justify-center flex-grow font-bold text-medium">{{$student->student_details->name}}</span>
            <hr>
            <span class="flex flex-col justify-center flex-grow font-bold text-medium">Class : {{$student->class->class_name}}</span>
            <span class="flex flex-col justify-center flex-grow font-bold text-medium">Section : {{$student->section->section_name}}</span>
            <span class="flex flex-col justify-center flex-grow font-bold text-medium">Session : {{$student->session->session_name}}</span>
        </div>
        <div class="flex flex-col justify-center flex-grow ml-4">
            <div class="font-bold text-lg">Fee's Total</div>
            @php
                $grand_total=0;
            @endphp
            @if(!empty($student->FeeDetails))
                @foreach($student->FeeDetails as $fee)
                @php
                    $grand_total += $fee->total;
                    $style =  ($fee->status =='pending') ? 'bg-red-200 text-red-500' : 'bg-green-100 text-green-500';
                @endphp

                    <div class="flex flex-row w-full  py-1 {{$style}} shadow-sm rounded mb-1 text-md text-gray-500">
                        <div class="w-full grid gap-x-0 gap-y-0 grid-cols-3 py-0 xl:pt-0 md:pb-0 px-2 justify-center">
                             <div class="flex items-center justify-center flex-shrink-0 h-6 w-full">{{ucwords($fee->status)}}</div>
                        <div  class="flex items-center justify-center flex-shrink-0 h-6 w-full">৳ {{ number_format($fee->total,2) }}</div>
                    </div>
                </div>
                @endforeach

                <div class="flex flex-row w-full  py-1 bg-white shadow-sm rounded mb-1 text-md text-blue-500">
                    <div class="w-full grid gap-x-0 gap-y-0 grid-cols-3 py-0 xl:pt-0 md:pb-0 px-2 justify-center">
                        <div class="flex items-center justify-center flex-shrink-0 h-6 w-full font-bold">Total</div>
                        <div class="flex items-center justify-center flex-shrink-0 h-6 w-full font-bold">৳ {{ number_format($grand_total,2) }}</div>
                    </div>
                </div>
            @endif

        </div>
    </div>
</div>
