<x-app-layout>
    @section('title', 'Manage Others Collection')
        @push('bottom_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">
    @endpush
    <x-card class="mt-0">


        <card class="bg-gray-500 ">
            <div class="card-title my-4">
                <h4><strong>Others Collection</strong></h4>
            </div>
            <div class="mt-6">
                @if(session('success'))
                    <x-alert-success>{{ session('success') }}</x-alert-success>
                @endif
                @if (session()->has('error'))
                    <x-alert-danger>{{ session('error') }}</x-alert-danger>
                @endif
                @if ($errors->any())
                    <x-alert-danger>
                        <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </x-alert-danger>
                @endif

                <x-button class="mb-6" color="green" id="BtnInsert">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span class="ml-2">{{ __('translation.Add New Collection') }}</span>
                </x-button>
            </div>

            <div class="flex justify-between flex-col">
                <div class="overflow-x-none">
                    <table class="w-full" id="datatable">
                        <thead>
                        <tr class="rounded-lg text-sm font-medium text-gray-700 text-left">
                            <th class="px-4 py-2 border-2"></th>
                            <th class="px-4 py-2 border-2">Entry date</th>
                            <th class="px-4 py-2 border-2">Details</th>
                            <th class="px-4 py-2 border-2">Amount</th>
                            <th class="px-4 py-2 border-2">Note</th>
                            <th class="px-4 py-2 border-2">Manage</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </card>
    </x-card>

<!-- insert modal -->
    <x-modal.modal-large class="modal-hide modal-insert">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Add New Collection') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalInsert" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form method="POST" action="{{ route('others_collection.insert') }}" id="form-insert">
                    @csrf
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-3 sm:gap-x-3 mt-0">
                        <div class="text-center lg:col-span-1 justify-between items-start mb-6 p-3 border-solid border-gray-300">

                            <div class="mt-2">
                                <x-label>Payment Type</x-label>
                                <select disabled id="payment_type" name="payment_type" class="form-control">
                                    <option value='others_collection' selected>Others Collection</option>
                                    <option value='Sallary'>Sallary</option>
                                </select>
                            </div>


                            <div class="mt-2">
                                <x-label>Payment Method</x-label>
                                <select id="payment_method" name="payment_method" class="form-control">
                                    <option value='cash'>Cash</option>
                                    <option value='cheque'>Cheque</option>
                                    <option value='mobile_banking'>Mobile Banking</option>
                                </select>
                            </div>

                            <div id="pm_cheque_wrapper">
                                <div class="mt-2">
                                    <x-label>Bank Name</x-label>
                                    <x-select id="bank_id" name="bank_id">
                                        <option value="">Select</option>
                                        @if($banks)
                                        @foreach($banks as $bank)
                                            <option style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" value="{{$bank->id}}">{{$bank->name}}</option>';
                                        @endforeach
                                        @endif
                                    </x-select>
                                </div>

                                <div class="mt-2">
                                    <x-label>Cheque No</x-label>
                                    <x-input type="text" id="cheque_no" name="cheque_no" value=""></x-input>
                                </div>
                            </div>

                            <div id="pm_mobile_banking_wrapper">
                                <div class="mt-2">
                                    <x-label>Mobile Walet</x-label>
                                    <x-select id="wallet_id" name="wallet_id" >
                                        <option value="">Select</option>
                                        @if($mobile_wallets)
                                        @foreach($mobile_wallets as $mobile_wallet)
                                            <option style="border-bottom: 1px solid #c9c9c9 !important; padding: 0px 5px;" value="{{$mobile_wallet->id}}">{{$mobile_wallet->name}}</option>';
                                        @endforeach
                                        @endif
                                    </x-select>
                                </div>

                                <div class="mt-2">
                                    <x-label>Mobile No</x-label>
                                    <x-input type="text" id="mobile_no" name="mobile_no" value=""></x-input>
                                </div>
                            </div>
                        </div>

                        <div class="text-center lg:col-span-1 justify-between items-start mb-6 p-3 border-solid border-gray-300">
                            <div class="mt-2" >
                                <x-label>
                                Description
                                </x-label>
                                <x-input type="text" name="details" id="details" :value="old('details')" required>
                                </x-input>
                            </div>

                            <div class="mt-2">
                                <x-label>
                                    Amount
                                </x-label>
                                <x-input type="number" name="amount" id="amount" :value="old('amount')" required>
                                </x-input>
                            </div>
                            <div class="mt-2">
                                <x-label>
                                    Note
                                </x-label>
                                <x-textarea name="note" id="note">{{old('note')}}</x-textarea>
                            </div>
                            <div class="flex justify-end mt-4">
                                <x-button color="blue">Save</x-button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </x-modal.body>
    </x-modal.modal-large>



    {{-- update modal --}}
    <x-modal.modal-large class="modal-hide modal-update">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Update Others Collection') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalUpdate" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form method="POST" action="{{ route('others_collection.update') }}"
                      id="form-update"></form>
            </div>
        </x-modal.body>
    </x-modal.modal-large>

    {{-- update Status --}}
    <x-modal.modal-large class="modal-hide modal-approve-others-collection">
        <x-modal.header>
            <x-modal.title>
                {{ __('translation.Change Status') }}
            </x-modal.title>
            <x-modal.close-button id="closeModalStatus" />
        </x-modal.header>
        <x-modal.body>
            <div class="pb-6">
                <form style="max-height:90vh" method="POST" action="{{ route('others_collection.change_status') }}" id="form-status"></form>
            </div>
        </x-modal.body>
    </x-modal.modal-large>


    @push('bottom_js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="{{asset('js/dataTables.checkboxes.min.js')}}"></script>
        <script>

            $("#pm_mobile_banking_wrapper").hide();
            $("#pm_cheque_wrapper").hide();

            jQuery("#payment_method").on("change", function(){
                if($(this).val()=='cheque'){
                    $("#pm_mobile_banking_wrapper").hide();
                    $("#pm_cheque_wrapper").show();
                }
                else if($(this).val()=='mobile_banking'){
                    $("#pm_cheque_wrapper").hide();
                    $("#pm_mobile_banking_wrapper").show();
                }else{
                    $("#pm_mobile_banking_wrapper").hide();
                    $("#pm_cheque_wrapper").hide();
                }
            });

            $(document).ready(function() {
                dataTables("{{ route('others_collection.data') }}?date=" + $(this).val());
                var datatable;
                $('#inputDate').change(function() {
                    datatable.destroy();
                    // console.log($(this).val());
                    dataTables("{{ route('others_collection.data') }}?date=" + $(this).val());
                });

                function dataTables(url) {
                    // Datatable
                    datatable = $('#datatable').DataTable({
                        ajax: url,
                        processing: true,
                        serverSide: true,
                        columnDefs: [
                            {
                            'targets': 0,
                                visible: false,
                                'checkboxes': {
                                    'selectRow': true
                                }
                            },
                            {
                            'targets': 3,
                                className: 'text-right',
                            },

                        ],

                        columns: [

                            {
                                name: 'checkbox',
                                data: 'id'
                            },
                            {
                            name: 'Registered at',
                            data: 'created_at'
                        },
                            {
                                name: 'details',
                                data: 'details'
                            },
                            {
                                name: 'amount',
                                data: 'amount'
                            },
                            {
                                name: 'note',
                                data: 'note'
                            },
                            {
                                name: 'manage',
                                data: 'manage'
                            }
                        ]
                    });
                }

                $('#BtnInsert').click(function() {
                    $('.modal-insert').removeClass('modal-hide');
                });

                $(document).on('click', '#BtnShopUpdate', function() {
                    $('.modal-assign-shop').removeClass('modal-hide');
                    $.ajax({
                        url: '{{ route('others_collection.data') }}?assign_shop=true&id='+$(this).data('id'),
                        beforeSend: function() {
                            $('#form-assign-shop').html('Loading...');
                        }
                    }).done(function(result) {
                        $('#form-assign-shop').html(result);
                    });
                });

                $(document).on('click', '#closeAssignShopModal', function() {
                    $('.modal-assign-shop').addClass('modal-hide');
                });

                $(document).on('click', '#BtnUpdate', function() {
                    $('.modal-update').removeClass('modal-hide');
                    $.ajax({
                        url: '{{ route('others_collection.data') }}?id=' + $(this).data('id'),
                        beforeSend: function() {
                            $('#form-update').html('Loading...');
                        }
                    }).done(function(result) {
                        $('#form-update').html(result);
                    });
                });

                $(document).on('click', '#closeModalUpdate', function() {
                    $('.modal-update').addClass('modal-hide');
                });

                $('#closeModalInsert').click(function() {
                    $('.modal-insert').addClass('modal-hide');
                });

                $(document).on('click', '#BtnApproved', function() {
                    $('.modal-approve-others-collection').removeClass('modal-hide');
                    var rows_selected = datatable.column(0).checkboxes.selected();

                    var arr = [];
                    $.each(rows_selected, function(index, rowId) {
                        arr[index] = rowId;
                    });

                    if (arr.length === 0) {
                        alert("Please Select At Least 1 Row...");
                        return;
                    }
                    var ids = arr.join(",");
                    $.ajax({
                        url: '{{ route('others_collection.approve_others_collection_modal') }}?ids='+ids,
                        beforeSend: function() {
                            $('#form-status').html('Loading');
                        }
                    }).done(function(result) {
                        $('#form-status').html(result);
                    });
                });

                $('#closeModalStatus').click(function() {
                    $('.modal-approve-others-collection').addClass('modal-hide');
                });

                $(document).on('click', '#BtnDelete', function() {
                    let drop = confirm('Are you sure?');
                    if (drop) {
                        $.ajax({
                            url: '{{ route('others_collection.delete') }}',
                            type: 'post',
                            data: {
                                'id': $(this).data('id'),
                                '_token': $('meta[name=csrf-token]').attr('content')
                            },
                            beforeSend: function() {
                                // Pesan yang muncul ketika memproses delete
                            }
                        }).done(function(result) {
                            if (result.status === 1) {
                                // Pesan jika data berhasil di hapus
                                alert('Data deleted successfully');
                                $('#datatable').DataTable().ajax.reload();
                            } else {
                                alert(result.message);
                            }
                        });
                    }
                });
            });

        </script>
    @endpush

</x-app-layout>
