
<div class="flex flex-row w-full bg-blue-100 text-blue-500 shadow-sm rounded p-4">
    <div class="flex items-center justify-center flex-shrink-0 h-8 w-20 rounded-xl ">
        Select Date
    </div>
    <input type="date" name="__entryDate" id="__entryDate" class="w-25 form-control font-bold" value="<?php echo date('Y-m-d');?>">
    <button id="__btnSearchDate" class="w-20 h-9  rounded ml-2 btn-action--blue font-bold">Search</button>
</div>




    <input type="hidden"  id="feeStatus" value="{{$status}}">
    <div class="overflow-x-none">
        <table class="w-full" id="__studentTable">
            <thead>
                <tr>
                    <th>
                        {{ __('translation.#Receipt') }}
                    </th>
                    <th>
                        {{ __('translation.Entry Date') }}
                    </th>
                    <th>
                        {{ __('translation.Student ID') }}
                    </th>



                    <th>
                        {{ __('translation.Payment Method') }}
                    </th>

                    <th>
                        {{ __('translation.Total') }}
                    </th>

                    <th>
                        {{ __('translation.Discount') }}
                    </th>

                    <th>
                        {{ __('translation.Paid') }}
                    </th>

                    <th>
                        {{ __('translation.Status') }}
                    </th>

                    <th>
                        {{ __('translation.Action') }}
                    </th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>

    <script type="text/javascript">

            const fees_detailsTableUrl = '{{ route('dashboard_fees_details_by_status') }}';

            function loadFeesTable(url) {
                var status = $("#feeStatus").val();
                var entry_date = $("#__entryDate").val();
                $('#__studentTable').dataTable({
                    processing: true,
                    serverSide: true,
                    'language': {
                        'loadingRecords': '&nbsp;',
                        'processing': 'Loading...'
                    },
                    "ajax": {
                        "url": url,
                        data: {
                            entry_date : entry_date,
                            status : status
                        },
                        "dataSrc": function ( json ) {
                         return json.data;
                        }
                    },
                    columns: [

                        {
                            name: 'receipt_no',
                            data: 'receipt_no'
                        },

                        {
                            name: 'entry_date',
                            data: 'entry_date'
                        },

                        {
                            name: 'student_code',
                            data: 'student_code'
                        },


                        {
                            name: 'payment_method',
                            data: 'payment_method'
                        },

                        {
                            name: 'total',
                            data: 'total'
                        },

                        {
                            name: 'discount',
                            data: 'discount'
                        },

                        {
                            name: 'paid',
                            data: 'paid'
                        },
                        {
                            name: 'status',
                            data: 'status'
                        },
                        {
                            name: 'action',
                            data: 'action'
                        }
                    ],
                    pagingType: 'numbers',
                    columnDefs: [
                       {
                            targets: [0,1,2,4,5,6,7],
                            className: 'text-center'
                        },
                        { "width": "8%", "targets": 0 },
                        { "width": "10%", "targets": 1 },
                        { "width": "10%", "targets": 2 },
                        { "width": "15%", "targets": 3 },
                        { "width": "15%", "targets": 4 },
                        { "width": "10%", "targets": 5 },
                        { "width": "8%", "targets": 6 },
                        { "width": "8%", "targets": 7 },

                    ],
                    order: [
                        [ 0, 'asc' ]
                    ]
                });
            }

            loadFeesTable(fees_detailsTableUrl);

            jQuery(document).on('click','#__btnSearchDate',function() {
                $('#__studentTable').dataTable().fnDestroy();
                loadFeesTable(fees_detailsTableUrl);
            });


            $(document).on('click', '#BtnPrintMoneyReceipt', function() {
                var receipt_id = $(this).data('id');
                fn_show_receipt(receipt_id);
            });

            function fn_show_receipt(receipt_id){
                $('.modal-details').removeClass('modal-hide');
                $.ajax({
                        url: '{{ route('get_money_receipt') }}',
                        type: 'post',
                        data: {
                            'receipt_id': receipt_id,
                        },
                        beforeSend: function() {
                            $('.modal-details-wrapper').html("Processing....");
                        }
                    }).done(function(result) {
                        //console.log(result);
                        $('.modal-details-wrapper').html(result);
                        if (result === 'success') {
                        // fn_print_receipt();
                        } else {

                        }
                    });

                }




                    function printDiv22(divName) {
                        var printContents = document.getElementById(divName).innerHTML;
                        var originalContents = document.body.innerHTML;

                        document.body.innerHTML = printContents;

                        window.print();

                        document.body.innerHTML = originalContents;
                        $('.modal-details').addClass('modal-hide');
                        //location.reload();
                    }





    </script>
