<x-app-layout>
    @section('title', 'Dashboard')
    <link href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" rel="stylesheet">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>

    @if(session('roleName') != 'dropshipper')
        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-lg">Today's Fees Collection</div>

                        @php
                            $grand_total=0;
                        @endphp
                        @if(!empty($todays_fees))
                            @foreach($todays_fees as $fee)
                            @php
                                $grand_total += $fee->total;
                                $style =  ($fee->status =='pending') ? 'bg-red-200 text-red-500' : 'bg-green-100 text-green-500';
                            @endphp

                                <div class="flex flex-row w-full  py-1 {{$style}} shadow-sm rounded mb-1 text-md text-gray-500">
                                    <div class="w-full grid gap-x-0 gap-y-0 grid-cols-3 py-0 xl:pt-0 md:pb-0 px-2 justify-center">
                                         <div class="flex items-center justify-center flex-shrink-0 h-6 w-full">{{ucwords($fee->status)}}</div>
                                    <div  class="flex items-center justify-center flex-shrink-0 h-6 w-full">৳ {{ number_format($fee->total,2) }}</div>
                                    <div  class="flex items-center justify-center flex-shrink-0 h-6 w-full ">
                                        <button type="button" class="modal-open btn-action--gray mt-1" title="View Details" data-status="{{$fee->status}}" data-title="Today's {{ucwords($fee->status)}} Fee" id="__btnLoadFeeByStatus">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                                <div class="flex flex-row w-full bg-white shadow-sm rounded pb-1 text-md text-gray-500">
                                <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 bg-blue-100 text-blue-500">Total</div>
                                <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 bg-blue-100 text-blue-500">৳ {{ number_format($grand_total,2) }}</div>
                              </div>
                        @endif

            </div>
            </div>
        </div>

        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-lg">Total Students</div>
                    @php
                    $grand_total=0;
                @endphp
                @if(!empty($students))
                    @foreach($students as $student)
                    @php
                        $grand_total += $student->total;
                        $style =  ($student->gender =='female') ? 'bg-blue-200 text-blue-500' : 'bg-green-100 text-green-500';
                    @endphp

                        <div class="flex flex-row w-full bg-white shadow-sm rounded pb-1 text-md text-gray-500">
                          <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 {{$style}}">{{ucwords($student->gender)}}</div>
                          <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 {{$style}}">{{ number_format($student->total,0) }}</div>
                        </div>
                    @endforeach

                    <div class="flex flex-row w-full bg-white shadow-sm rounded pb-1 text-md text-gray-500">
                        <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 bg-blue-100 text-blue-500">Total</div>
                        <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 bg-blue-100 text-blue-500">{{ number_format($grand_total,0) }}</div>
                      </div>

                @endif
                </div>
            </div>
        </div>



        <div class="w-full overflow-hidden col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                        <path d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z"/>
                    </svg>
                </div>
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-lg">Today's Expenses</div>
                    @php
                            $grand_total=0;
                        @endphp
                        @if(!empty($todays_costs))
                            @foreach($todays_costs as $cost)
                            @php
                                $grand_total += $cost->total;
                                $style =  ($cost->status =='0') ? 'bg-red-200 text-red-500' : 'bg-green-100 text-green-500';
                                $title =  ($cost->status =='0') ? 'Pending' : 'Approved';
                            @endphp

                                <div class="flex flex-row w-full bg-white shadow-sm rounded pb-1 text-md text-gray-500">
                                  <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 {{$style}}">{{ucwords($title)}}</div>
                                  <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 {{$style}}">৳ {{ number_format($cost->total,2) }}</div>
                                </div>
                            @endforeach

                            <div class="flex flex-row w-full bg-white shadow-sm rounded pb-1 text-md text-gray-500">
                                <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 bg-blue-100 text-blue-500">Total</div>
                                <div class="flex items-center justify-center flex-shrink-0 h-6 w-50 bg-blue-100 text-blue-500">৳ {{ number_format($grand_total,2) }}</div>
                              </div>

                        @endif
                </div>
            </div>
        </div>

        {{-- Modal Datatable--}}
        <x-modal.modal-full class="modal-hide modal-loader">
            <x-modal.header>
                <x-modal.title class="modal-title">
                </x-modal.title>
                <x-modal.close-button id="closeModal" />
            </x-modal.header>
            <x-modal.body>
                <div class="pb-6 modal-loader-wrapper">

                </div>
            </x-modal.body>
        </x-modal.modal-full>


        {{-- Modal Datatable--}}
        <x-modal.modal-full class="modal-hide modal-details">
            <x-modal.header>
                <x-modal.title class="modal-title">
                </x-modal.title>
                <x-modal.close-button id="closeDetailsModal" />
            </x-modal.header>
            <x-modal.body>
                <div class="pb-6 modal-details-wrapper">

                </div>
            </x-modal.body>
        </x-modal.modal-full>


        <style type="text/css">
            .chart{
                height: 400px;
                width:600px;
                margin: 0 auto;
                overflow-y: hidden;
            }
            .history{
                max-height: 700px;overflow-y: scroll;
            }
        </style>

        <x-card title="Daily Summary" md="8">
            <div class="overflow-x-auto">
                <div id="lineChartContainer" class="chart"></div>
            </div>
        </x-card>

        <div class="w-full col-span-12 md:col-span-4 history">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-xl">Last Changes</div>
                </div>
            </div>
            @if(isset($last_changes))
                @foreach($last_changes as $arrItem)
                    <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                        <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                            <img class="w-1/2" src="{{ isset($arrItem->product->image) && file_exists(public_path($arrItem->product->image)) ? asset($arrItem->product->image) : asset('No-Image-Found.png') }}">
                        </div>
                        <div class="flex flex-col justify-center flex-grow ml-4">
                            <div class="text-gray-700">{{ $arrItem->product->product_name }}  </div>
                            <div class="text-blue-600">
                                {{ isset($arrItem->product->product_code) ? $arrItem->product->product_code : '' }}
                            </div>
                            <div class="font-bold text-sl">
                                @if($arrItem->str_in_out == 'Add') Qty: {{ $arrItem->main_stock->quantity ?? 0 }}  (+{{ $arrItem->quantity ?? 0 }})@endif
                                @if($arrItem->str_in_out == 'Remove') Qty: {{ $arrItem->main_stock->quantity ?? 0 }}  (-{{ $arrItem->quantity ?? 0 }})@endif
                            </div>
                            <div class="font-500 text-sl">
                                Created at :{{ date("Y-m-d H:i:s", strtotime($arrItem->date)) }}
                            </div>
                            <div class="font-500 text-sl">
                                User : {{ isset($arrItem->person->name) ? $arrItem->person->name : ''}}
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>

        <div class="w-full col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-l">Top 5 Fees</div>
                </div>
            </div>
            @if(isset($top_five_stock))
                @foreach($top_five_stock as $arrItem)
                    <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                        <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                            <img class="w-1/2" src="{{ isset($arrItem->product->image) && file_exists(public_path($arrItem->product->image)) ? asset($arrItem->product->image) : asset('No-Image-Found.png') }}">
                        </div>
                        <div class="flex flex-col justify-center flex-grow ml-4">
                            <div class="text-gray-700 ">{{ isset($arrItem->product->product_name) ? $arrItem->product->product_name : '' }}</div>
                            <div class="text-blue-600">
                                {{ isset($arrItem->product->product_code) ? $arrItem->product->product_code : '' }}
                            </div>
                            <div class="text-sl">
                                Qty:
                                <span class="font-bold">{{isset($arrItem->quantity) ? $arrItem->quantity : '' }}</span>
                            </div>
                            <div class="font-500 text-sl">
                                Created at :{{isset($arrItem->created_at) ? $arrItem->created_at : '' }}
                            </div>
                            <div class="font-500 text-sl">
                                User : {{ isset($arrItem->product->person->name) ? $arrItem->product->person->name : ''}}
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>

        <div class="w-full col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-l">Top 5 Fees (7 days)</div>
                </div>
            </div>

            @php
                $i = 0
            @endphp
            @if(isset($latest_stock))
                @foreach($latest_stock as $addItem)
                    @if($addItem->str_in_out=='Add')
                        <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                            <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                                @if(isset($addItem->product->image))
                                    <img class="w-1/2" src="{{ isset($addItem->product->image) && file_exists(public_path($addItem->product->image)) ? asset($addItem->product->image) : asset('No-Image-Found.png') }}">
                                @endif
                            </div>
                            <div class="flex flex-col justify-center flex-grow ml-4">
                                <div class="text-gray-700">{{ $addItem->product->product_name }}  </div>
                                <div class="text-blue-600">
                                    @if(isset($addItem->product->product_code))
                                        {{ $addItem->product->product_code }}
                                    @endif
                                </div>
                                <div class="text-sl">
                                    Qty:
                                    <span class="font-bold">{{$addItem->main_stock->quantity }} (+{{ $addItem->quantity }})</span>
                                </div>
                                <div class="font-500 text-sl">
                                    Created at :{{ date("Y-m-d H:i:s", strtotime($addItem->date)) }}
                                </div>
                                <div class="font-500 text-sl">
                                    User : {{ isset($addItem->person->name) ? $addItem->person->name : ''}}
                                </div>
                            </div>
                        </div>
                        @php
                            $i++;
                            if($i==5) break;
                        @endphp
                    @endif
                @endforeach
            @endif
        </div>

        <div class="w-full col-span-12 md:col-span-4">
            <div class="flex flex-row w-full bg-white shadow-sm rounded p-4">
                <div class="flex flex-col justify-center flex-grow ml-4">
                    <div class="font-bold text-l">Top 5 Removed Fees (7 days)</div>
                </div>
            </div>
            @php
                $i = 0
            @endphp
            @if(isset($latest_stock))
                @foreach($latest_stock as $removeItem)
                    @if($removeItem->str_in_out=='Remove')
                        <div class="flex flex-row w-full bg-white shadow-sm rounded p-4 mt-4">
                            <div class="flex items-center justify-center flex-shrink-0 h-16 w-16 rounded-xl bg-blue-100 text-blue-500">
                                @if(isset($removeItem->product->image))
                                    <img class="w-1/2" src="{{ isset($removeItem->product->image) && file_exists(public_path($removeItem->product->image)) ? asset($removeItem->product->image) : asset('No-Image-Found.png') }}">
                                @endif
                            </div>
                            <div class="flex flex-col justify-center flex-grow ml-4">
                                <div class="text-gray-700">{{ $removeItem->product->product_name }}  </div>
                                <div class="text-blue-600">
                                    @if(isset($removeItem->product->product_code))
                                        {{ $removeItem->product->product_code }}
                                    @endif
                                </div>
                                <div class="text-sl">
                                    Qty:
                                    <span class="font-bold">{{$removeItem->main_stock->quantity }} (-{{ $removeItem->quantity }})</span>
                                </div>
                                <div class="font-500 text-sl">
                                    Created at :{{ date("Y-m-d H:i:s", strtotime($removeItem->date)) }}
                                </div>
                                <div class="font-500 text-sl">
                                    User : {{ isset($removeItem->person->name) ? $removeItem->person->name : ''}}
                                </div>
                            </div>
                        </div>
                        @php
                            $i++;
                            if($i==5) break;
                        @endphp
                    @endif

                @endforeach
            @endif
        </div>
    @endif


    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>


    <script type="text/javascript">
            jQuery(document).on('click','#__btnLoadFeeByStatus',function() {
                var title = $(this).data('title');
                var status = $(this).data('status');
                $("#feeStatus").val(status)
                $('.modal-loader .modal-title').html(title);
                $('.modal-loader').removeClass('modal-hide');

                jQuery.ajax({
                    type : 'POST',
                    url: '{{ route('dashboard_fees_details_page_status') }}',
                    data : {
                        'status':status,
                        '_token': $('meta[name=csrf-token]').attr('content')
                    },
                    success :  function(data)
                    {
                     jQuery(".modal-loader-wrapper").html(data);
                    //console.log(data);
                    }
                });


            });

            jQuery("#closeModal").on("click", function(){
                $('.modal-loader').addClass('modal-hide');
            });

            jQuery(document).on('click','.btnLoadStudentDetails', { passive: true } ,function( e ) {
                var id = $(this).data('id');
                var session_id = $(this).data('session_id');
                $('.modal-details .modal-title').html("Student Details");
                $('.modal-details').removeClass('modal-hide');
                jQuery.ajax({
                    type : 'POST',
                    url: '{{ route('get_dashboard_student_details') }}',
                    data : {
                        id:id,
                        session_id:session_id,
                    },
                    success :  function(data)
                    {
                     jQuery(".modal-details-wrapper").html(data);
                    //console.log(data);
                    }
                });
            });

            jQuery("#closeDetailsModal").on("click", function(){
                $('.modal-details').addClass('modal-hide');
            });


    </script>
@endpush
</x-app-layout>
