<x-app-layout>

    @section('title')
        {{ __('translation.Marks Import Excel') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

 @endpush


<style type="text/css">
.select2-container {
}

.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}
</style>
    @if(\App\Models\Role::checkRolePermissions('Can access menu: Marks - Marks'))
    <div class="col-span-12">
        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    {{ __('translation.Marks Import Excel') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>
                <div class="mt-6">
                    @if (session('success'))
                        <x-alert-success>
                            {{ session('success') }}
                        </x-alert-success>
                    @endif

                    @if (session('danger'))
                        <x-alert-danger>
                            {{ session('danger') }}
                        </x-alert-danger>
                    @endif

                    @if (session('error'))
                        <x-alert-danger>
                            {{ session('error') }}
                        </x-alert-danger>
                    @endif
                </div>

                <form action="{{ route('marks.excel_import_file') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="file" id="import_file" name="file" class="form-control">
                <br>
                <button id="btn_import" class="btn btn-success">{{ __('translation.Import Marks') }}</button>
                </form>
               
            </x-card.body>
        </x-card.card-default>
    </div>
    @endif





    @push('bottom_js')
    
    <script type="text/javascript">

        // So you will have to do something like the following...
$('form1').submit(function(e){
	// Stop the form submitting
  	e.preventDefault();

    if( document.getElementById("import_file").files.length == 0 ){
       // alert("no files selected");
    }else{
        e.currentTarget.submit();
    } 
});


    </script>
    @endpush

</x-app-layout>
