<x-app-layout>

    @section('title')
        {{ __('translation.Download Marks Entry Form') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

 @endpush


<style type="text/css">
.select2-container {
}

.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}

.select2-container .select2-search--inline .select2-search__field {
    box-sizing: border-box;
    border: none;
    font-size: 100%;
    margin-top: 9px !important;
    margin-left: 5px;
    vertical-align: bottom;
    font-family: unset !important;
}

</style>
    @if(\App\Models\Role::checkRolePermissions('Can access menu: Marks - Marks'))
    <div class="col-span-12">
        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    {{ __('translation.Download Marks Entry Form') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>
            <div class="mt-6">
        @if (session('success'))
            <x-alert-success>
                {{ session('success') }}
            </x-alert-success>
        @endif

        @if (session('danger'))
            <x-alert-danger>
                {{ session('danger') }}
            </x-alert-danger>
        @endif

        @if (session('error'))
            <x-alert-danger>
                {{ session('error') }}
            </x-alert-danger>
        @endif
    </div>
                <div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <label class="mb-0">{{ __('translation.Select Exam') }}</label>
                                <x-select name="exam_id" id="__selectExamFilter" class="exam_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Exam') . ' -' }}
                                    </option>
                                    @if (isset($exams))
                                        @foreach ($exams as $exam)
                                            <option value="{{$exam->id}}">{{$exam->exam_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <label class="mb-0">{{ __('translation.Select Class') }}</label>
                                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Class') . ' -' }}
                                    </option>
                                    @if (isset($classes))
                                        @foreach ($classes as $classe)
                                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <label class="mb-0">{{ __('translation.Select Section') }}</label>
                                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                    <option value="0" disabled>
                                        {{ '- ' . __('translation.Select Section') . ' -' }}
                                    </option>
                                    @if (isset($sections))
                                        @foreach ($sections as $section)
                                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                                        @endforeach
                                    @endif

                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <label class="mb-0">{{ __('translation.Select Session') }}</label>
                                <x-select name="session_id" id="__selectSessionFilter" class="session" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Session') . ' -' }}
                                    </option>
                                    @if (isset($sessions))
                                        @foreach ($sessions as $session)
                                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>
                        </div>
                    </div>
                </div>

				<div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">


                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <label class="mb-0">{{ __('translation.Select Subject') }}</label>
                                <x-select name="subject_id" id="__selectSubjectFilter" class="subject_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Subject ') . ' -' }}
                                    </option>
                                    @if (isset($subjects))
                                        @foreach ($subjects as $subject)
                                            <option value="{{$subject->id}}">{{$subject->name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>



                            <div class="w-full lg:w-4/5 mb-4 sm:mb-0 sm:ml-2">
                                <label class="mb-0">{{ __('translation.Select Mark Type') }}</label>
                                <x-select name="mark_types" id="__selectMarkTypeFilter"  multiple="multiple" class="mark_types" style="width: 100%;">
                                    <option value="0" disabled>
                                        {{ '- ' . __('translation.Select Mark Type') . ' -' }}
                                    </option>
                                    @if (isset($mark_types))
                                        @foreach ($mark_types as $mark_type)
                                            <option value="{{$mark_type->id}}">{{$mark_type->type}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-3/5 mb-4 sm:mb-0 sm:ml-2">
                                <label class="mb-0">{{ __('translation.Is 4th Subject') }}</label>
                                <x-select name="is_fourth_subject" id="__selectIsFourthSubjectFilter" class="is_fourth_subject" style="width: 100%;">
                                    <option value="0" selected>
                                        {{ '- ' . __('translation.Is 4th Subject ') . ' ( No )' }}
                                    </option>
                                    <option  value="1"> {{ '- ' . __('translation.Is 4th Subject') . ' ( Yes )' }}</option>
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <div class="">
                                    <label class="mb-0">
                                        {{ __('translation.Full Marks') }} :
                                    </label>
                                    <x-input  type="number" step="1" name="fullmarks" id="fullmarks" value="100"> </x-input>
                                 </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div id="ajaxMinimumPassMarkWrapper">

                </div>



                <div class="overflow-x-none">
                    <table class="w-full" id="datatable">
                        <thead>
                            <tr>
                                <th class="text-center">ID</th>
                                <th class="text-left">Student Name</th>
                                <th class="text-center">Roll No</th>
                                <th class="text-center">Class Name</th>
                                <th class="text-center">Section</th>
                                <th class="text-center">Session</th>
                                @if (isset($mark_types))
                                    @foreach ($mark_types as $mark_type)
                                    <th hidden id="type_{{$mark_type->id}}" class="text-center">{{$mark_type->type}}</th>
                                    @endforeach
                                @endif
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>
    @endif

    <x-modal.modal-large class="modal-excel modal-hide">
        <x-modal.header>
            <x-modal.title>
                 Mark Entry Excel Export
            </x-modal.title>
            <x-modal.close-button id="closeModalproduct" />
        </x-modal.header>
        <x-modal.body>
        <div id="excel-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-large>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            const dataTabletUrl = '{{ route('marks_entry_form_datatable') }}';
            const excelExportUrl = '{{ route('excel_export_marks_entry_form') }}';

            const loadOrderAnalysisDataTable = (examId,classId,sectionId, sessionId,subjectId,markTypes,isFourthSubject,fullmarks) => {

                $('#datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    ajax: {
                        type: 'GET',
                        url: dataTabletUrl,
                        data: {
                            examId: examId,
                            classId: classId,
                            sectionId: sectionId,
                            sessionId: sessionId,
                            subjectId: subjectId,
                            markTypes : markTypes,
                            isFourthSubject : isFourthSubject,
                            fullmarks:fullmarks
                        },
                        dataSrc: function ( json ) {
                            const markTypes_arr = json.input.markTypes;
                            if(markTypes_arr){
                                for (let i = 0; i < markTypes_arr.length; i++) {
                                    $("#type_"+markTypes_arr[i]).removeAttr("hidden");
                                }
                            }
                            return json.data;
                        }
                    },


                    columns: [
                        {
                            name: 'id',
                            data: 'id'
                        },
                        {
                            name: 'name',
                            data: 'name'
                        },
                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },
                        {
                            name: 'class_name',
                            data: 'class_name'
                        },
                        {
                            name: 'section_name',
                            data: 'section_name'
                        },
                        {
                            name: 'session_name',
                            data: 'session_name'
                        }
                    ],
                    columnDefs: [
                        {
                            targets: [1, 4],
                            orderable: false
                        },
                        {
                            targets: [0,2,3,4,5],
                            className: 'text-center'
                        },
                        { "width": "22%", "targets": 1 },
                        { "width": "23%", "targets": 3 },
                    ],
                    paginationType: 'numbers'
                });
            }

            let examId = $('#__selectExamFilter').val();
            let classId = $('#__selectClassFilter').val();
            let sectionId = $('#__selectSectionFilter').val();
            let sessionId = $('#__selectSessionFilter').val();
            let subjectId = $('#__selectSubjectFilter').val();
            let markTypes = $('#__selectMarkTypeFilter').val();
            let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
            let fullmarks = $("#fullmarks").val();

            if(classId==null){ classId=0; }
            if(sectionId==null){ sectionId=0; }
            if(sessionId==null){ sessionId=0; }
            if(subjectId==null){ subjectId=0; }


            loadOrderAnalysisDataTable(examId,classId,sectionId, sessionId,subjectId,markTypes,isFourthSubject,fullmarks);


            $(document).ready(function() {

                $('#__selectExamFilter').select2({
                    placeholder: '- Select Exam -',
                    allowClear: true
                });

                $('#__selectSectionFilter').select2({
                    placeholder: '- Select Section -',
                    allowClear: true
                });

                $('#__selectClassFilter').select2({
                    placeholder: '- Select Class -',
                    allowClear: true
                });

                $('#__selectSessionFilter').select2({
                    placeholder: '- Select Session -',
                    allowClear: true
                });

                $('#__selectSubjectFilter').select2({
                    placeholder: '- Select Subject -',
                    allowClear: true
                });


                $('#__selectMarkTypeFilter').select2({
                    placeholder: '- Select Mark Type -',
                    allowClear: true
                });

                $('#__selectIsFourthSubjectFilter').select2({
                    placeholder: '- Select Mark Type -',
                    allowClear: false
                });


                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
                $('#__selectMarkTypeFilter').val('').trigger('change');
            });


            $('#__btnSubmitFilter').click(function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let markTypes = $('#__selectMarkTypeFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }



            loadOrderAnalysisDataTable(examId,classId,sectionId,sessionId,subjectId,markTypes,isFourthSubject,fullmarks);

            });

            // Handle to Reset Dropdown,Input fields
            $('#__btnResetFilter').on('click',function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let markTypes = $('#__selectMarkTypeFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }

                loadOrderAnalysisDataTable(examId,classId,sectionId, sessionId,subjectId,markTypes,isFourthSubject,fullmarks);

                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
                $('#__selectMarkTypeFilter').val('').trigger('change');

            });

            const minimumPassMarkSettingURL = '{{ route('minimum_pass_mark_setting') }}';
            $(document).on('change', '#__selectMarkTypeFilter', function() {
                $.ajax({
                       type: 'POST',
                        url: minimumPassMarkSettingURL,
                        data: {
                            markTypes: $('#__selectMarkTypeFilter').val(),
                        },
                    beforeSend: function() {
                    }
                }).done(function(result) {
                    $('#ajaxMinimumPassMarkWrapper').html(result);
                });
            });


           // Handle to Export as a excel file
            $(document).on('click', '#__btnExcelExport', function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let markTypes = $('#__selectMarkTypeFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }

                var arr_pass_mark = [];
                $('.mark_type').each(function(){
                    arr_pass_mark.push({
                        id: $(this).data('id'),
                        val: $(this).val()
                    });
                })
                var json_pass_mark = JSON.stringify(arr_pass_mark);

                $.ajax({
                       type: 'GET',
                        url: excelExportUrl,
                        data: {
                            excel: 1,
                            excelSearch : excelSearch,
                            examId : examId,
                            classId : classId,
                            sectionId : sectionId,
                            sessionId : sessionId,
                            subjectId : subjectId,
                            markTypes : markTypes,
                            isFourthSubject : isFourthSubject,
                            fullmarks : fullmarks,
                            json_pass_mark : json_pass_mark
                        },
                    beforeSend: function() {
                        $('#excel-wrapper').html('processing...');
                        $('.modal-excel').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);
                    let downloadLink = '<a href="'+result+'" download >Download Now</a>';
                    $('#excel-wrapper').html(downloadLink);
                });
            });




            $('#closeModalproduct').click(function() {
                $('.modal-excel').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush

</x-app-layout>
