<header class="w-full xl:fixed top-0 left-0 bg-white xl:bg-transparent xl:pointer-events-none shadow-md xl:shadow-none z-20">
    <nav class="w-full 2xl:max-w-7xl 2xl:mx-auto flex flex-row xl:flex-col items-center xl:items-start justify-between" x-data="{ sidebarOpen: false }">
        <div class="w-full h-full fixed inset-0 z-20 transition-opacity duration-300 opacity-0 pointer-events-none"
             :class="{ '': sidebarOpen === true, 'opacity-0 pointer-events-none': sidebarOpen === false }"
             x-on:click="sidebarOpen = false">
            <div class="absolute w-full h-full bg-gray-900 bg-opacity-50 xl:bg-opacity-0 z-30"></div>
        </div>
        <div class="transform -translate-x-full xl:translate-x-0 ease-in-out transition-all duration-300 fixed top-0 left-0 2xl:left-auto xl:mt-32 2xl:mx-auto pb-20 w-3/5 sm:w-60 2xl:w-full 2xl:max-w-7xl h-full bg-white 2xl:bg-transparent z-40 xl:z-10 2xl:pointer-events-none"
             :class="{ 'left-sidebar--open' : sidebarOpen === true }">
            <div class="w-full 2xl:w-60 bg-transparent 2xl:bg-white 2xl:rounded-md 2xl:shadow 2xl:pointer-events-auto py-4 xl:py-5">
                <div class="mb-6 block xl:hidden">
                    <div class="w-full h-full flex items-center justify-center">

                        @if(session('roleName') == 'dropshipper')
                            <a href="{{ route('order_management.index') }}">
                                <img src="{{ asset('img/logo.png') }}" alt="{{ config('app.name') }}" class="h-9 xl:h-10 w-auto">
                            </a>
                        @else
                            <a href="{{ route('dashboard') }}">
                                <img src="{{ asset('img/logo.png') }}" alt="{{ config('app.name') }}" class="h-9 xl:h-10 w-auto">
                            </a>
                        @endif
                    </div>
                </div>
                <div class="w-full xl:pointer-events-auto" id="__sidebarNavigationWrapper">
                    <div class="px-3">
                        <x-sidebar.nav-wrapper>

                            @if (Auth()->user()->role == 'member' || Auth()->user()->role == 'staff' || Auth()->user()->role == 'dropshipper')

                                 <x-sidebar.nav-item :active="request()->routeIs('student_fee.create')">
                                    <x-sidebar.nav-link class="mb-1 rounded-md bg-red-200 hover:bg-blue-200" :href="route('student_fee.create')" :active="request()->routeIs('student_fee.create')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-border-middle" viewBox="0 0 16 16">
                                            <path d="M.969 0H0v.969h.5V1h.469V.969H1V.5H.969V0zm.937 1h.938V0h-.938v1zm1.875 0h.938V0H3.78v1zm1.875 0h.938V0h-.938v1zM8.5 16h-1V0h1v16zm.906-15h.938V0h-.938v1zm1.875 0h.938V0h-.938v1zm1.875 0h.938V0h-.938v1zm1.875 0h.469V.969h.5V0h-.969v.5H15v.469h.031V1zM1 2.844v-.938H0v.938h1zm14-.938v.938h1v-.938h-1zM1 4.719V3.78H0v.938h1zm14-.938v.938h1V3.78h-1zM1 6.594v-.938H0v.938h1zm14-.938v.938h1v-.938h-1zM.5 8.5h.469v-.031H1V7.53H.969V7.5H.5v.031H0v.938h.5V8.5zm1.406 0h.938v-1h-.938v1zm1.875 0h.938v-1H3.78v1zm1.875 0h.938v-1h-.938v1zm3.75 0h.938v-1h-.938v1zm1.875 0h.938v-1h-.938v1zm1.875 0h.938v-1h-.938v1zm1.875 0h.469v-.031h.5V7.53h-.5V7.5h-.469v.031H15v.938h.031V8.5zM0 9.406v.938h1v-.938H0zm16 .938v-.938h-1v.938h1zm-16 .937v.938h1v-.938H0zm16 .938v-.938h-1v.938h1zm-16 .937v.938h1v-.938H0zm16 .938v-.938h-1v.938h1zM0 16h.969v-.5H1v-.469H.969V15H.5v.031H0V16zm1.906 0h.938v-1h-.938v1zm1.875 0h.938v-1H3.78v1zm1.875 0h.938v-1h-.938v1zm3.75 0h.938v-1h-.938v1zm1.875 0h.938v-1h-.938v1zm1.875 0h.938v-1h-.938v1zm1.875-.5v.5H16v-.969h-.5V15h-.469v.031H15v.469h.031z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Take Fee') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>

                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Admission Form - Admission Form'))
                                    <x-sidebar.nav-item :active="request()->is('admission_form*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('admission_form*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Admission') }}
                                        </span>
                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('admission_form*')" x-show="subnavOpen">
                                            @if(\App\Models\Role::checkRolePermissions('Can access menu: Admission Form - Admission Form'))
                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('admission_form.index') }}" :active="request()->is('admission_form*')">
                                                    {{ __('translation.Form Sale') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>

                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('admission_form.confirm') }}" :active="request()->is('admission_form*')">
                                                    {{ __('translation.Confirmation') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>

                                            @endif
                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif


                            @if(\App\Models\Role::checkRolePermissions('Can access menu: Others Collection - Others Collection'))
                                <x-sidebar.nav-item :active="request()->routeIs('others.collection')">
                                    <x-sidebar.nav-link :href="route('others.collection')" :active="request()->routeIs('others.collection')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-person-badge" viewBox="0 0 16 16">
                                            <path d="M6.5 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3zM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0z"/>
                                            <path d="M4.5 0A2.5 2.5 0 0 0 2 2.5V14a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2.5A2.5 2.5 0 0 0 11.5 0h-7zM3 2.5A1.5 1.5 0 0 1 4.5 1h7A1.5 1.5 0 0 1 13 2.5v10.795a4.2 4.2 0 0 0-.776-.492C11.392 12.387 10.063 12 8 12s-3.392.387-4.224.803a4.2 4.2 0 0 0-.776.492V2.5z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Others Collection') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>
                            @endif

                            @if(\App\Models\Role::checkRolePermissions('Can access menu: Transactions - Transactions'))
                                <x-sidebar.nav-item :active="request()->routeIs('transactions')">
                                    <x-sidebar.nav-link :href="route('transactions')" :active="request()->routeIs('transactions')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-person-badge" viewBox="0 0 16 16">
                                            <path d="M6.5 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3zM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0z"/>
                                            <path d="M4.5 0A2.5 2.5 0 0 0 2 2.5V14a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2.5A2.5 2.5 0 0 0 11.5 0h-7zM3 2.5A1.5 1.5 0 0 1 4.5 1h7A1.5 1.5 0 0 1 13 2.5v10.795a4.2 4.2 0 0 0-.776-.492C11.392 12.387 10.063 12 8 12s-3.392.387-4.224.803a4.2 4.2 0 0 0-.776.492V2.5z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Transactions') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>
                            @endif

                            @if (in_array('Can access menu: StudentFee - StudentFee', session('assignedPermissions')))
                                <x-sidebar.nav-item :active="request()->is('student_fee*')" x-data="{ subnavOpen: false }">
                                    <x-sidebar.nav-link href="#" :active="request()->is('student_fee*')" x-on:click="subnavOpen = !subnavOpen">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-arrow-down-up" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M11.5 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L11 2.707V14.5a.5.5 0 0 0 .5.5zm-7-14a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L4 13.293V1.5a.5.5 0 0 1 .5-.5z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                        {{ __('translation.Fee Details') }}
                                    </span>
                                        <span class="absolute left-auto right-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                            <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                        </svg>
                                    </span>
                                    </x-sidebar.nav-link>
                                    <x-sidebar.subnav-wrapper :active="request()->routeIs('student_fee*')" x-show="subnavOpen">

                                        <x-sidebar.subnav-item>
                                            <x-sidebar.subnav-link href="{{ route('student_fee.create') }}" :active="request()->routeIs('student_fee.create')">
                                                {{ __('translation.Add New Fee') }}
                                            </x-sidebar.subnav-link>
                                        </x-sidebar.subnav-item>
                                        <x-sidebar.subnav-item>
                                            <x-sidebar.subnav-link href="{{ route('student_fee.index') }}" :active="request()->is('student_fee*')">
                                                {{ __('translation.Fee List') }}
                                            </x-sidebar.subnav-link>
                                        </x-sidebar.subnav-item>
                                        <x-sidebar.subnav-item>
                                            <x-sidebar.subnav-link href="{{ route('student_fee_history') }}" :active="request()->routeIs('in-out-history')">
                                                {{ __('translation.History') }}
                                            </x-sidebar.subnav-link>
                                        </x-sidebar.subnav-item>
                                    </x-sidebar.subnav-wrapper>
                                </x-sidebar.nav-item>
                            @endif



                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
                                    <x-sidebar.nav-item :active="request()->is('students*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('students*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Students') }}
                                        </span>
                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('students*')" x-show="subnavOpen">
                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('students.index') }}" :active="request()->is('students*')">
                                                    {{ __('translation.Students') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>
                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif


                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Admit Cards - Admit Cards'))
                                    <x-sidebar.nav-item :active="request()->routeIs('admit_cards')">
                                        <x-sidebar.nav-link :href="route('admit_cards')" :active="request()->routeIs('admit_cards')">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-upc-scan" viewBox="0 0 16 16">
                                                <path d="M1.5 1a.5.5 0 0 0-.5.5v3a.5.5 0 0 1-1 0v-3A1.5 1.5 0 0 1 1.5 0h3a.5.5 0 0 1 0 1h-3zM11 .5a.5.5 0 0 1 .5-.5h3A1.5 1.5 0 0 1 16 1.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 1-.5-.5zM.5 11a.5.5 0 0 1 .5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 1 0 1h-3A1.5 1.5 0 0 1 0 14.5v-3a.5.5 0 0 1 .5-.5zm15 0a.5.5 0 0 1 .5.5v3a1.5 1.5 0 0 1-1.5 1.5h-3a.5.5 0 0 1 0-1h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 1 .5-.5zM3 4.5a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7zm2 0a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7zm2 0a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7zm2 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-7zm3 0a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                                {{ __('translation.Admit Cards') }}
                                            </span>
                                        </x-sidebar.nav-link>
                                    </x-sidebar.nav-item>
                                @endif
                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Seat Plans - Seat Plans'))
                                    <x-sidebar.nav-item :active="request()->routeIs('seat_plans')">
                                        <x-sidebar.nav-link :href="route('seat_plans')" :active="request()->routeIs('seat_plans')">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-upc-scan" viewBox="0 0 16 16">
                                                <path d="M1.5 1a.5.5 0 0 0-.5.5v3a.5.5 0 0 1-1 0v-3A1.5 1.5 0 0 1 1.5 0h3a.5.5 0 0 1 0 1h-3zM11 .5a.5.5 0 0 1 .5-.5h3A1.5 1.5 0 0 1 16 1.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 1-.5-.5zM.5 11a.5.5 0 0 1 .5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 1 0 1h-3A1.5 1.5 0 0 1 0 14.5v-3a.5.5 0 0 1 .5-.5zm15 0a.5.5 0 0 1 .5.5v3a1.5 1.5 0 0 1-1.5 1.5h-3a.5.5 0 0 1 0-1h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 1 .5-.5zM3 4.5a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7zm2 0a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7zm2 0a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7zm2 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-7zm3 0a.5.5 0 0 1 1 0v7a.5.5 0 0 1-1 0v-7z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                                {{ __('translation.Seat Plans') }}
                                            </span>
                                        </x-sidebar.nav-link>
                                    </x-sidebar.nav-item>
                                @endif


                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Marks - Marks'))
                                    <x-sidebar.nav-item :active="request()->is('marks*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('marks*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                                {{ __('translation.Marks') }}
                                            </span>

                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('marks*') OR request()->is('marks_entry_form') OR request()->is('edit_marks_by_subject') OR request()->is('marks_excel_import_form')" x-show="subnavOpen">
                                            @if(\App\Models\Role::checkRolePermissions('Can access menu: Marks - Marks'))
                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('marks.marks_entry_form') }}" :active="request()->is('marks_entry_form')">
                                                    {{ __('translation.Download Marks Entry Form') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>
                                            @endif
                                            @if(\App\Models\Role::checkRolePermissions('Can access menu: Marks - Edit Marks'))
                                                <x-sidebar.subnav-item>
                                                    <x-sidebar.subnav-link href="{{ route('marks.edit_marks_by_subject') }}" :active="request()->is('edit_marks_by_subject')">
                                                        {{ __('translation.Edit Marks By Subject') }}
                                                    </x-sidebar.subnav-link>
                                                </x-sidebar.subnav-item>
                                            @endif
                                            @if(\App\Models\Role::checkRolePermissions('Can access menu: Marks - Upload Marks'))
                                                <x-sidebar.subnav-item>
                                                    <x-sidebar.subnav-link href="{{ route('marks.marks_excel_import_form') }}" :active="request()->is('marks_excel_import_form')">
                                                        {{ __('translation.Upload Marks') }}
                                                    </x-sidebar.subnav-link>
                                                </x-sidebar.subnav-item>
                                            @endif
                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif

                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Results - Results'))
                                    <x-sidebar.nav-item :active="request()->is('results*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('results*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                                {{ __('translation.Results') }}
                                            </span>

                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('results*') OR request()->is('marks_by_subject') OR request()->is('marks_by_class') OR request()->is('merit_list')" x-show="subnavOpen">

                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('results.index') }}" :active="request()->is('index')">
                                                    {{ __('translation.Marksheets') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>

                                            <x-sidebar.subnav-link href="{{ route('results.marks_by_subject') }}" :active="request()->is('marks_by_subject')">
                                                {{ __('translation.Marks By Subject') }}
                                            </x-sidebar.subnav-link>

                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('results.marks_by_class') }}" :active="request()->is('marks_by_class')">
                                                    {{ __('translation.Marks By Class') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>

                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('results.merit_list') }}" :active="request()->is('merit_list')">
                                                    {{ __('translation.Merit List') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>
                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif

                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Reports - Reports'))
                                   <x-sidebar.nav-item :active="request()->is('reports/student_fee_report*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('report-stock*') OR request()->routeIs('activity_log')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-bar-chart" viewBox="0 0 16 16">
                                                <path d="M4 11H2v3h2v-3zm5-4H7v7h2V7zm5-5v12h-2V2h2zm-2-1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1h-2zM6 7a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v7a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V7zm-5 4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1v-3z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                                Report
                                            </span>
                                                <span class="absolute left-auto right-4">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                    <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                                </svg>
                                            </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('reports/expenses_report*') OR request()->is('reports/student_fee_report*') OR request()->is('reports/transaction_report*')" x-show="subnavOpen">


                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ url('reports/expenses_report') }}" :active="request()->is('reports/expenses_report')">
                                                    {{ __('translation.Expenses') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>

                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ url('reports/student_fee_report') }}" :active="request()->is('reports/student_fee_report')">
                                                    {{ __('translation.Student Fee') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>

                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ url('reports/transaction_report') }}" :active="request()->is('reports/transaction_report')">
                                                    {{ __('translation.Transaction Report') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>

                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif




                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Promotion - Promotion'))
                                    <x-sidebar.nav-item :active="request()->is('promotion*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('promotion*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Promotion') }}
                                        </span>
                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('promotion*')" x-show="subnavOpen">
                                        @if(\App\Models\Role::checkRolePermissions('Can access menu: promotion - promotion'))
                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('promotion') }}" :active="request()->is('students*')">
                                                    {{ __('translation.Promotion') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>
                                            @endif

                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif


                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Teachers - Teachers'))
                                    <x-sidebar.nav-item :active="request()->is('teachers*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('teachers*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Teachers') }}
                                        </span>
                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('teachers*')" x-show="subnavOpen">
                                             <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('teachers.index') }}" :active="request()->is('teachers*')">
                                                    {{ __('translation.Teachers') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>
                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif

                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Staffs - Staffs'))
                                    <x-sidebar.nav-item :active="request()->is('staffs*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('staffs*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Staffs') }}
                                        </span>
                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('staffs*')" x-show="subnavOpen">
                                             <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('staffs.index') }}" :active="request()->is('staffs*')">
                                                    {{ __('translation.Staffs') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>
                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif

                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Voters - Voters'))
                                    <x-sidebar.nav-item :active="request()->routeIs('voters')">
                                        <x-sidebar.nav-link :href="url('voters')" :active="request()->routeIs('voters')">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-person-badge" viewBox="0 0 16 16">
                                                <path d="M6.5 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3zM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0z"/>
                                                <path d="M4.5 0A2.5 2.5 0 0 0 2 2.5V14a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2.5A2.5 2.5 0 0 0 11.5 0h-7zM3 2.5A1.5 1.5 0 0 1 4.5 1h7A1.5 1.5 0 0 1 13 2.5v10.795a4.2 4.2 0 0 0-.776-.492C11.392 12.387 10.063 12 8 12s-3.392.387-4.224.803a4.2 4.2 0 0 0-.776.492V2.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                                {{ __('translation.Voters') }}
                                            </span>
                                        </x-sidebar.nav-link>
                                    </x-sidebar.nav-item>
                                @endif


                                @if(\App\Models\Role::checkRolePermissions('Can access menu: Student ID Cards - Student ID Cards'))
                                    <x-sidebar.nav-item :active="request()->is('students*')" x-data="{ subnavOpen: false }">
                                        <x-sidebar.nav-link href="#" :active="request()->is('students*')" x-on:click="subnavOpen = !subnavOpen">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-plus" viewBox="0 0 16 16">
                                                <path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H1s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C9.516 10.68 8.289 10 6 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                                <path fill-rule="evenodd" d="M13.5 5a.5.5 0 0 1 .5.5V7h1.5a.5.5 0 0 1 0 1H14v1.5a.5.5 0 0 1-1 0V8h-1.5a.5.5 0 0 1 0-1H13V5.5a.5.5 0 0 1 .5-.5z"/>
                                            </svg>
                                            <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Student ID Cards') }}
                                        </span>
                                            <span class="absolute left-auto right-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-3 h-3 bi bi-caret-down" viewBox="0 0 16 16">
                                                <path d="M3.204 5h9.592L8 10.481 3.204 5zm-.753.659 4.796 5.48a1 1 0 0 0 1.506 0l4.796-5.48c.566-.647.106-1.659-.753-1.659H3.204a1 1 0 0 0-.753 1.659z"/>
                                            </svg>
                                        </span>
                                        </x-sidebar.nav-link>
                                        <x-sidebar.subnav-wrapper :active="request()->is('student_id_cards*')" x-show="subnavOpen">
                                        @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
                                            <x-sidebar.subnav-item>
                                                <x-sidebar.subnav-link href="{{ route('student_id_cards.index') }}" :active="request()->is('students*')">
                                                    {{ __('translation.Students ID Cards') }}
                                                </x-sidebar.subnav-link>
                                            </x-sidebar.subnav-item>
                                            @endif

                                        </x-sidebar.subnav-wrapper>
                                    </x-sidebar.nav-item>
                                @endif


                            @endif



                            @if (Auth()->user()->role == 'admin')
                                <x-sidebar.nav-item :active="request()->routeIs('admin dashboard')">
                                    <x-sidebar.nav-link :href="route('admin dashboard')" :active="request()->routeIs('admin dashboard')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-speedometer2" viewBox="0 0 16 16">
                                            <path d="M8 4a.5.5 0 0 1 .5.5V6a.5.5 0 0 1-1 0V4.5A.5.5 0 0 1 8 4zM3.732 5.732a.5.5 0 0 1 .707 0l.915.914a.5.5 0 1 1-.708.708l-.914-.915a.5.5 0 0 1 0-.707zM2 10a.5.5 0 0 1 .5-.5h1.586a.5.5 0 0 1 0 1H2.5A.5.5 0 0 1 2 10zm9.5 0a.5.5 0 0 1 .5-.5h1.5a.5.5 0 0 1 0 1H12a.5.5 0 0 1-.5-.5zm.754-4.246a.389.389 0 0 0-.527-.02L7.547 9.31a.91.91 0 1 0 1.302 1.258l3.434-4.297a.389.389 0 0 0-.029-.518z"/>
                                            <path fill-rule="evenodd" d="M0 10a8 8 0 1 1 15.547 2.661c-.442 1.253-1.845 1.602-2.932 1.25C11.309 13.488 9.475 13 8 13c-1.474 0-3.31.488-4.615.911-1.087.352-2.49.003-2.932-1.25A7.988 7.988 0 0 1 0 10zm8-7a7 7 0 0 0-6.603 9.329c.203.575.923.876 1.68.63C4.397 12.533 6.358 12 8 12s3.604.532 4.923.96c.757.245 1.477-.056 1.68-.631A7 7 0 0 0 8 3z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Dashboard') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>

                                <x-sidebar.nav-item :active="request()->routeIs('staff.manage')">
                                    <x-sidebar.nav-link :href="route('staff.manage')" :active="request()->routeIs('staff.manage')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-person-badge" viewBox="0 0 16 16">
                                            <path d="M6.5 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3zM11 8a3 3 0 1 1-6 0 3 3 0 0 1 6 0z"/>
                                            <path d="M4.5 0A2.5 2.5 0 0 0 2 2.5V14a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2.5A2.5 2.5 0 0 0 11.5 0h-7zM3 2.5A1.5 1.5 0 0 1 4.5 1h7A1.5 1.5 0 0 1 13 2.5v10.795a4.2 4.2 0 0 0-.776-.492C11.392 12.387 10.063 12 8 12s-3.392.387-4.224.803a4.2 4.2 0 0 0-.776.492V2.5z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Manage Staff') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>

                                <x-sidebar.nav-item :active="request()->routeIs('manage person')">
                                    <x-sidebar.nav-link :href="route('manage person')" :active="request()->routeIs('manage person')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-shop" viewBox="0 0 16 16">
                                            <path d="M2.97 1.35A1 1 0 0 1 3.73 1h8.54a1 1 0 0 1 .76.35l2.609 3.044A1.5 1.5 0 0 1 16 5.37v.255a2.375 2.375 0 0 1-4.25 1.458A2.371 2.371 0 0 1 9.875 8 2.37 2.37 0 0 1 8 7.083 2.37 2.37 0 0 1 6.125 8a2.37 2.37 0 0 1-1.875-.917A2.375 2.375 0 0 1 0 5.625V5.37a1.5 1.5 0 0 1 .361-.976l2.61-3.045zm1.78 4.275a1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0 1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0 1.375 1.375 0 1 0 2.75 0V5.37a.5.5 0 0 0-.12-.325L12.27 2H3.73L1.12 5.045A.5.5 0 0 0 1 5.37v.255a1.375 1.375 0 0 0 2.75 0 .5.5 0 0 1 1 0zM1.5 8.5A.5.5 0 0 1 2 9v6h1v-5a1 1 0 0 1 1-1h3a1 1 0 0 1 1 1v5h6V9a.5.5 0 0 1 1 0v6h.5a.5.5 0 0 1 0 1H.5a.5.5 0 0 1 0-1H1V9a.5.5 0 0 1 .5-.5zM4 15h3v-5H4v5zm5-5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1v-3zm3 0h-2v3h2v-3z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Manage Person') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>

                                <x-sidebar.nav-item :active="request()->routeIs('package')">
                                    <x-sidebar.nav-link :href="route('package')" :active="request()->routeIs('package')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-box" viewBox="0 0 16 16">
                                            <path d="M8.186 1.113a.5.5 0 0 0-.372 0L1.846 3.5 8 5.961 14.154 3.5 8.186 1.113zM15 4.239l-6.5 2.6v7.922l6.5-2.6V4.24zM7.5 14.762V6.838L1 4.239v7.923l6.5 2.6zM7.443.184a1.5 1.5 0 0 1 1.114 0l7.129 2.852A.5.5 0 0 1 16 3.5v8.662a1 1 0 0 1-.629.928l-7.185 2.874a.5.5 0 0 1-.372 0L.63 13.09a1 1 0 0 1-.63-.928V3.5a.5.5 0 0 1 .314-.464L7.443.184z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Package') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>

                                <x-sidebar.nav-item :active="request()->routeIs('user logo')">
                                    <x-sidebar.nav-link :href="route('user logo')" :active="request()->routeIs('user logo')">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 h-4 bi bi-person" viewBox="0 0 16 16">
                                            <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.User Avatar') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>
                            @endif

                            @if (Auth()->user()->role == 'member' || Auth()->user()->role == 'staff')
                                <x-sidebar.nav-item :active="request()->routeIs('classes.index') OR request()->routeIs('cronReport') OR request()->routeIs('school-info-settings.index') OR request()->is('manage-shipper*') OR request()->is('add-cost*')">
                                    <x-sidebar.nav-link href="{{ route('classes.index') }}" :active="request()->routeIs('categories.index')">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="w-4 h-4 bi bi-gear" viewBox="0 0 16 16">
                                            <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492zM5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0z"/>
                                            <path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52l-.094-.319zm-2.633.283c.246-.835 1.428-.835 1.674 0l.094.319a1.873 1.873 0 0 0 2.693 1.115l.291-.16c.764-.415 1.6.42 1.184 1.185l-.159.292a1.873 1.873 0 0 0 1.116 2.692l.318.094c.835.246.835 1.428 0 1.674l-.319.094a1.873 1.873 0 0 0-1.115 2.693l.16.291c.415.764-.42 1.6-1.185 1.184l-.291-.159a1.873 1.873 0 0 0-2.693 1.116l-.094.318c-.246.835-1.428.835-1.674 0l-.094-.319a1.873 1.873 0 0 0-2.692-1.115l-.292.16c-.764.415-1.6-.42-1.184-1.185l.159-.291A1.873 1.873 0 0 0 1.945 8.93l-.319-.094c-.835-.246-.835-1.428 0-1.674l.319-.094A1.873 1.873 0 0 0 3.06 4.377l-.16-.292c-.415-.764.42-1.6 1.185-1.184l.292.159a1.873 1.873 0 0 0 2.692-1.115l.094-.319z"/>
                                        </svg>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            {{ __('translation.Settings') }}
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>
                            @endif



                            @if (Auth::user()->role == 'admin')
                                <x-sidebar.nav-item :active="request()->routeIs('translation.index')">
                                    <x-sidebar.nav-link :href="route('translation.index')" :active="request()->routeIs('translation.index')">
                                        <i class="bi bi-translate text-base"></i>
                                        <span class="ml-2 relative top-[0.05rem]">
                                            Translation
                                        </span>
                                    </x-sidebar.nav-link>
                                </x-sidebar.nav-item>
                            @endif

                        </x-sidebar.nav-wrapper>
                    </div>
                </div>
            </div>
        </div>
        <div class="w-1/3 xl:hidden">
            <button type="button" class="px-6 py-4 border-0 bg-white text-gray-800 outline-none focus:outline-none" x-on:click="sidebarOpen = true">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7" />
                </svg>
            </button>
        </div>
        <div class="w-1/3 xl:w-60 xl:z-30 xl:pointer-events-auto xl:bg-white">
            <div class="w-full h-full flex items-center justify-center">
                @if(session('roleName') == 'dropshipper')
                    <a href="{{ route('order_management.index') }}" class="py-2">
                        <img src="{{ asset('img/logo.png') }}" alt="{{ config('app.name') }}" class="h-9 w-auto">
                    </a>
                @else
                    <a href="{{ route('dashboard') }}" class="py-2">
                        <img src="{{ asset('img/logo.png') }}" alt="{{ config('app.name') }}" class="h-9 w-auto">
                    </a>
                @endif
            </div>
        </div>
        <div class="w-1/3 xl:w-60 xl:z-30 relative xl:pt-4 xl:pointer-events-auto xl:bg-white" x-data="{ dropdownOpen: false }">
            <div class="w-full flex justify-end xl:justify-start">
                <button type="button" class="xl:w-full h-9 xl:h-auto px-7 xl:px-5 py-2 bg-transparent xl:hover:bg-blue-100 border-0 inline-flex xl:flex-col items-center xl:items-start outline-none focus:outline-none cursor-pointer" x-on:click="dropdownOpen = !dropdownOpen" x-on:click.away="dropdownOpen = false">
                    <div class="xl:inline-flex xl:items-center">
                        <div class="relative">
                            <img src="{{ Auth::user()->avatar_url }}" alt="{{ Auth::user()->name }}" class="w-8 xl:w-10 h-8 xl:h-10 rounded-full">
                        </div>
                        <div class="hidden xl:block ml-2 xl:ml-4 text-left">
                            <span class="block text-gray-800 font-bold whitespace-nowrap">
                                {{ Str::limit(ucwords(Auth::user()->name), 20) }}
                            </span>
                            <span class="text-gray-500 text-xs">
                                {{ ucwords(Auth::user()->role) }}
                            </span>
                        </div>
                    </div>
                    <div class="hidden xl:w-full xl:flex xl:justify-center xl:mt-1">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" class="w-4 bi bi-chevron-compact-down" viewBox="0 0 16 16">
                            <path fill-rule="evenodd" d="M1.553 6.776a.5.5 0 0 1 .67-.223L8 9.44l5.776-2.888a.5.5 0 1 1 .448.894l-6 3a.5.5 0 0 1-.448 0l-6-3a.5.5 0 0 1-.223-.67z"/>
                        </svg>
                    </div>
                </button>
            </div>

            <div class="absolute xl:relative top-10 xl:top-0 right-8 xl:right-0 2xl:right-0 left-auto w-48 xl:w-full py-1 border border-solid border-gray-300 shadow-lg bg-white hidden z-10" :class="{ 'hidden' : dropdownOpen === false }">
                <a href="{{ route('profile') }}" class="block px-5 py-2 text-gray-800 hover:bg-gray-100 no-underline">
                    {{ __('translation.Your Profile') }}
                </a>
                @if (Auth::user()->role == 'member')
                    <a href="{{ route('staff.manage') }}" class="block px-5 py-2 text-gray-800 hover:bg-gray-100 no-underline">
                        {{ __('translation.Manage Users') }}
                    </a>

                @endif
                <hr class="w-full border border-r-0 border-b-0 border-l-0 border-gray-200 my-1">
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <a href="#" onClick="event.preventDefault(); this.closest('form').submit();" class="block px-5 py-2 text-gray-800 hover:bg-gray-100 no-underline">
                        Sign Out
                    </a>
                </form>
            </div>
        </div>
    </nav>
</header>
