@csrf
    <input type="hidden" name="id" value="{{ $id }}">
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-3 sm:gap-x-3 mt-0">
        <div class="lg:col-span-1 justify-between items-start mb-6 p-3 border-solid border-gray-300">

            <div class="mt-2">
                <x-label>Pay For</x-label>
                <x-select id="expense_type_id" name="expense_type_id">
                    <option value="">Select</option>
                    @if($expense_types)
                        @foreach($expense_types as $expense_type)
                            <option @if($expense_type->id==$data->expense_type_id) selected @endif value="{{$expense_type->id}}">{{$expense_type->name}}</option>';
                        @endforeach
                    @endif
                </x-select>
            </div>

            <div class="mt-2">
                <x-label>Payment Method</x-label>
                <select id="up_payment_method" name="payment_method" class="form-control">
                    <option @if($data->payment_method=='cash') selected @endif value='cash'>Cash</option>
                    <option @if($data->payment_method=='cheque') selected @endif value='cheque'>Cheque</option>
                    <option @if($data->payment_method=='mobile_banking') selected @endif value='mobile_banking'>Mobile Banking</option>
                </select>
            </div>


            <div id="up_pm_cheque_wrapper" @if($data->payment_method=='cash' || $data->payment_method=='mobile_banking') hidden @endif>
                <div class="mt-2">
                    <x-label>Bank Name</x-label>
                    <x-select id="up_bank_name" name="bank_name">
                        <option value="">Select</option>
                        @if($banks)
                        @foreach($banks as $bank)
                            <option @if($data->payment_method=='cheque' && $bank->id==$data->bank_or_wallet_id) selected @endif value="{{$bank->id}}">{{$bank->name}}</option>';
                        @endforeach
                        @endif
                    </x-select>
                </div>

                @php
                if($data->payment_method=='cheque'){
                    $acc_or_mobile_no = $data->acc_or_mobile_no;
                }else{
                    $acc_or_mobile_no = '';
                }
                @endphp

                <div class="mt-2">
                    <x-label>Cheque No</x-label>
                    <x-input type="text" id="up_cheque_no" name="cheque_no" value="{{$acc_or_mobile_no}}"></x-input>
                </div>
            </div>

            <div id="up_pm_mobile_banking_wrapper" @if($data->payment_method=='cash' || $data->payment_method=='cheque') hidden @endif>
                <div class="mt-2">
                    <x-label>Mobile Walet</x-label>
                    <x-select id="up_wallet_name" name="wallet_name" >
                        <option value="">Select</option>
                        @if($mobile_wallets)
                        @foreach($mobile_wallets as $mobile_wallet)
                            <option @if($data->payment_method=='mobile_banking' && $mobile_wallet->id==$data->bank_or_wallet_id) selected @endif value="{{$mobile_wallet->id}}">{{$mobile_wallet->name}}</option>';
                        @endforeach
                        @endif
                    </x-select>
                </div>
                @php
                if($data->payment_method=='mobile_banking'){
                    $acc_or_mobile_no = $data->acc_or_mobile_no;
                }else{
                    $acc_or_mobile_no = '';
                }
                @endphp
                <div class="mt-2">
                    <x-label>Mobile No</x-label>
                    <x-input type="text" id="up_mobile_no" name="mobile_no"  value="{{$acc_or_mobile_no}}" ></x-input>
                </div>
            </div>
        </div>

        <div class="lg:col-span-1 justify-between items-start mb-6 p-3 border-solid border-gray-300">
            <div class="mt-2">
                <x-label>
                    Amount
                </x-label>
                <x-input type="number" name="amount" id="amount" :value="old('amount') ?? $data->amount" required>
                </x-input>
            </div>
            <div class="mt-2">
                <x-label>
                    Note
                </x-label>
                <x-textarea name="note" id="note">{{old('note') ?? $data->note}}</x-textarea>
            </div>
        </div>
    </div>
    <div class="flex justify-end py-4">
        <x-button color="blue">Update</x-button>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>

    <script type="text/javascript">
    $(document).ready(function(){
        jQuery("#up_payment_method").on("change", function(){
            if($(this).val()=='cheque'){
                $("#up_pm_mobile_banking_wrapper").attr("hidden","hidden");
                $("#up_pm_cheque_wrapper").removeAttr("hidden");
            }
            else if($(this).val()=='mobile_banking'){
                $("#up_pm_cheque_wrapper").attr("hidden","hidden");
                $("#up_pm_mobile_banking_wrapper").removeAttr("hidden");
                $("#up_pm_mobile_banking_wrapper").removeAttr("hidden");
            }else{
                $("#up_pm_mobile_banking_wrapper").attr("hidden","hidden");
                $("#up_pm_cheque_wrapper").attr("hidden","hidden");

            }
        });
    });
    </script>



