<x-app-layout>
    @section('title', 'Admit Cards')

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css">

    @endpush

    <style type="text/css">
         .arrive_soon tbody tr{background-color:#ffd57f !important;}
         .overdue tbody tr{background-color:#f7a49e !important;}
        </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))


    <x-card title="{{ __('translation.Admit Cards') }}">
        <div class="col-span-12">
            @if (session('success'))
                <x-alert-success>
                    {!! session('success') !!}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif
        </div>



        <form method="POST" action="" id="__formMarksheet" enctype="multipart/form-data">
            @csrf
        </form>
            <div class="flex flex-col lg:flex-row mb-10 lg:mb-4">
                <div class="w-full lg:w-2/5 mb-6 lg:mb-0 ml-2">
                    <label class="mb-0">
                        {{ __('translation.Exam Name') }} :
                    </label>
                    <x-select class="exam_id"  id="__selectExamFilter" name="exam_id" style="width: 100%;">
                        <option value="" selected disabled>
                            {{ '- ' . __('translation.Select Exam') . ' -' }}
                        </option>
                        @if (isset($exams))
                            @foreach ($exams as $exam)
                              <option value="{{$exam->id}}">
                                {{$exam->exam_name}}</option>
                            @endforeach
                        @endif
                    </x-select>
                </div>

                <div class="w-full lg:w-2/5 mb-6 lg:mb-0 ml-5">
                    <label class="mb-0">
                        {{ __('translation.Class') }} :
                    </label>
                    <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                        <option value="" selected disabled>
                            {{ '- ' . __('translation.Select Class') . ' -' }}
                        </option>
                        @if (isset($classes))
                            @foreach ($classes as $classe)
                                <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                            @endforeach
                        @endif
                    </x-select>
                </div>

                <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                    <label class="mb-0">
                        {{ __('translation.Section') }} :
                    </label>
                    <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                        <option value="" selected disabled>
                            {{ '- ' . __('translation.Select Section') . ' -' }}
                        </option>
                        @if (isset($sections))
                            @foreach ($sections as $section)
                                <option value="{{$section->id}}">{{$section->section_name}}</option>
                            @endforeach
                        @endif
                    </x-select>
                </div>

                <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                    <label class="mb-0">
                        {{ __('translation.Session') }} :
                    </label>
                    <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                        <option value="" selected disabled>
                            {{ '- ' . __('translation.Select Session') . ' -' }}
                        </option>
                        @if (isset($sessions))
                            @foreach ($sessions as $session)
                                <option value="{{$session->id}}">{{$session->session_name}}</option>
                            @endforeach
                        @endif
                    </x-select>
                </div>

                <div class="w-full lg:w-1/4 mb-6 lg:mb-0 ml-2 mt-6">
                    <x-button color="green" id="BtnPDFAdmitCard" data-toggle="modal">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-download" viewBox="0 0 16 16">
                            <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/>
                            <path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/>
                        </svg>
                        <span class="ml-2">
                            {{ __('translation.PDF Print') }}
                        </span>
                    </x-button>
                </div>

            </div>


        <div class="overflow-x-none">
            <table class="w-full" id="__studentTable">
                <thead>
                    <tr>
                        <th>

                        </th>

                        <th>
                            {{ __('translation.Details') }}
                        </th>

                        <th>
                            {{ __('translation.Name') }}
                        </th>

                        <th>
                            {{ __('translation.Student ID') }}
                        </th>

                        <th>
                            {{ __('translation.Roll No') }}
                        </th>

                        <th>
                            {{ __('translation.Class') }}
                        </th>

                        <th>
                            {{ __('translation.Section') }}
                        </th>

                        <th>
                            {{ __('translation.Session') }}
                        </th>

                        <th>
                            {{ __('translation.Action') }}
                        </th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </x-card>
   @endif



    <x-modal.modal-full class="modal-admit-card modal-hide">
        <x-modal.header>
            <x-modal.title>
                Admit Card
            </x-modal.title>
            <x-modal.close-button id="closeModalAdmitCard" />
        </x-modal.header>
        <x-modal.body>
        <div id="admit-card-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-full>

    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>
        <script src="{{asset('js/dataTables.checkboxes.min.js')}}"></script>
        <script>
            const studentTableUrl = '{{ route('admit_cards_datatable_by_class') }}';
            var status = 'all';
            var datatable;
            function loadStudentsTable(url) {
                $('#__selectTypeFilter').val('').trigger('change');
                datatable = $('#__studentTable').DataTable({
                    "pageLength": 100,
                    processing: true,
                    serverSide: true,
                    "ajax": {
                        "url": url,
                        data: {
                            examId: $("#__selectExamFilter").val(),
                            classId: $("#__selectClassFilter").val(),
                            sectionId: $("#__selectSectionFilter").val(),
                            sessionId: $("#__selectSessionFilter").val(),
                        },
                        "dataSrc": function ( json ) {
                        for ( var i=0, ien=json.data.length ; i<ien ; i++ ) {
                            json.data[i][0] = json.data[i][0];
                        }
                        console.log(json);
                        if(json.supplier !='' && json.draw=='1'){
                        $(".all .order-purchase__filter-total").html(" ("+json.suppliersCountAll+")");
                        $(".open .order-purchase__filter-total").html(" ("+json.suppliersCountOpen+")");
                        $(".arrive .order-purchase__filter-total").html(" ("+json.suppliersCountArrive+")");

                        $(".closes .order-purchase__filter-total").html(" ("+json.suppliersCountClose+")");
                        }
                         return json.data;
                        }
                    },
                    columnDefs: [
                            {
                            'targets': 0,
                            orderable: false,
                            visible: true,
                            'checkboxes': {
                                'selectRow': true
                                },
                            },
                            {"targets": [2,3,4,5,6,7], "className": "text-center"},
                            {"width": "23%", "targets": [2], "className": "text-center"},

                    ],
                    order: [
                        [ 4, 'asc' ]
                    ],
                    columns: [
                        {
                            name: 'checkbox',
                            data: 'id'
                        },
                        {
                            name: 'details',
                            data: 'details'
                        },

                        {
                            name: 'name',
                            data: 'name'
                        },

                        {
                            name: 'student_code',
                            data: 'student_code'
                        },

                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },

                        {
                            name: 'class_name',
                            data: 'class_name'
                        },

                        {
                            name: 'section_name',
                            data: 'section_name'
                        },

                        {
                            name: 'session_name',
                            data: 'session_name'
                        },
                        {
                            name: 'action',
                            data: 'action'
                        },
                    ],
                    pagingType: 'numbers',

                });
            }

            loadStudentsTable(studentTableUrl);

            $('#__selectClassFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSectionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });

            $('#__selectSessionFilter').change(function() {
                $('#__studentTable').dataTable().fnDestroy();
                $('.btn-status-filter').removeClass('active');
                $(this).addClass("active");

                loadStudentsTable(studentTableUrl);

            });


            $('input[type="search"]').on('keyup', function(e) {

            });


            $('#__selectExamFilter').select2({
                width: 'resolve',
                placeholder: '- Select Exam -',
                allowClear: true
            });

            $('#__selectSessionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Session -',
                allowClear: true
            });

            $('#__selectClassFilter').select2({
                width: 'resolve',
                placeholder: '- Select Class -',
                allowClear: true
            });

            $('#__selectSectionFilter').select2({
                width: 'resolve',
                placeholder: '- Select Section -',
                allowClear: true
            });

            $('#__selectTypeFilter').select2({
                width: 'resolve',
                placeholder: '- Select -',
                allowClear: true,
                value : 'all'
            });


            const PDFUrl = '{{ route('PDF_export_admit_cards') }}';
            let student_ids = '';
            let arr_student_ids = [];
            $(document).on('click', '#BtnPDFAdmitCard', function() {
                let rows_selected = datatable.column(0).checkboxes.selected();
                $.each(rows_selected, function(index, rowId) {
                    arr_student_ids[index] = rowId;
                });

                student_ids = arr_student_ids.join(",");
                fn_Print(student_ids);

            });


            $(document).on('click', '.btnPrintSingleAdmitCard', function() {
                student_id = $(this).data('student_id');
                fn_Print(student_id);

            });


            function fn_Print(student_ids){
                var exam_id = $("#__selectExamFilter").val();
                var class_id = $("#__selectClassFilter").val();
                var session_id = $("#__selectSessionFilter").val();
                var section_id = $("#__selectSectionFilter").val();

                $.ajax({
                       type: 'POST',
                        url: PDFUrl,
                        data: {
                            student_ids: student_ids,
                            exam_id: exam_id,
                            session_id: session_id,
                            class_id: class_id,
                            section_id: section_id,
                        },
                    beforeSend: function() {
                        $('#admit-card-wrapper').html('Admit Card Processing...Please wait....');
                        $('.modal-admit-card').removeClass('modal-hide');
                    }
                }).done(function(response) {
                    arr_student_ids = [];
                    $('#admit-card-wrapper').html(response.message);
                });
            }


            $('#closeModalAdmitCard').click(function() {
                $('.modal-admit-card').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush
</x-app-layout>
