@section('title', 'Students')

@push('top_css')
    <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
@endpush

<style type="text/css">
    .nav>li a.active{
        background: #dbeafe;
    }
    .nav>li>a {
        position: relative;
        display: block;
        padding: 10px 15px;
        border: 1px solid #adb0b3;
        margin-right: 15px;
    }


</style>

@if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
    <div class="col-span-12">

    <x-alert-danger class="alert mb-5 hidden" id="__alertDanger" >
        <span id="__content_alertDanger">
        </span>
    </x-alert-danger>

    <x-alert-success class="alert mb-5 hidden" id="__alertSuccess">
        <span id="__content_alertSuccess"></span>
    </x-alert-success>


    <x-card.card-default>
        <x-card.body>

            @if (!empty($student->roll_no))
                <x-alert-danger class="alert mb-5">
                    This student already admitted. Please click <a href="{{route('students.edit', [ 'id' => $student->id ])}}">Here </a> to Edit
                </x-alert-danger>
            @else
                <form method="POST"  id="__formStudent" action="{{ route('admission_form.update') }}" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" id="id" name="id" value="{{$student->id}}">
                    <input type="hidden" id="timestamp" name="timestamp" value="{{$timestamp}}">
                    <ul class="nav nav-pills">
                        <li class="active">
                            <a  href="#po-info" data-toggle="tab">{{ __('translation.Student Information') }}</a>
                        </li>
                        <li>
                            <a href="#guardian-details" data-toggle="tab">{{ __("translation.Guardian Information") }}</a>
                        </li>
                        <li>
                            <a href="#payment" data-toggle="tab">{{ __('Payment') }}</a>
                        </li>
                    </ul>

                    <div class="tab-content clearfix">
                        <div class="tab-pane active" id="po-info">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Students Info') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>


                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-x-8">

                                    <div class="sm:col-span-2 lg:col-span-4 grid grid-cols-4 lg:grid-cols-4 gap-4 sm:gap-x-8">
                                        <x-input type="hidden" name="student_id" id="student_id" value="{{$student->id}}" />
                                        <x-input type="hidden" name="class_code" id="class_code" value="" />
                                        <div class="lg:col-span-3">
                                            <div class="sm:col-span-2 lg:col-span-3 grid grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8">
                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Roll No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="roll_no" id="roll_no" class="roll_no" value="{{$student->roll_no}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Full Name') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="name" id="name" value="{{$student->name}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Birth Regi No') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="birth_regi_no" id="birth_regi_no" class="birth_regi_no" value="{{$student->birth_regi_no}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Date Of Birth') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="date" name="dob" id="dob" class="datepicker-1" />
                                                </div>

                                                <div class="hidden lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Age') }}
                                                    </x-label>
                                                    <x-input type="number" name="age" id="age" value="{{$student->age}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Birthplace') }}
                                                    </x-label>
                                                    <x-input type="text" name="birthplace" id="birthplace" value="{{$student->birthplace}}" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Occupation') }}
                                                    </x-label>
                                                    <x-select name="occupation" id="occupation">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select') }} -
                                                        </option>
                                                        <option value="1" @if($student->occupation=='1') selected @endif>
                                                            - {{ __('translation.Worker') }} -
                                                        </option>
                                                        <option value="2" @if($student->occupation=='2') selected @endif>
                                                            - {{ __('translation.Muktijoddha') }} -
                                                        </option>
                                                        <option value="3" @if($student->occupation=='3') selected @endif>
                                                            - {{ __('translation.Upajati') }} -
                                                        </option>
                                                        <option value="4" @if($student->occupation=='4') selected @endif>
                                                            - {{ __('translation.Onath/Etim') }} -
                                                        </option>
                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Religion') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-select id="religion" name="religion" required style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select Relegion') }} -
                                                        </option>
                                                        <option value="Islam" @if($student->religion=='Islam') selected @endif>
                                                        - {{ __('translation.Islam') }} -
                                                        </option>
                                                        <option value="Hindu" @if($student->religion=='Hindu') selected @endif>
                                                        - {{ __('translation.Hindu') }} -
                                                        </option>
                                                        <option value="Buddist" @if($student->religion=='Buddist') selected @endif>
                                                        - {{ __('translation.Buddist') }} -
                                                        </option>
                                                        <option value="Christian" @if($student->religion=='Christian') selected @endif>
                                                        - {{ __('translation.Christian') }} -
                                                        </option>
                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Nationality') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="nationality" id="nationality" value="Bangladeshi" required />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Marital Status') }}
                                                    </x-label>
                                                    <div class="flex flex-row">
                                                        <div>
                                                            <input type="radio" name="marital_status" id="unmerried" value="0"  @if($student->marital_status=='0') checked="true" @endif>
                                                                {{ __('translation.UnMerried') }}
                                                        </div>
                                                        <div class="ml-5">
                                                            <input type="radio" name="marital_status" id="merried" value="1" @if($student->marital_status=='1') checked="true" @endif >
                                                                {{ __('translation.Merried') }}
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Blood Group') }}
                                                    </x-label>
                                                    <x-select id="blood_group" name="blood_group" style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Blood Group') }} -
                                                        </option>
                                                        <option value="A+" @if($student->blood_group=='A+') selected @endif>
                                                            {{ __('translation.A+') }}
                                                        </option>
                                                        <option value="A-" @if($student->blood_group=='A-') selected @endif>
                                                            {{ __('translation.A-') }}
                                                        </option>
                                                        <option value="B+" @if($student->blood_group=='B+') selected @endif>
                                                            {{ __('translation.B+') }}
                                                        </option>
                                                        <option value="AB+" @if($student->blood_group=='AB+') selected @endif>
                                                            {{ __('translation.AB+') }}
                                                        </option>
                                                        <option value="AB-" @if($student->blood_group=='AB-') selected @endif>
                                                            {{ __('translation.AB-') }}
                                                        </option>
                                                        <option value="O+" @if($student->blood_group=='O+') selected @endif>
                                                            {{ __('translation.O+') }}
                                                        </option>
                                                        <option value="O-" @if($student->blood_group=='O-') selected @endif>
                                                            {{ __('translation.O-') }}
                                                        </option>

                                                    </x-select>
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Gender') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-select id="gender" name="gender" style="width: 100%">
                                                        <option disabled selected value="0">
                                                            - {{ __('translation.Select Gender') }} -
                                                        </option>
                                                        <option value="male" @if($student->gender=='male') selected @endif>
                                                            {{ __('translation.Male') }}
                                                        </option>
                                                        <option value="female" @if($student->gender=='female') selected @endif>
                                                            {{ __('translation.FeMale') }}
                                                        </option>
                                                        <option value="other" @if($student->gender=='other') selected @endif>
                                                            {{ __('translation.Other') }}
                                                        </option>
                                                    </x-select>
                                                </div>

                                            </div>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <div class="mb-2 sm:text-center">
                                                <x-label for="profile_photo">
                                                    {{ __('translation.Proifle Picture') }}
                                                </x-label>
                                            </div>


                                            <label for="profile_photo" class="profile_photo__wrapper block w-full sm:w-50 sm:mx-auto mt-2 border border-dashed border-gray-400 rounded-md relative bg-white shadow-sm cursor-pointer">
                                                <input type="file" name="profile_photo" id="profile_photo" class="profile_photo__field hidden" accept="image/*">
                                                <div class="p-2">
                                                    <div class="h-44 flex items-center justify-center">
                                                        <img name="upload_photo" style="max-width: 150px;margin-top: 25px;" src="" class="profile_photo__thumbnail w-full h-auto border border-solid border-gray-300 rounded-md">
                                                    </div>
                                                </div>
                                                <div class="h-7">
                                                    <button type="button" class="profile_photo__remove_button hidden1 pt-1 pb-2 w-full border-0 outline-none focus:outline-none bg-transparent text-center text-xs text-red-500 hover:underline">
                                                        {{ __('translation.Remove') }}
                                                    </button>
                                                </div>
                                            </label>
                                        </div>

                                        <div class="lg:col-span-4">
                                            <input type="checkbox"name="is_phyically_disabled" id="is_phyically_disabled" @if($student->is_phyically_disabled =='on') checked="true"  @endif  />
                                            <label>
                                                {{ __('translation.Is Physically Challenged ?') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-4 phyically_disabled_box @if($student->is_phyically_disabled !='on') hide  @endif ">
                                            <x-label>
                                                {{ __('translation.Physically Disabled Type') }}
                                            </x-label>
                                            <x-input type="text" name="phyically_disabled_type" id="phyically_disabled_type" value="{{$student->phyically_disabled_type}}" />
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Class') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Class') . ' -' }}
                                                </option>
                                                @if (isset($classes))
                                                    @foreach($classes as $row)
                                                        <option value="{{$row->id}}" @if($student->class_id==$row->id) selected @endif >{{$row->class_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Section') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                                <option value="" selected>
                                                    {{ '- ' . __('translation.Select Section') . ' -' }}
                                                </option>
                                                @if (isset($sections))
                                                    @foreach($sections as $row)
                                                        <option value="{{$row->id}}" @if($student->section_id==$row->id) selected @endif >{{$row->section_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Session') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Session') . ' -' }}
                                                </option>
                                                @if (isset($sessions))
                                                    @foreach($sessions as $row)
                                                        <option value="{{$row->id}}" @if($student->session_id==$row->id) selected @endif >{{$row->session_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Group') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="group_id" id="__selectGroupFilter" class="group_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Group') . ' -' }}
                                                </option>
                                                @if (isset($groups))
                                                    @foreach($groups as $row)
                                                        <option value="{{$row->id}}" @if($student->group_id==$row->id) selected @endif>{{$row->group_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        @php
                                            $psc_info_hide = 'hide';
                                            $psc_passing_year = '';
                                            $psc_roll_no = '';
                                            $psc_id_no = '';
                                            $psc_gpa = '';
                                            $psc_scholarship = '';
                                            $psc_scholarship_id_no = '';

                                            $arr_psc_info = json_decode($student->psc_info,true);
                                            if(strtolower($student->class->class_name)== 'six' && $arr_psc_info){
                                                $psc_info_hide = '';
                                                $psc_passing_year = $arr_psc_info['psc_passing_year'];
                                                $psc_roll_no = $arr_psc_info['psc_roll_no'];
                                                $psc_id_no = $arr_psc_info['psc_id_no'];
                                                $psc_gpa = $arr_psc_info['psc_gpa'];
                                                $psc_scholarship = $arr_psc_info['psc_scholarship'];
                                                $psc_scholarship_id_no = $arr_psc_info['psc_scholarship_id_no'];
                                            }


                                        @endphp

                                        <div class="psc_info {{$psc_info_hide}} lg:col-span-4 flex flex-row items-center justify-between mb-3 mt-3">
                                            <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                                {{ __('translation.Primary Result info') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="lg:col-span-1 psc_info {{$psc_info_hide}} ">
                                            <x-label>
                                                {{ __("Passing Year") }}
                                            </x-label>
                                            <x-input type="text" name="psc_passing_year" id="psc_passing_year" value='{{$psc_passing_year}}' style="width: 100%" ></x-input>
                                        </div>


                                        <div class="lg:col-span-1 psc_info {{$psc_info_hide}} ">
                                            <x-label>
                                                {{ __("Primary Roll") }}
                                            </x-label>
                                            <x-input type="text" name="psc_roll_no" id="psc_roll_no" value='{{$psc_roll_no}}' style="width: 100%" ></x-input>
                                        </div>

                                        <div class="lg:col-span-1 psc_info {{$psc_info_hide}} ">
                                            <x-label>
                                                {{ __("Primary ID No.") }}
                                            </x-label>
                                            <x-input type="text" name="psc_id_no" id="psc_id_no" value='{{$psc_id_no}}' style="width: 100%" ></x-input>
                                        </div>

                                        <div class="lg:col-span-1 psc_info {{$psc_info_hide}} ">
                                            <x-label>
                                                {{ __("GPA") }}
                                            </x-label>
                                            <x-input type="text" name="psc_gpa" id="psc_gpa" value='{{$psc_gpa}}' style="width: 100%" ></x-input>
                                        </div>

                                        <div class="lg:col-span-1 psc_info {{$psc_info_hide}} ">
                                            <x-label>
                                                {{ __("Scholarship (If any)") }}
                                            </x-label>
                                            <x-select name="psc_scholarship" id="__selectPrimaryScholarship" class="psc_scholarship" style="width: 100%;">
                                                <option value=" ">
                                                    {{ '- ' . __('translation.Select') . ' -' }}
                                                </option>
                                                <option value="general" @if($psc_scholarship=='general') selected @endif>General</option>
                                                <option value="talent_poll" @if($psc_scholarship=='talent_poll') selected @endif>Talent Pool</option>
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 psc_info {{$psc_info_hide}} ">
                                            <x-label>
                                                {{ '- ' . __('translation.Scholarship ID No') . ' -' }}
                                            </x-label>
                                            <x-input type="text" name="psc_scholarship_id_no" id="psc_scholarship_id_no" value='{{$psc_scholarship_id_no}}' style="width: 100%" ></x-input>
                                        </div>


                                        @php
                                            $jsc_info_hide = 'hide';
                                            $jsc_passing_year = '';
                                            $jsc_roll_no = '';
                                            $jsc_id_no = '';
                                            $jsc_gpa = '';
                                            $jsc_scholarship = '';
                                            $jsc_scholarship_id_no = '';

                                            $arr_jsc_info = json_decode($student->jsc_info,true);
                                            if(strtolower($student->class->class_name)== 'nine' && $arr_jsc_info){
                                                $jsc_info_hide = '';
                                                $jsc_passing_year = $arr_jsc_info['jsc_passing_year'];
                                                $jsc_roll_no = $arr_jsc_info['jsc_roll_no'];
                                                $jsc_id_no = $arr_jsc_info['jsc_id_no'];
                                                $jsc_gpa = $arr_jsc_info['jsc_gpa'];
                                                $jsc_scholarship = $arr_jsc_info['jsc_scholarship'];
                                                $jsc_scholarship_id_no = $arr_jsc_info['jsc_scholarship_id_no'];
                                            }
                                        @endphp

                                        <div class="jsc_info {{$jsc_info_hide}} lg:col-span-4 flex flex-row items-center justify-between mb-3 mt-3">
                                            <h2 class="block whitespace-nowrap text-black-600 text-base font-bold">
                                                {{ __('translation.JSC Result info') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="jsc_info {{$jsc_info_hide}} lg:col-span-1">
                                            <x-label>
                                                {{ __("Passing Year") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_passing_year" id="jsc_passing_year" value="{{$jsc_passing_year}}" style="width: 100%" ></x-input>
                                        </div>


                                        <div class="jsc_info {{$jsc_info_hide}} lg:col-span-1">
                                            <x-label>
                                                {{ __("JSC Roll") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_roll_no" id="jsc_roll_no" value="{{$jsc_roll_no}}" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="jsc_info {{$jsc_info_hide}} lg:col-span-1">
                                            <x-label>
                                                {{ __("Primary ID No.") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_id_no" id="jsc_id_no" value="{{$jsc_id_no}}" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="jsc_info {{$jsc_info_hide}} lg:col-span-1">
                                            <x-label>
                                                {{ __("GPA") }}
                                            </x-label>
                                            <x-input type="text" name="jsc_gpa" id="jsc_gpa" value="{{$jsc_gpa}}" style="width: 100%" ></x-input>
                                        </div>

                                        <div class="jsc_info {{$jsc_info_hide}} lg:col-span-1">
                                            <x-label>
                                                {{ __("Scholarship (If any)") }}
                                            </x-label>
                                            <x-select name="jsc_scholarship" id="__selectJSCScholarship" class="jsc_scholarship" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select') . ' -' }}
                                                </option>
                                                <option value="general" @if($jsc_scholarship=='general') selected @endif>General</option>
                                                <option value="talent_poll" @if($jsc_scholarship=='talent_poll') selected @endif>Talent Pool</option>
                                            </x-select>
                                        </div>

                                        <div class="jsc_info {{$jsc_info_hide}} lg:col-span-1">
                                            <x-label>
                                                {{ '- ' . __('translation.Scholarship ID No') . ' -' }}
                                            </x-label>
                                            <x-input type="text" name="jsc_scholarship_id_no" id="jsc_scholarship_id_no" value="{{$jsc_scholarship_id_no}}" style="width: 100%" ></x-input>
                                        </div>


                                        <div class="lg:col-span-4">
                                            <input type="checkbox" @if($student->is_siblings_study_here=='on') checked="true"  @endif name="is_siblings_study_here" id="is_siblings_study_here" />
                                            <label>
                                                {{ __('translation.Is your Brother/sister already Admitted in this school ?') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-4 siblings_box @if($student->is_siblings_study_here !='on') hide  @endif">
                                            <x-label>
                                                {{ __('translation.Enter His/Her Student ID no') }} ( Please Use comma for multiple id as 80005,12003)
                                            </x-label>
                                            <x-input type="text" name="siblings_id_no" id="siblings_id_no" value="{{$student->siblings_id_no}}" />
                                        </div>

                                        <div class="lg:col-span-4" id="AjaxSiblingsInfoWrapper"></div>



                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                                {{ __('translation.Current Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <?php
                                        $current_address = json_decode($student->current_address,true);

                                        $current_add_village = isset($current_address['village']) ? $current_address['village'] : NULL;
                                        $current_add_post_code = isset($current_address['post_code']) ? $current_address['post_code'] : NULL;
                                        $current_add_upazila = isset($current_address['upazila']) ? $current_address['upazila'] : NULL;
                                        $current_add_district = isset($current_address['district']) ? $current_address['district'] : NULL;


                                        $same_as_current = $student->same_as_current;

                                        $permanent_address = json_decode($student->permanent_address,true);

                                        if($same_as_current=='on'){
                                            $permanent_add_village = isset($current_address['village']) ? $current_address['village'] : NULL;
                                            $permanent_add_post_code = isset($current_address['post_code']) ? $current_address['post_code'] : NULL;
                                            $permanent_add_upazila = isset($current_address['upazila']) ? $current_address['upazila'] : NULL;
                                            $permanent_add_district = isset($current_address['district']) ? $current_address['district'] : NULL;
                                        }else{
                                            $permanent_add_village = isset($permanent_address['village']) ? $permanent_address['village'] : NULL;
                                            $permanent_add_post_code = isset($permanent_address['post_code']) ? $permanent_address['post_code'] : NULL;
                                            $permanent_add_upazila = isset($permanent_address['upazila']) ? $permanent_address['upazila'] : NULL;
                                            $permanent_add_district = isset($permanent_address['district']) ? $permanent_address['district'] : NULL;
                                        }

                                        ?>
                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Village') }}
                                            </x-label>
                                            <x-input type="text" name="village" id="village" value="{{$current_add_village}}" />
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Ward No') }}
                                            </x-label>
                                            <x-input type="text" name="ward_no" id="ward_no" value="{{$student->ward_no}}" />
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Moholla') }}
                                            </x-label>
                                            <x-input type="text" name="moholla" id="moholla" value="{{$student->moholla}}" />
                                        </div>


                                        <div  class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code" id="__selectPostcodeFilter" class="post_code" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }}
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}" @if($current_add_post_code==$item['postOffice']) selected @endif>{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila" id="__selectUpazilaFilter" class="upazila" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }}
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($current_add_upazila==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.District') }}
                                            </x-label>
                                            <x-select name="district" id="__selectDistrictFilter" class="district" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($current_add_district==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-4 items-center justify-between mb-0 mt-3">
                                            <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                                {{ __('translation.Permanent Address') }}
                                            </h2>
                                            <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                        </div>

                                        <div class="lg:col-span-4">
                                            <input type="checkbox" @if($student->same_as_current=='on') checked="true"  @endif name="same_as_current" id="same_as_current" />
                                            <label>
                                                {{ __('translation.Same as Current') }}
                                            </label>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Village') }}
                                            </x-label>
                                            <x-input type="text" name="village_permanent" id="village_permanent" value="{{$permanent_add_village}}" />
                                        </div>


                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Postcode') }}
                                            </x-label>
                                            <x-select name="post_code_permanent" id="__selectPostcodeFilterPermanent" class="post_code_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Postcode') . ' -' }}
                                                </option>
                                                @if (isset($all_postcodes))
                                                    @foreach($all_postcodes as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['postOffice']}}" @if($permanent_add_post_code==$item['postOffice']) selected @endif >{{$item['postOffice']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.Upazila') }}
                                            </x-label>
                                            <x-select name="upazila_permanent" id="__selectUpazilaFilterPermanent" class="upazila_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select Upazila') . ' -' }}
                                                </option>
                                                @if (isset($all_upazilas))
                                                    @foreach($all_upazilas as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($permanent_add_upazila==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                        <div class="lg:col-span-1 permanent">
                                            <x-label>
                                                {{ __('translation.District') }}
                                            </x-label>
                                            <x-select name="district_permanent" id="__selectDistrictFilterPermanent" class="district_permanent" style="width: 100%;">
                                                <option value="" selected disabled>
                                                    {{ '- ' . __('translation.Select District') . ' -' }}
                                                </option>
                                                @if (isset($all_districts))
                                                    @foreach($all_districts as $row)
                                                        @foreach($row as $item)
                                                        <option value="{{$item['id']}}" @if($permanent_add_district==$item['id']) selected @endif>{{$item['name']}}</option>
                                                        @endforeach
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane" id="guardian-details">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Guardian Details') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8">

                                    <div>
                                        <x-label>
                                            {{ __("Family Members") }}
                                        </x-label>
                                        <x-input type="number" name="family_members" id="family_members" value="{{$student->family_members}}" style="width: 100%" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Monthly Income") }} (TK)
                                        </x-label>
                                        <x-input type="text" name="monthly_income" id="monthly_income" value="{{$student->monthly_income}}" style="width: 100%" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Total Family Land/Asset In Amount") }} (TK)
                                        </x-label>
                                        <x-input type="text" name="total_land_or_asset" id="total_land_or_asset" value="{{$student->total_land_or_asset}}" style="width: 100%" ></x-input>
                                    </div>

                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Father's Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="fathers_name" id="fathers_name" style="width: 100%" value="{{$student->fathers_name}}" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Father's NID No") }}
                                        </x-label>
                                        <x-input type="text" name="fathers_NID_no" id="fathers_NID_no" style="width: 100%" value="{{$student->fathers_NID_no}}" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Father's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="fathers_phone" id="fathers_phone" style="width: 100%" value="{{$student->fathers_phone}}"></x-input>
                                    </div>

                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Mother's Name") }} <x-form.required-mark/>
                                        </x-label>
                                        <x-input type="text" name="mothers_name" id="mothers_name" style="width: 100%" value="{{$student->mothers_name}}"></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Mothers's NID No") }}
                                        </x-label>
                                        <x-input type="text" name="mothers_NID_no" id="mothers_NID_no" style="width: 100%" value="{{$student->mothers_NID_no}}" ></x-input>
                                    </div>

                                    <div>
                                        <x-label>
                                            {{ __("Mothers's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="mothers_phone" id="mothers_phone" style="width: 100%" value="{{$student->mothers_phone}}"></x-input>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Name') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_name" id="legal_guardians_name" style="width: 100%" value="{{$student->legal_guardians_name}}"></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Phone No') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_phone" id="legal_guardians_phone" style="width: 100%" value="{{$student->legal_guardians_phone}}"></x-input>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8 mt-4">
                                    <div>
                                        <x-label>
                                            {{ __('translation.Make as a Voter') }} <x-form.required-mark/>
                                        </x-label>

                                        <x-select name="voter_type" id="voter_type" style="width: 100%" required>
                                            <option disabled selected value="0">
                                                - {{ __('translation.Select as a Voter') }} -
                                            </option>
                                            <option value="fathers_name" @if($student->voter_type=='fathers_name') selected @endif >Father</option>
                                            <option value="mothers_name" @if($student->voter_type=='mothers_name') selected @endif >Mother</option>
                                            <option value="legal_guardians_name" @if($student->voter_type=='legal_guardians_name') selected @endif>Local Guardian</option>
                                        </x-select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="payment">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Payment') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

                                    <div id='AjaxFeePaymentWrapper'></div>

                            </div>
                        </div>
                    </div>


                    <div class="text-center pb-5">
                        <x-button type="submit" color="blue" id="__btnSubmitStudent">
                            {{ __('translation.Submit Data') }}
                        </x-button>
                    </div>

                </form>
            @endif

        </x-card.body>
    </x-card.card-default>
</div>
@endif



@push('bottom_js')
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
    <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
    <script src="{{ asset('pages/admin/student/form_update.js?_=' . rand()) }}"></script>
@endpush

<script type="text/javascript">
    $(".permanent").addClass('hide');
        $("#same_as_current").on("click", function(){
            check = $("#same_as_current").is(":checked");
            if(check) {
                $(".permanent").addClass('hide');
            } else {
                $(".permanent").removeClass('hide');
            }
        });

        $("#is_phyically_disabled").on("click", function(){
                check = $("#is_phyically_disabled").is(":checked");
                if(check) {
                    $(".phyically_disabled_box").removeClass('hide');
                } else {
                    $(".phyically_disabled_box").addClass('hide');
                }
            });


            $("#is_siblings_study_here").on("click", function(){
                check = $("#is_siblings_study_here").is(":checked");
                if(check) {
                    $(".siblings_box").removeClass('hide');
                    $("#AjaxSiblingsInfoWrapper").removeClass('hide');

                } else {
                    $(".siblings_box").addClass('hide');
                    $("#AjaxSiblingsInfoWrapper").addClass('hide');
                }
            });


            jQuery(document).on('change','#__selectClassFilter', { passive: true } ,function( e ) {
               let class_name = $("#__selectClassFilter  option:selected").text().toLowerCase();
            // Show JSC OR PSC Area
               fn_jsc_psc_wrapper_view(class_name);

                localStorage.setItem('fee_taken_class', $(this).val());
            });

            function fn_jsc_psc_wrapper_view(class_name){
                if(class_name =='six'){
                    $(".psc_info").removeClass('hide');
                    $(".jsc_info").addClass('hide');
                }else if(class_name=='nine'){
                    $(".jsc_info").removeClass('hide');
                    $(".psc_info").addClass('hide');
                }else{
                    $(".jsc_info").addClass('hide');
                    $(".psc_info").addClass('hide');
                }
            }



            $("#same_as_current").on("click", function(){
                check = $("#same_as_current").is(":checked");
                if(check) {
                    $(".permanent").addClass('hide');
                } else {
                    $(".permanent").removeClass('hide');
                }
            });


            fn_get_siblings_info();
            $("#siblings_id_no").on("keyup", function(){
                fn_get_siblings_info();
            });

            function fn_get_siblings_info(){
                let siblings_id_no = $("#siblings_id_no").val();
                if(siblings_id_no){
                    jQuery.ajax({
                            type : 'POST',
                            url: '{{ route('get_siblings_info') }}',
                            data : {siblings_id_no:siblings_id_no},
                            beforeSend: function() {
                                $('#AjaxSiblingsInfoWrapper').html('processing...');
                                }
                            }).done(function(data) {
                                jQuery("#AjaxSiblingsInfoWrapper").html(data);

                            });
                }

            }


            $('#__formStudent').submit(function(event) {
                event.preventDefault();
                let formData = new FormData($(this)[0]);
                $.ajax({
                    type: $(this).attr('method'),
                    url: $(this).attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('#__btnSubmitStudent').attr('disabled', true).html('{{ __('translation.Processing') }}');
                        $('.alert').addClass('hidden');
                    },
                    success: function(responseJson) {
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        console.log(responseJson);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        $('.alert').addClass('hidden');
                        $('#__alertSuccess').removeClass('hidden');
                        $('#__content_alertSuccess').html(null);
                        $('#__content_alertSuccess').html(responseJson.message);

                        if(responseJson.receipt_id){
                            //console.log(responseJson.receipt_id);
                            fn_show_receipt(responseJson.receipt_id,responseJson.student_id);
                        }else{
                            var url = '{{ route('students.create') }}';
                        }
                        setTimeout(() => {
                           // window.location.href = '{{ route('admission_form.index') }}';
                        }, 1500);
                    },
                    error: function(response) {
                        let responseJson = response.responseJSON;
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        $('.alert').addClass('hidden');
                        $('#__alertDanger').removeClass('hidden');
                        $('#__content_alertDanger').html(null);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        if (response.status == 422) {
                            let errorFields = Object.keys(responseJson.errors);
                            errorFields.map(field => {
                                $('#__content_alertDanger').append(
                                    $('<div/>', {
                                        html: responseJson.errors[field][0],
                                        class: 'mb-2'
                                    })
                                );
                            });
                        }
                        else {
                            $('#__content_alertDanger').html(responseJson.message);
                        }
                    }
                });
                return false;
            });


            jQuery("#closeModalReceipt").on("click", function(){
                $('.modal-receipt').addClass('modal-hide');
            });

            function fn_show_receipt(receipt_id,student_id){
                $('.modal-receipt').removeClass('modal-hide');
                $.ajax({
                        url: '{{ route('get_money_receipt_admission') }}',
                        type: 'post',
                        data: {
                            'receipt_id': receipt_id,
                            'student_id': student_id
                        },
                        beforeSend: function() {
                            $('.data-wrapper').html("Processing....");
                        }
                    }).done(function(result) {
                        console.log(result);
                        $('.data-wrapper').html(result);
                        if (result === 'success') {
                        // fn_print_receipt();
                        } else {

                        }
                    });

                }
</script>


