<x-app-layout>
    @section('title', 'Students')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.css">
    @endpush

    <style type="text/css">
        .nav>li a.active{
            background: #dbeafe;
        }
        .nav>li>a {
            position: relative;
            display: block;
            padding: 10px 15px;
            border: 1px solid #adb0b3;
            margin-right: 15px;
        }
    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
        <div class="col-span-12">

        @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

        <x-card.card-default>
            <x-card.header>
                <x-card.back-button href="{{ route('admission_form.index') }}" />
                <x-card.title>
                    {{ __('translation.New Admission Form') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>

                <x-alert-danger class="alert mb-5 hidden" id="__alertDanger">
                    <span id="__content_alertDanger"></span>
                </x-alert-danger>

                <x-alert-success class="alert mb-5 hidden" id="__alertSuccess">
                    <span id="__content_alertSuccess"></span>
                </x-alert-success>

                <form method="POST" action="{{ route('admission_form.store') }}" id="__formStudent" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" id="timestamp" name="timestamp" value="{{$timestamp}}">
                    <ul class="nav nav-pills">
                        <li class="active">
                            <a  href="#po-info" data-toggle="tab">{{ __('translation.Student Information') }}</a>
                        </li>
                        <li>
                            <a href="#guardian-details" data-toggle="tab">{{ __("translation.Guardian Information") }}</a>
                        </li>
                    </ul>

                    <div class="tab-content clearfix">
                        <div class="tab-pane active" id="po-info">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Students Info') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>


                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-x-8">

                                    <div class="sm:col-span-2 lg:col-span-4 grid grid-cols-4 lg:grid-cols-4 gap-4 sm:gap-x-8">
                                        <input type="hidden" id="entry_date" name="entry_date" class="form-control1" value="<?php echo date('Y-m-d');?>">
                                        <x-input type="hidden" name="class_code" id="class_code" value="" />
                                        <div class="sm:col-span-2 lg:col-span-4 grid grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8">
                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Class') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Class') . ' -' }}
                                                </option>
                                                @if (isset($classes))
                                                    @foreach($classes as $row)
                                                        <option data-class_code="{{$row->class_code}}" value="{{$row->id}}">{{$row->class_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>



                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Session') }} <x-form.required-mark/>
                                            </x-label>
                                            <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Session') . ' -' }}
                                                </option>
                                                @if (isset($sessions))
                                                    @foreach($sessions as $row)
                                                        <option value="{{$row->id}}">{{$row->session_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>


                                        <div class="lg:col-span-1">
                                            <x-label>
                                                {{ __('translation.Group') }}
                                            </x-label>
                                            <x-select name="group_id" id="__selectGroupFilter" class="group_id" style="width: 100%;">
                                                <option value=" " selected>
                                                    {{ '- ' . __('translation.Select Group') . ' -' }}
                                                </option>
                                                @if (isset($groups))
                                                    @foreach($groups as $row)
                                                        <option value="{{$row->id}}">{{$row->group_name}}</option>
                                                    @endforeach
                                                @endif
                                            </x-select>
                                        </div>
                                    </div>


                                        <div class="lg:col-span-4">
                                            <div class="sm:col-span-2 lg:col-span-3 grid grid-cols-3 lg:grid-cols-3 gap-4 sm:gap-x-8">
                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Full Name') }} <x-form.required-mark/>
                                                    </x-label>
                                                    <x-input type="text" name="name" id="name" />
                                                </div>

                                                <div class="lg:col-span-1">
                                                    <x-label>
                                                        {{ __('translation.Form Fee') }} (৳)
                                                    </x-label>
                                                    <x-input type="text" name="form_fee" id="__form_fee" class="" />
                                                </div>


                                            </div>
                                        </div>





                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane" id="guardian-details">
                            <div class="mb-10">
                                <div class="flex flex-row items-center justify-between mb-3 mt-3">
                                    <h2 class="block whitespace-nowrap text-gray-600 text-base font-bold">
                                        {{ __('translation.Guardian Details') }}
                                    </h2>
                                    <hr class="w-full ml-3 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8">

                                    <div>
                                        <x-label>
                                            {{ __("Father's Name") }}
                                        </x-label>
                                        <x-input type="text" name="fathers_name" id="fathers_name" style="width: 100%" ></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __("Father's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="fathers_phone" id="fathers_phone" style="width: 100%"></x-input>
                                    </div>

                                </div>

								<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __("Mother's Name") }}
                                        </x-label>
                                        <x-input type="text" name="mothers_name" id="mothers_name" style="width: 100%"></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __("Mother's Phone No") }}
                                        </x-label>
                                        <x-input type="text" name="mothers_phone" id="mothers_phone" style="width: 100%"></x-input>
                                    </div>
                                </div>

								<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-x-8 mt-4">

                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Name') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_name" id="legal_guardians_name" style="width: 100%"></x-input>
                                    </div>


                                    <div>
                                        <x-label>
                                            {{ __('translation.Local Guardian Phone No') }}
                                        </x-label>
                                        <x-input type="text" name="legal_guardians_phone" id="legal_guardians_phone" style="width: 100%"></x-input>
                                    </div>
                                </div>

                                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 sm:gap-x-8 mt-4">
                                    <div>
                                        <x-label>
                                            {{ __('translation.Make as a Voter') }}
                                        </x-label>

                                        <x-select name="voter_type" id="voter_type" style="width: 100%" required>
                                            <option disabled selected value="0">
                                                - {{ __('translation.Select as a Voter') }} -
                                            </option>
                                            <option value="fathers_name" >Father</option>
                                            <option value="mothers_name" >Mother</option>
                                            <option value="legal_guardians_name">Local Guardian</option>
                                        </x-select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="text-center pb-5">
                        <x-button type="submit" color="blue" id="__btnSubmitStudent">
                            {{ __('translation.Submit Data') }}
                        </x-button>
                    </div>

                </form>

            </x-card.body>
        </x-card.card-default>
    </div>
    @endif

{{-- update Status --}}
<x-modal.modal-full class="modal-hide modal-receipt">
    <x-modal.header>
        <x-modal.title>
            {{ __('translation.Money Receipt') }}
        </x-modal.title>
        <x-modal.close-button id="closeModalReceipt" />
    </x-modal.header>
    <x-modal.body>
        <div class="pb-6 data-wrapper">

        </div>
    </x-modal.body>
</x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
        <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.js"></script>
        <script src="{{ asset('pages/admin/student/form_update.js?_=' . rand()) }}"></script>
        <script>

			$('#__selectDivisionFilter').select2({
                width: 'resolve'
            });

            $('#__selectDistrictFilter').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilter').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilter').select2({
                width: 'resolve'
            });

            //Permanent
            $('#__selectDistrictFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectPostcodeFilterPermanent').select2({
                width: 'resolve'
            });

            $('#__selectUpazilaFilterPermanent').select2({
                width: 'resolve'
            });




			$(".datepicker-1").datepicker({
                dateFormat: 'yy-mm-dd',
				 changeMonth: true,
				 changeYear: true,
				 yearRange: "-20:+0",
            });


            $(".permanent").addClass('hide');
            $("#same_as_current").on("click", function(){
            check = $("#same_as_current").is(":checked");
            if(check) {
                $(".permanent").addClass('hide');
            } else {
                $(".permanent").removeClass('hide');
            }
        });


            $('#__formStudent').submit(function(event) {
                event.preventDefault();
                let formData = new FormData($(this)[0]);
                $.ajax({
                    type: $(this).attr('method'),
                    url: $(this).attr('action'),
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('#__btnSubmitStudent').attr('disabled', true).html('{{ __('translation.Processing') }}');
                        $('.alert').addClass('hidden');
                    },
                    success: function(responseJson) {
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        console.log(responseJson);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        $('.alert').addClass('hidden');
                        $('#__alertSuccess').removeClass('hidden');
                        $('#__content_alertSuccess').html(null);
                        $('#__content_alertSuccess').html(responseJson.message);
                        if(responseJson.receipt_id){
                            //console.log(responseJson.receipt_id);
                            fn_show_receipt(responseJson.receipt_id,responseJson.student_id);
                        }else{
                            var url = '{{ route('students.create') }}';
                        }
                        setTimeout(() => {
                           // window.location.href = '{{ route('admission_form.index') }}';
                        }, 1500);
                    },
                    error: function(response) {
                        let responseJson = response.responseJSON;
                        $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
                        $('.alert').addClass('hidden');
                        $('#__alertDanger').removeClass('hidden');
                        $('#__content_alertDanger').html(null);
                        $('html, body').animate({
                            scrollTop: 0
                        }, 500);
                        if (response.status == 422) {
                            let errorFields = Object.keys(responseJson.errors);
                            errorFields.map(field => {
                                $('#__content_alertDanger').append(
                                    $('<div/>', {
                                        html: responseJson.errors[field][0],
                                        class: 'mb-2'
                                    })
                                );
                            });
                        }
                        else {
                            $('#__content_alertDanger').html(responseJson.message);
                        }
                    }
                });
                return false;
            });


            jQuery("#closeModalReceipt").on("click", function(){
                $('.modal-receipt').addClass('modal-hide');
                location.reload();
            });

            function fn_show_receipt(receipt_id,student_id){
                $('.modal-receipt').removeClass('modal-hide');
                $.ajax({
                        url: '{{ route('get_money_receipt_admission') }}',
                        type: 'post',
                        data: {
                            'receipt_id': receipt_id,
                            'student_id': student_id
                        },
                        beforeSend: function() {
                            $('.data-wrapper').html("Processing....");
                        }
                    }).done(function(result) {
                       // console.log(result);
                        $('.data-wrapper').html(result);
                        if (result === 'success') {
                        // fn_print_receipt();
                        } else {

                        }
                    });

                }

        </script>


        <script>
            var form_fee = localStorage.getItem('form_fee');
            if(form_fee){
                $("#__form_fee").val(form_fee);
            }
            jQuery(document).on('change','#__selectSessionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_session', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectClassFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_class', $(this).val());
                var class_code = $("#__selectClassFilter  option:selected").data('class_code');
                $("#class_code").val(class_code);
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectSectionFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_section', $(this).val());
                filterOthersFee();
            });

            jQuery(document).on('change','#__selectGroupFilter', { passive: true } ,function( e ) {
                localStorage.setItem('fee_taken_group', $(this).val());
                filterOthersFee();
            });

            if(localStorage.getItem('fee_taken_session')){
                var session_id = localStorage.getItem('fee_taken_session');
                $("#__selectSessionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_class')){
                var session_class = localStorage.getItem('fee_taken_class');
                $("#__selectClassFilter option[value='"+session_class+"']").prop('selected', true);
            }


            if(localStorage.getItem('fee_taken_section')){
                var session_section = localStorage.getItem('fee_taken_section');
                $("#__selectSectionFilter option[value='"+session_section+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_group')){
                var session_group = localStorage.getItem('fee_taken_group');
                $("#__selectGroupFilter option[value='"+session_group+"']").prop('selected', true);
            }



            jQuery(document).on('keyup','#__form_fee', { passive: true } ,function( e ) {
                localStorage.setItem('form_fee', $(this).val());
            });


            jQuery(document).on('click','#__btnResetLocalStorage', { passive: true } ,function( e ) {
                localStorage.removeItem('fee_taken_session');
                localStorage.removeItem('fee_taken_class');
                localStorage.removeItem('fee_taken_section');
                localStorage.removeItem('fee_taken_group');

                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectGroupFilter').val('').trigger('change');

            });



        </script>


    @endpush

</x-app-layout>
