<x-app-layout>
    @section('title', 'Students')

    @push('top_css')
        <link type="text/css" href="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/css/dataTables.checkboxes.css" rel="stylesheet" />
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.css">
    @endpush

    <style type="text/css">
        .nav>li a.active{
            background: #dbeafe;
        }
        .nav>li>a {
            position: relative;
            display: block;
            padding: 10px 15px;
            border: 1px solid #adb0b3;
            margin-right: 15px;
        }
    </style>

    @if(\App\Models\Role::checkRolePermissions('Can access menu: Students - Students'))
        <div class="col-span-12">

        @if (session('success'))
                <x-alert-success>
                    {{ session('success') }}
                </x-alert-success>
            @endif

            @if (session('danger'))
                <x-alert-danger>
                    {{ session('danger') }}
                </x-alert-danger>
            @endif

            @if (session('error'))
                <x-alert-danger>
                    {{ session('error') }}
                </x-alert-danger>
            @endif

            @if ($errors->any())
                <x-alert-danger>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </x-alert-danger>
            @endif

        <x-card.card-default>
            <x-card.header>
                <x-card.back-button href="{{ route('admission_form.index') }}" />
                <x-card.title>
                    {{ __('translation.Admission Confirmation') }}
                </x-card.title>
                <div class="lg:col-span-4">
                    <hr class="w-full ml-0 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                </div>
            </x-card.header>
            <x-card.body>
                <div class="mb-10">
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-1 gap-4 sm:gap-x-8">
                        <div class="flex flex-row items-center gap-4">
                            <h2 class="mt-3 block whitespace-nowrap text-gray-600 text-base font-bold">
                                {{ __('translation.Enter Student Code') }} <x-form.required-mark/>
                            </h2>
                            <div class="">
                                <x-input type="text" name="student_code" id="__student_code" />
                            </div>
                        </div>

                        <div class="lg:col-span-4">
                            <hr class="w-full ml-0 relative -top-1 border border-r-0 border-b-0 border-l-0 border-gray-300">
                        </div>
                    </div>
                    <div class="data-student-details"></div>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>
    @endif

{{-- Money Receipt --}}
<x-modal.modal-full class="modal-hide modal-receipt">
    <x-modal.header>
        <x-modal.title>
            {{ __('translation.Money Receipt') }}
        </x-modal.title>
        <x-modal.close-button id="closeModalReceipt" />
    </x-modal.header>
    <x-modal.body>
        <div class="pb-6 data-wrapper">

        </div>
    </x-modal.body>
</x-modal.modal-full>

    @push('bottom_js')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/typeahead.js@0.11.1/dist/typeahead.bundle.min.js"></script>
        <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/jquery-datatables-checkboxes@1.2.12/js/dataTables.checkboxes.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/dropzone@5.9.2/dist/min/dropzone.min.js"></script>
        <script src="{{ asset('pages/admin/student/form_update.js?_=' . rand()) }}"></script>
        <script>

            jQuery(document).on('keyup','#__student_code', { passive: true } ,function( e ) {
                var student_code = $(this).val();
                $.ajax({
                        url: '{{ route('get_student_details_by_code') }}',
                        type: 'post',
                        data: {
                            'student_code': student_code,
                        },
                        beforeSend: function() {
                            $('.data-student-details').html("Processing....");
                        }
                    }).done(function(result) {
                        filterOthersFee();

                        $('.data-student-details').html(result);
                        $('.select2').select2();
                    });
            });






			$(".datepicker-1").datepicker({
                dateFormat: 'yy-mm-dd',
				 changeMonth: true,
				 changeYear: true,
				 yearRange: "-20:+0",
            });


            jQuery("#closeModalReceipt").on("click", function(){
                $('.modal-receipt').addClass('modal-hide');
            });

            function fn_show_receipt(receipt_id,student_id){
                $('.modal-receipt').removeClass('modal-hide');
                $.ajax({
                        url: '{{ route('get_money_receipt_admission') }}',
                        type: 'post',
                        data: {
                            'receipt_id': receipt_id,
                            'student_id': student_id
                        },
                        beforeSend: function() {
                            $('.data-wrapper').html("Processing....");
                        }
                    }).done(function(result) {
                        console.log(result);
                        $('.data-wrapper').html(result);
                        if (result === 'success') {
                        // fn_print_receipt();
                        } else {

                        }
                    });

            }

            var form_fee = localStorage.getItem('form_fee');
            if(form_fee){
                $("#__form_fee").val(form_fee);
            }


            if(localStorage.getItem('fee_taken_session')){
                var session_id = localStorage.getItem('fee_taken_session');
                $("#__selectSessionFilter option[value='"+session_id+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_class')){
                var session_class = localStorage.getItem('fee_taken_class');
                $("#__selectClassFilter option[value='"+session_class+"']").prop('selected', true);
            }


            if(localStorage.getItem('fee_taken_section')){
                var session_section = localStorage.getItem('fee_taken_section');
                $("#__selectSectionFilter option[value='"+session_section+"']").prop('selected', true);
            }

            if(localStorage.getItem('fee_taken_group')){
                var session_group = localStorage.getItem('fee_taken_group');
                $("#__selectGroupFilter option[value='"+session_group+"']").prop('selected', true);
            }



            jQuery(document).on('keyup','#__form_fee', { passive: true } ,function( e ) {
                localStorage.setItem('form_fee', $(this).val());
            });


            jQuery(document).on('click','#__btnResetLocalStorage', { passive: true } ,function( e ) {
                localStorage.removeItem('fee_taken_session');
                localStorage.removeItem('fee_taken_class');
                localStorage.removeItem('fee_taken_section');
                localStorage.removeItem('fee_taken_group');

                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectGroupFilter').val('').trigger('change');

            });





    $('#__selectDivisionFilter').select2({
        width: 'resolve'
    });

    $('#__selectDistrictFilter').select2({
        width: 'resolve'
    });

    $('#__selectPostcodeFilter').select2({
        width: 'resolve'
    });

    $('#__selectUpazilaFilter').select2({
        width: 'resolve'
    });

    //Permanent
    $('#__selectDistrictFilterPermanent').select2({
        width: 'resolve'
    });

    $('#__selectPostcodeFilterPermanent').select2({
        width: 'resolve'
    });

    $('#__selectUpazilaFilterPermanent').select2({
        width: 'resolve'
    });




    $(".datepicker-1").datepicker({
        dateFormat: 'yy-mm-dd',
         changeMonth: true,
         changeYear: true,
         yearRange: "-20:+0",
    });




    jQuery(document).on('change','#__selectSessionFilter', { passive: true } ,function( e ) {
        localStorage.setItem('fee_taken_session', $(this).val());
        filterOthersFee();
    });

    jQuery(document).on('change','#__selectClassFilter', { passive: true } ,function( e ) {
        localStorage.setItem('fee_taken_class', $(this).val());
        var class_code = $("#__selectClassFilter  option:selected").data('class_code');
        $("#class_code").val(class_code);
        filterOthersFee();
    });

    jQuery(document).on('change','#__selectSectionFilter', { passive: true } ,function( e ) {
        localStorage.setItem('fee_taken_section', $(this).val());
        filterOthersFee();
    });

    jQuery(document).on('change','#__selectGroupFilter', { passive: true } ,function( e ) {
        localStorage.setItem('fee_taken_group', $(this).val());
        filterOthersFee();
    });

    if(localStorage.getItem('fee_taken_session')){
        var session_id = localStorage.getItem('fee_taken_session');
        $("#__selectSessionFilter option[value='"+session_id+"']").prop('selected', true);
    }

    if(localStorage.getItem('fee_taken_class')){
        var session_id = localStorage.getItem('fee_taken_class');
        $("#__selectClassFilter option[value='"+session_id+"']").prop('selected', true);
    }


    if(localStorage.getItem('fee_taken_section')){
        var session_id = localStorage.getItem('fee_taken_section');
        $("#__selectSectionFilter option[value='"+session_id+"']").prop('selected', true);
    }

    if(localStorage.getItem('fee_taken_group')){
        var session_id = localStorage.getItem('fee_taken_group');
        $("#__selectGroupFilter option[value='"+session_id+"']").prop('selected', true);
    }



    jQuery(document).on('click','#__btnResetLocalStorage', { passive: true } ,function( e ) {
        localStorage.removeItem('fee_taken_session');
        localStorage.removeItem('fee_taken_class');
        localStorage.removeItem('fee_taken_section');
        localStorage.removeItem('fee_taken_group');

        $('#__selectSessionFilter').val('').trigger('change');
        $('#__selectClassFilter').val('').trigger('change');
        $('#__selectSectionFilter').val('').trigger('change');
        $('#__selectGroupFilter').val('').trigger('change');

    });


    $('#__selectClassFilter').on('change',function() {
        filterOthersFee();
    });


    function filterOthersFee(){

        var session_id = jQuery( "#__selectSessionFilter" ).val();

        var class_id = jQuery( "#__selectClassFilter" ).val();
        var section_id = jQuery( "#__selectSectionFilter" ).val();
        var group_id = jQuery( "#__selectGroupFilter" ).val();
        var roll_no = $('#roll_no').val();
        jQuery("#AjaxFeePaymentWrapper").html('');
        if(class_id && session_id){
            fn_other_fee_existance(class_id,session_id);
            jQuery('#others_fee').hide();
            jQuery.ajax({
                        type : 'POST',
                        url: '{{ route('admission_filter_others_fee') }}',
                        data : {class_id:class_id,session_id:session_id,section_id:section_id,group_id:group_id,roll_no:roll_no},
                        beforeSend: function() {
                                $('#AjaxFeePaymentWrapper').html('processing...');
                            }
                        }).done(function(data) {
                            jQuery("#AjaxFeePaymentWrapper").html(data);

                        });

        }
    }

    function fn_other_fee_existance(class_id,session_id){
        jQuery.ajax({
                    type : 'POST',
                    url: '{{ route('admission_filter_others_fee_existance_checking') }}',
                    data : {class_id:class_id,session_id:session_id},
                    beforeSend: function() {


                    }
                    }).done(function(data) {
                        if(data){
                                alert(data);
                            }

                    });
    }

    function clearMonthlyFee(){
        var elements = document.getElementById("monthlyFee").options;

        for(var i = 0; i < elements.length; i++){
          elements[i].selected = false;
        }
        $("#monthly_fee_total").val('0');
        var TotalPayableFee = 0 + parseFloat($( "#other_amount_total" ).val());
        $( "#amount" ).val(TotalPayableFee);
        //$( "#paid" ).val(TotalPayableFee);
        $( "#lebelAmount" ).html(TotalPayableFee);
    }

    function clearOthersFee(){
        var elements = document.getElementById("othersFee").options;

        for(var i = 0; i < elements.length; i++){
          elements[i].selected = false;
        }
        $("#other_amount_total").val('0');
        var TotalPayableFee = parseFloat($( "#monthly_fee_total" ).val());
        $( "#amount" ).val(TotalPayableFee);
        //$( "#paid" ).val(TotalPayableFee);
        $( "#lebelAmount" ).html(TotalPayableFee);
    }

        jQuery(document).on('change','#monthlyFee', { passive: true } ,function( e ) {
            var MonthlyFeeTotalAmount = 0;
            var fieldName = [];
        $( "#monthlyFee option:selected" ).each(function() {
            MonthlyFeeTotalAmount += parseFloat($( this ).data('fee')) || 0;
            fieldName.push($( this ).val());

        });

        $( "#monthly_fee_total" ).val(MonthlyFeeTotalAmount);
        $( "#monthly_fee_fields" ).val(fieldName.join(","));

        var TotalPayableFee = MonthlyFeeTotalAmount + parseFloat($( "#other_amount_total" ).val());
        $( "#amount" ).val(TotalPayableFee);
        //$( "#paid" ).val(TotalPayableFee);
        $( "#lebelAmount" ).html(TotalPayableFee);

        });


        jQuery(document).on('change','#othersFee', { passive: true } ,function( e ) {
            var othersFee = 0;
            var fieldName = [];
            var fieldValue = [];
        $( "#othersFee option:selected" ).each(function() {
            othersFee += parseFloat($( this ).data('fee')) || 0;
            fieldName.push($( this ).val());
            fieldValue.push($( this ).data('fee'));

        });

        $( "#other_amount_total" ).val(othersFee);
        $( "#others_fee_fields" ).val(fieldName.join("@"));
        $( "#others_fee_details" ).val(fieldValue.join("@"));


        var TotalPayableFee = othersFee + parseFloat($( "#monthly_fee_total" ).val());
        $( "#amount" ).val(TotalPayableFee);
        //$( "#paid" ).val(TotalPayableFee);
        $( "#lebelAmount" ).html(TotalPayableFee);

        });


jQuery(document).on('submit','#__formStudent', { passive: true } ,function( e ) {
event.preventDefault();
let student_id = $("#student_id").val();
let formData = new FormData($(this)[0]);
$.ajax({
  type: 'post',
  url: '{{ url('admission_update_student') }}/'+student_id,
  data: formData,
  processData: false,
  contentType: false,
  beforeSend: function() {
      $('#__btnSubmitStudent').attr('disabled', true).html('{{ __('translation.Processing') }}');
      $('.alert').addClass('hidden');
  },
  success: function(responseJson) {
      $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
      console.log(responseJson);
      $('html, body').animate({
          scrollTop: 0
      }, 500);
      $('.alert').addClass('hidden');
      $('#__alertSuccess').removeClass('hidden');
      $('#__content_alertSuccess').html(null);
      $('#__content_alertSuccess').html(responseJson.message);
      setTimeout(() => {
          window.location.href = '{{ route('admission_form.confirm') }}';
      }, 1500);
  },
  error: function(response) {
      let responseJson = response.responseJSON;
      $('#__btnSubmitStudent').attr('disabled', false).html('{{ __('translation.Submit Data') }}');
      $('.alert').addClass('hidden');
      $('#__alertDanger').removeClass('hidden');
      $('#__content_alertDanger').html(null);
      $('html, body').animate({
          scrollTop: 0
      }, 500);
      if (response.status == 422) {
          let errorFields = Object.keys(responseJson.errors);
          errorFields.map(field => {
              $('#__content_alertDanger').append(
                  $('<div/>', {
                      html: responseJson.errors[field][0],
                      class: 'mb-2'
                  })
              );
          });
      }
      else {
          $('#__content_alertDanger').html(responseJson.message);
      }
  }
});
return false;
});
</script>
    @endpush

</x-app-layout>
