<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPrintStatusAndPrintDateTimeToShipments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('shipments', function (Blueprint $table) {
            $table->integer('print_status')->default(0);
            $table->dateTime('print_date_time')->nullable();
            $table->integer('print_by')->nullable();
            $table->dateTime('pack_date_time')->nullable();
            $table->integer('pack_by')->nullable();
            $table->integer('seller_id')->nullable(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('shipments', function (Blueprint $table) {
            $table->dropColumn('print_status');
            $table->dropColumn('print_date_time'); 
            $table->dropColumn('print_by'); 
            $table->dropColumn('pack_date_time'); 
            $table->dropColumn('pack_by'); 
            $table->dropColumn('seller_id'); 
        });
    }
}