<?php

namespace App\Utilities;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;

class QueueJobStatusUtil
{
    private $className;

    public function __construct($className)
    {
        $this->className = $className;
    }

    public function parseClassName()
    {
        $explodedClassName = explode('\\', $this->className);
        return Str::slug(end($explodedClassName), '_');
    }

    public function setProcessing(bool $isProcessing)
    {
        $twentyFourHourInSeconds = 86000;

        Cache::put($this->parseClassName() . '_job_status', $isProcessing, $twentyFourHourInSeconds);
    }
}