<?php

namespace App\Observers;

use App\Models\{ActivityLog, StockLog, ProductMainStock};
use Log;

class StockLogObserver
{
    /**
     * Handle the StockLog "created" event.
     *
     * @param  \App\Models\StockLog  $stockLog
     * @return void
     */
    public function created(StockLog $stockLog)
    {
        if ($stockLog->is_defect == 0) {
            if ($stockLog->check_in_out == StockLog::CHECK_IN_OUT_ADD) {
                ActivityLog::updateStockActivityLog('Add product ', $stockLog->id, $stockLog->quantity);
            }

            if ($stockLog->check_in_out == StockLog::CHECK_IN_OUT_REMOVE) {
                ActivityLog::updateStockActivityLog('Remove product ', $stockLog->id, $stockLog->quantity);
            }


        }
    }

    /**
     * Handle the StockLog "updated" event.
     *
     * @param  \App\Models\StockLog  $stockLog
     * @return void
     */
    public function updated(StockLog $stockLog)
    {
        $originalStockLogQty = $stockLog->getOriginal('quantity');
        $incomingStockLogQty = $stockLog->quantity;
        $LogQtyDiff = $incomingStockLogQty - $originalStockLogQty;
        if ($stockLog->is_defect == 0) {
            if ($stockLog->check_in_out == StockLog::CHECK_IN_OUT_ADD) {
                ActivityLog::updateStockActivityLog('Update added product', $stockLog->id, $LogQtyDiff);
            }

            if ($stockLog->check_in_out == StockLog::CHECK_IN_OUT_REMOVE) {
                ActivityLog::updateStockActivityLog('Update removed product ', $stockLog->id, $LogQtyDiff);
            }

           // $productMainStock->save();
        }
    }

    /**
     * Handle the StockLog "deleted" event.
     *
     * @param  \App\Models\StockLog  $stockLog
     * @return void
     */
    public function deleted(StockLog $stockLog)
    {
        

        if ($stockLog->is_defect == 0) {
            ActivityLog::updateStockActivityLog('Delete stock log', $stockLog->id, $stockLog->quantity, $stockLog->product_id);
        }
    }

    /**
     * Handle the StockLog "restored" event.
     *
     * @param  \App\Models\StockLog  $stockLog
     * @return void
     */
    public function restored(StockLog $stockLog)
    {
        $productMainStock = ProductMainStock::where('product_id', $stockLog->product_id)->first();
        $currentQty = $productMainStock->quantity;

        if ($stockLog->check_in_out == StockLog::CHECK_IN_OUT_ADD) {
            $productMainStock->quantity = $currentQty + $stockLog->quantity;
        }

        if ($stockLog->check_in_out == StockLog::CHECK_IN_OUT_REMOVE) {
            $productMainStock->quantity = $currentQty - $stockLog->quantity;
        }

        $productMainStock->save();
    }

    /**
     * Handle the StockLog "force deleted" event.
     *
     * @param  \App\Models\StockLog  $stockLog
     * @return void
     */
    public function forceDeleted(StockLog $stockLog)
    {
        //
    }
}
