<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WooShop extends Model
{
    use HasFactory;

    public function shops(){
        return $this->belongsTo(Shop::class, 'shop_id', 'id')->withDefault(['name' => '']);
    }

    public static function is_valid($shop_url)
    {
        $shop = '';
        if(isset(parse_url($shop_url)['host'])):
            $shop = self::where('site_url', 'like' ,'%'.parse_url($shop_url)['host'].'%')->first();
        endif;
        return $shop !== null ? $shop : false;
    }

    public static function get_supplier_id($person_id)
    {
        $person = Supplier::where('person_id', $person_id)->first();
        return $person !== null ? $person->person_id : null;
    }
}
