<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class StudentFee extends Model
{
    use HasFactory;

    protected $table = 'students_fee';

    /**
     * Get data from json file
     *
     * @return array
     */

    public static function MonthArray(){
    $monthListArr = array(
        '1'=> 'January',
        '2'=> 'February',
        '3'=> 'March',
        '4'=> 'April',
        '5'=> 'May',
        '6'=> 'June',
        '7'=> 'July',
        '8'=> 'August',
        '9'=> 'September',
        '10'=> 'October',
        '11'=> 'November',
        '12'=> 'December'
    );

    return $monthListArr;
    }


    /**
     * Relationship to `students` table
     *
     * @return mixed
     */
    public function student_details()
    {
        return $this->hasOne(Student::class, 'id', 'student_id');
    }

    /**
     * Relationship to `current_academic_status` table
     *
     * @return mixed
     */
    public function current_academic_status()
    {
        return $this->hasOne(CurrentAcadmicStatus::class, 'student_id', 'student_id');
    }

}
