<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use PhpMyAdmin\SqlParser\Utils\Table;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model
{
    use HasFactory;

     /**
     * Define `merried/unmerried` value field
     *
     * @var string
     */

    CONST MERRIED = 1;
    CONST UNMERRIED = 0;


    protected $table = 'students';

    /**
     * Attributes should cast
     *
     * @var array
     */
    protected $casts = [
        'id' => 'int',
        'dob' => 'date',
        'created_at' => 'date',
        'updated_at' => 'date'
    ];


    public function MarksDetails(){
        return $this->hasMany(Marks::class)->with('subject');
    }

    public function MarksBySubject(){
        return $this->hasOne(Marks::class)->with('subject');
    }

    public function currentAcademicStatus(){
        return $this->hasOne(CurrentAcadmicStatus::class)
        ->with('session')->with('class')->with('section');
    }




     /**
     * Query for `Students with class,section,subject,marks columns` data
     *
     * @param  int  $personId
     * @param  int  $classId
     * @param  array|null  $sectionId
     * @param  array|null  $otherParams
     * @return mixed
     */
    public static function MarksEntryDataTable($personId, $sectionId, $otherParams = null){
        $studentsTable = (new Student())->getTable();
        $classesTable = (new Classes())->getTable();
        $sectionsTable = (new Sections())->getTable();
        $sessionsTable = (new Sessions())->getTable();
        $markTypesTable = (new MarkTypes())->getTable();
        $currentAcadmicStatusTable = (new CurrentAcadmicStatus())->getTable();

       // $subjectsTable = (new Subjects())->getTable();


        $orderPurchaseTableFilter = NULL;
        $poShipmentDetailTableFilter = NULL;


        $classId = isset($otherParams['class_id']) ? $otherParams['class_id'] : 0;
        $sessionId = isset($otherParams['session_id']) ? $otherParams['session_id'] : 0;
        $keyword = isset($otherParams['search']) ? $otherParams['search'] : null;

        $offset = isset($otherParams['offset']) ? $otherParams['offset'] : 0;
        $limit = isset($otherParams['limit']) ? $otherParams['limit'] : 10;

        $orderColumn = isset($otherParams['order_column']) ? $otherParams['order_column'] : 'id';
        $orderDir = isset($otherParams['order_dir']) ? $otherParams['order_dir'] : 'asc';

        $searchFilter = null;
        if (!empty($keyword)) {
            $searchFilter = "AND (
                    `name` LIKE '%{$keyword}%'
                    OR `roll_no` LIKE '%{$keyword}%'
                    OR `class_name` LIKE '%{$keyword}%'
                    OR `session_name` LIKE '%{$keyword}%'
                )";
        }

        $sessionIdFilter = null;
        if ($sessionId > 0) {
            $sessionIdFilter = "AND `session_id` = '{$sessionId}'";
        }

        $sectionIdFilter = null;
        if ($sectionId > 0) {
            //$sectionIdFilter = "AND `section_id` ='{$sectionId}'";
        }

        $classIdFilter = null;
        if ($classId > 0) {
            $classIdFilter = "AND  `class_id` = '{$classId}'";
        }

        $sql = "";
            $sql = "
                SELECT `{$studentsTable}`.*,
                `tb_current_class`.class_name,
                `tb_current_section`.section_name,
                `tb_current_session`.session_id,
                `tb_current_session`.session_name
                    FROM `{$studentsTable}`

                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                                `{$currentAcadmicStatusTable}`.`class_id`,
                               `{$classesTable}`.`class_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$classesTable}` ON `{$classesTable}`.id = `{$currentAcadmicStatusTable}`.class_id

                    ) `tb_current_class` ON `tb_current_class`.student_id = `{$studentsTable}`.id


                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                               `{$sectionsTable}`.`section_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sectionsTable}` ON `{$sectionsTable}`.id = `{$currentAcadmicStatusTable}`.section_id

                    ) `tb_current_section` ON `tb_current_section`.student_id = `{$studentsTable}`.id


                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                               `{$currentAcadmicStatusTable}`.`session_id`,
                               `{$sessionsTable}`.`session_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sessionsTable}` ON `{$sessionsTable}`.id = `{$currentAcadmicStatusTable}`.session_id

                    ) `tb_current_session` ON `tb_current_session`.student_id = `{$studentsTable}`.id

                ";

        $limitFilter = NULL;
        if ($limit > 0) {
            $limitFilter = "LIMIT {$limit} OFFSET {$offset}";
        }

        return DB::select(DB::raw("SELECT *
                    FROM (
                        $sql
                    ) `tb1`
                    WHERE 1 = 1
                    {$sectionIdFilter}
                    {$searchFilter}
                    {$classIdFilter}
                    {$sessionIdFilter}
                    ORDER BY `{$orderColumn}` {$orderDir}
                    {$limitFilter}

                "));
    }


    /**
     * Query for `Students with class,section,subject,marks columns` data
     *
     * @param  int  $personId
     * @param  int  $classId
     * @param  array|null  $sectionId
     * @param  array|null  $otherParams
     * @return mixed
     */
    public static function countMarksEntryDataTable($personId, $sectionId, $otherParams = null){
        $studentsTable = (new Student())->getTable();
        $classesTable = (new Classes())->getTable();
        $sectionsTable = (new Sections())->getTable();
        $sessionsTable = (new Sessions())->getTable();
        $marksTable = (new Marks())->getTable();
        $currentAcadmicStatusTable = (new CurrentAcadmicStatus())->getTable();


        $orderPurchaseTableFilter = NULL;
        $poShipmentDetailTableFilter = NULL;


        $classId = isset($otherParams['class_id']) ? $otherParams['class_id'] : 0;
        $sessionId = isset($otherParams['session_id']) ? $otherParams['session_id'] : 0;
        $keyword = isset($otherParams['search']) ? $otherParams['search'] : null;

        $offset = isset($otherParams['offset']) ? $otherParams['offset'] : 0;
        $limit = isset($otherParams['limit']) ? $otherParams['limit'] : 10;

        $orderColumn = isset($otherParams['order_column']) ? $otherParams['order_column'] : 'roll_no';
        $orderDir = isset($otherParams['order_dir']) ? $otherParams['order_dir'] : 'asc';

        $searchFilter = null;
        if (!empty($keyword)) {
            $searchFilter = "AND (
                    `name` LIKE '%{$keyword}%'
                    OR `roll_no` LIKE '%{$keyword}%'
                    OR `class_name` LIKE '%{$keyword}%'
                    OR `session_name` LIKE '%{$keyword}%'
                )";
        }

        $sessionIdFilter = null;
        if ($sessionId > 0) {
            $sessionIdFilter = "AND `session_id` = '{$sessionId}'";
        }

        $sectionIdFilter = null;
        if ($sectionId > 0) {
           // $sectionIdFilter = "AND `section_id` ='{$sectionId}'";
        }

        $classIdFilter = null;
        if ($classId > 0) {
            $classIdFilter = "AND  `class_id` = '{$classId}'";
        }

        $sql = "";
            $sql = "
                SELECT `{$studentsTable}`.*,
                `tb_current_class`.class_name,
                `tb_current_section`.section_name,
                `tb_current_session`.session_id,
                `tb_current_session`.session_name
                    FROM `{$studentsTable}`

                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                               `{$currentAcadmicStatusTable}`.`class_id`,
                               `{$classesTable}`.`class_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$classesTable}` ON `{$classesTable}`.id = `{$currentAcadmicStatusTable}`.class_id

                    ) `tb_current_class` ON `tb_current_class`.student_id = `{$studentsTable}`.id


                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                               `{$sectionsTable}`.`section_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sectionsTable}` ON `{$sectionsTable}`.id = `{$currentAcadmicStatusTable}`.section_id

                    ) `tb_current_section` ON `tb_current_section`.student_id = `{$studentsTable}`.id

                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                                `{$currentAcadmicStatusTable}`.`session_id`,
                               `{$sessionsTable}`.`session_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sessionsTable}` ON `{$sessionsTable}`.id = `{$currentAcadmicStatusTable}`.session_id

                    ) `tb_current_session` ON `tb_current_session`.student_id = `{$studentsTable}`.id


                ";

        $limitFilter = NULL;
        if ($limit > 0) {
            $limitFilter = "LIMIT {$limit} OFFSET {$offset}";
        }

        $resultQuery = DB::select(DB::raw("SELECT COUNT(*) AS total
                    FROM (
                        $sql
                    ) `tb1`
                    WHERE 1 = 1
                    {$sectionIdFilter}
                    {$searchFilter}
                    {$classIdFilter}
                    {$sessionIdFilter}
                    ORDER BY `{$orderColumn}` {$orderDir}
                    {$limitFilter}

                "));

        return $resultQuery[0]->total ?? 0;
    }


    public static function searchStudent($roll_no,$session_id,$class_id,$section_id,$group_id){
                $studentDetails = CurrentAcadmicStatus::join('students', 'students.id', '=', 'current_academic_status.student_id')
                ->with('session')
                ->with('class')
                ->with('section')
                ->where('current_academic_status.roll_no',$roll_no)
                ->where('current_academic_status.class_id',$class_id)
                ->where('current_academic_status.section_id',$section_id)
                ->where('current_academic_status.session_id',$session_id)
                ->orderBy('current_academic_status.id','desc')
                ->select(
                    'current_academic_status.*',
                    'students.*'
                )
                ->first();


        return $studentDetails;
    }

}
