<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Salary extends Model
{
    use HasFactory;

    protected $table = 'salaries';
    protected $fillable = ['employee_id','details', 'amount','entry_date', 'note','status','payment_method','bank_or_wallet_id','acc_or_mobile_no'];

     /**
     * Relationship to `students` table
     *
     * @return mixed
     */

     public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id', 'id');
    }

    public function bank()
    {
        return $this->belongsTo(Banks::class, 'bank_or_wallet_id', 'id');
    }

    public function mobile_walet()
    {
        return $this->belongsTo(MobileWalets::class, 'bank_or_wallet_id', 'id');
    }
}
