<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use PhpMyAdmin\SqlParser\Utils\Table;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReceivePayments extends Model
{
    use HasFactory;

     /**
     * Define `Payment Method` value field
     *
     * @var string
     */
    CONST CASH = '1';
    CONST BANKING = '2';
    CONST MOBILE_BANKING = '3';
    CONST ONLINE = '4';

    protected $table = 'receive_payments';

    /**
     * Get all Payment Info
     *
     * @return array
     */
    public static function getAllPaymentByPOID($id)
    {
    return DB::table('receive_payments')
              ->where('order_id', $id)->first();

    }

        /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function payment_method()
    {
        return $this->hasOne(PaymentMethod::class,'id' ,'payment_method_id');
    }

    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function bank_or_mobile_wallet()
    {
        return $this->hasOne(BanksOrMobiles::class,'id' ,'bank_or_mobile_wallet_id');
    }

    public function bank_or_mobile_wallet_account()
    {
        return $this->hasOne(Account::class,'id' ,'account_no_id');
    }

    /**
     * Relationship to `coupon` table
     *
     * @return mixed
     */
    public function coupon(){
        return $this->hasOne(Coupon::class,'payment_id', 'id')->withDefault(['status' => 'out']);
    }


        /**
     * Query to search by name from table
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param string|null $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeOrders($query, $keyword = null)
    {
        if (!empty($keyword)) {
            $receivePaymentTable = $this->getTable();
            $orderManagementTable = (new OrderManagement())->getTable();
            $query->join("{$orderManagementTable}", "{$orderManagementTable}.id", '=', "{$receivePaymentTable}.order_id");
        }

        return;
    }

    /**
     * get From `order_managements` table By client_id
     *
     * @return
     */
    public static function deleteSalePaymentID333($client_id)
    {
        DB::table('order_managements')->where('client_id', $client_id)->delete();
    }

         /**
     * Delete From `sales_details` table By order_id
     *
     * @return
     */
    public static function deleteSalePaymentID($order_id)
    {
        DB::table('receive_payments')->where('order_id', $order_id)->delete();
    }


     /**
     * Get Payment Details
     *
     * @return Int
     */
    public static function getPaymentDetails($arr_param)
    {
    $receivePaymentsTable = (new ReceivePayments())->getTable();
    $orderManagementTable = (new OrderManagement())->getTable();
    
    $clientTable = (new Customer())->getTable();
    $lenderTable = (new Lender())->getTable();
    $payment_methodsTable = (new PaymentMethods())->getTable();
    $banksOrMobilesTable = (new BanksOrMobiles())->getTable();


    $start_date = isset($arr_param['start_date']) ? $arr_param['start_date'] : '';
    $end_date = isset($arr_param['end_date']) ? $arr_param['end_date'] : '';
    $bankOrMobileWalletId = isset($arr_param['bank_or_mobile_wallet_id']) ? $arr_param['bank_or_mobile_wallet_id'] : '';
    $payment_methodID = isset($arr_param['payment_methodID']) ? $arr_param['payment_methodID'] : '';
    $clientId = isset($arr_param['clientId']) ? $arr_param['clientId'] : '';
    $lenderId = isset($arr_param['lenderId']) ? $arr_param['lenderId'] : '';
    $type = isset($arr_param['type']) ? $arr_param['type'] : '';

    $sellerId = $arr_param['sellerId'];

    $search = $arr_param['search'];
    $orderColumn = $arr_param['orderColumn'];
    $orderDir = $arr_param['orderDir'];

    $start = isset($arr_param['start']) ? $arr_param['start'] : 0;
    $limit = isset($arr_param['limit']) ? $arr_param['limit'] : 100;

    $clientIdFilter = NULL;
    if ($clientId > 0) {
        $clientIdFilter = "AND `{$receivePaymentsTable}`.client_id = '{$clientId}'";
    }

    $lenderIdFilter = NULL;
    if ($lenderId > 0) {
        $lenderIdFilter = "AND `lender_id` = '{$lenderId}'";
    }

    $paymentDateFilter = NULL;
    if (!empty($start_date) && !empty($end_date)) {        
        $paymentDateFilter = "AND `payment_date` BETWEEN  '{$start_date}' AND '{$end_date}'";
    }

    $payment_methodFilter = NULL;
    if ($payment_methodID > 0) {
        $payment_methodFilter = "AND `payment_method_id` = '{$payment_methodID}'";
    }

    $bankOrMobileWalletIdFilter = NULL;
    if ($bankOrMobileWalletId > 0) {
        $bankOrMobileWalletIdFilter = "AND `bank_or_mobile_wallet_id` = '{$bankOrMobileWalletId}'";
    }

    $typeFilter = NULL;
    if ($type) {
        $typeFilter = "AND `type` = '{$type}'";
    }

     $limitFilter = NULL;
        if ($limit > 0) {
            $limitFilter = "LIMIT {$limit} OFFSET {$start}";
        }

    $sql = "SELECT `{$receivePaymentsTable}`.*,
            `{$clientTable}`.client_name,
            `{$lenderTable}`.lender_name,
            `{$payment_methodsTable}`.name as payment_method,
            `{$banksOrMobilesTable}`.name as banks_or_mobile
            FROM `{$receivePaymentsTable}`
            LEFT JOIN  `{$clientTable}` ON  `{$clientTable}`.id = `{$receivePaymentsTable}`.client_id
            LEFT JOIN  `{$lenderTable}` ON  `{$lenderTable}`.id = `{$receivePaymentsTable}`.lender_id
            LEFT JOIN  `{$payment_methodsTable}` ON  `{$payment_methodsTable}`.id = `{$receivePaymentsTable}`.payment_method_id
            LEFT JOIN  `{$banksOrMobilesTable}` ON  `{$banksOrMobilesTable}`.id = `{$receivePaymentsTable}`.bank_or_mobile_wallet_id
            ";

        $data =  DB::select(DB::raw("SELECT *
                        FROM (
                            $sql
                        ) `tb1`
                        WHERE 1 = 1
                        {$paymentDateFilter}
                        {$payment_methodFilter}
                        {$clientIdFilter}
                        {$lenderIdFilter}
                        {$bankOrMobileWalletIdFilter}
                        {$typeFilter}
                         ORDER BY `{$orderColumn}` {$orderDir}
                        {$limitFilter}
                    "));

    return $data;



    }


     /**
     * Get Order Purchase Total
     *
     * @return Int
     */
    public static function getReceivePaymentsTotal($arr_param)
    {
    $receivePaymentsTable = (new ReceivePayments())->getTable();
    $clientTable = (new Customer())->getTable();
    $lenderTable = (new Lender())->getTable();
    $payment_methodsTable = (new PaymentMethods())->getTable();
    $banksOrMobilesTable = (new BanksOrMobiles())->getTable();

    $start_date = isset($arr_param['start_date']) ? $arr_param['start_date'] : '';
    $end_date = isset($arr_param['end_date']) ? $arr_param['end_date'] : '';
    $bankOrMobileWalletId = isset($arr_param['bank_or_mobile_wallet_id']) ? $arr_param['bank_or_mobile_wallet_id'] : '';
    $payment_methodID = isset($arr_param['payment_methodID']) ? $arr_param['payment_methodID'] : '';
    $clientId = isset($arr_param['clientId']) ? $arr_param['clientId'] : '';
    $lenderId = isset($arr_param['lenderId']) ? $arr_param['lenderId'] : '';
    $type = isset($arr_param['type']) ? $arr_param['type'] : '';

    $clientIdFilter = NULL;
    if ($clientId > 0) {
        $clientIdFilter = "AND `client_id` = '{$clientId}'";
    }

    $paymentDateFilter = NULL;
    if (!empty($start_date) && !empty($end_date)) {
        $start_date = date('Y-m-d', strtotime($start_date));
        $end_date = date('Y-m-d', strtotime($end_date));
        $paymentDateFilter = "AND `payment_date` BETWEEN  '{$start_date}' AND '{$end_date}'";
    }

    $payment_methodFilter = NULL;
    if ($payment_methodID > 0) {
        $payment_methodFilter = "AND `payment_method_id` = '{$payment_methodID}'";
    }

    $bankOrMobileWalletIdFilter = NULL;
    if ($bankOrMobileWalletId > 0) {
        $bankOrMobileWalletIdFilter = "AND `bank_or_mobile_wallet_id` = '{$bankOrMobileWalletId}'";
    }

    $typeFilter = NULL;
    if ($type) {
        $typeFilter = "AND `type` = '{$type}'";
    }

    $sql = "SELECT `{$receivePaymentsTable}`.*,
            `{$clientTable}`.client_name,
            `{$lenderTable}`.lender_name,
            `{$payment_methodsTable}`.name as payment_method,
            `{$banksOrMobilesTable}`.name as banks_or_mobile
            FROM `{$receivePaymentsTable}`
            LEFT JOIN  `{$clientTable}` ON  `{$clientTable}`.id = `{$receivePaymentsTable}`.client_id
            LEFT JOIN  `{$lenderTable}` ON  `{$lenderTable}`.id = `{$receivePaymentsTable}`.lender_id
            LEFT JOIN  `{$payment_methodsTable}` ON  `{$payment_methodsTable}`.id = `{$receivePaymentsTable}`.payment_method_id
            LEFT JOIN  `{$banksOrMobilesTable}` ON  `{$banksOrMobilesTable}`.id = `{$receivePaymentsTable}`.bank_or_mobile_wallet_id
            ";

  $resultQuery =  DB::select(DB::raw("SELECT SUM( `paid`) AS total
  FROM (
      $sql
  ) tb1
  WHERE 1 = 1
  {$paymentDateFilter}
    {$payment_methodFilter}
    {$clientIdFilter}
    {$bankOrMobileWalletIdFilter}
    {$typeFilter}

"));
return $resultQuery[0]->total;

}



    /**
     * Insert Data into Tatble
     *
     * @return last insert id
     */

    public static function insertData($table,$data = []){
        DB::table($table)->insert($data);
        $id = DB::getPdo()->lastInsertId();
        return $id;
    }


    /**
     * Insert Data into Tatble
     *
     * @return last insert id
     */

    public static function insertTableData($table,$data = []){
        DB::table($table)->insert($data);
        $id = DB::getPdo()->lastInsertId();
        return $id;
    }



     /**
     * Update payment
     *
     * @param int $id
     * @param array $data
     */
    public static function updatePayment($table,$id,$data = []){
        DB::table($table)->where('id', $id)->update($data);
    }


}
