<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use PhpMyAdmin\SqlParser\Utils\Table;
use Illuminate\Database\Eloquent\SoftDeletes;

class RawMaterial extends Model
{
    use HasFactory;

    /**
     * Define `stock_status`
     *
     * @var mixed
     */
    CONST STATUS_ACTIVATE = 1;
    CONST STATUS_DEACTIVATE = 0;





    /**
     * Query to search by name from table
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param string|null $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchTable($query, $keyword = null)
    {
        if (!empty($keyword)) {
            $productTable = $this->getTable();
            $query->Where('name', 'like', "%$keyword%");
        }
        return;
    }


    /**
     * Sub Query to get total of incoming / order_purchase_detail
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeTotalIncoming($query)
    {
        $productTable = $this->getTable();
        $orderPurchaseTable = (new OrderPurchase())->getTable();
        $orderPurchaseDetailsTable = (new OrderPurchaseDetail())->getTable();

        return $query->addSelect(['total_incoming' => OrderPurchaseDetail::selectRaw("
        SUM({$orderPurchaseDetailsTable}.quantity)
        ")
        ->join("{$orderPurchaseTable}", "{$orderPurchaseTable}.id", '=', "{$orderPurchaseDetailsTable}.purchase_id")
            ->whereColumn("{$orderPurchaseDetailsTable}.product_code", "{$productTable}.product_code")
            ->where("{$orderPurchaseTable}.status", '<>', OrderPurchase::STATUS_CLOSE)
            ->limit(1)
        ]);
    }

}
