<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseExtraCharges extends Model
{
    use HasFactory;

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id')
            ->withDefault()
            ->with('getQuantity');
    }

    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function receive_payments()
    {
        return $this->hasOne(ReceivePayment::class, 'service_id','service_id');
    }

    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function payment_method()
    {
        return $this->hasOne(PaymentMethod::class,'id' ,'payment_method_id');
    }
}
