<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseDetails extends Model
{
    use HasFactory;


    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function purchase()
    {
        return $this->hasOne(PurchaseDetails::class, 'id','purchase_id');
    }

    /**
     * Relationship to `product` table
     *
     * @return mixed
     */
    public function product()
    {
        return $this->hasOne(Product::class, 'id','product_id');
    }


    

    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function receive_payments()
    {
        return $this->hasOne(Payment::class, 'order_id','purchase_id');
    }

    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function payment_method()
    {
        return $this->hasOne(PaymentMethod::class,'id' ,'payment_method_id');
    }
}
