<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class PoShipmentDetail extends Model
{
    use HasFactory;

    /**
     * Define value of `po_status` field
     *
     * @var string
     */
    CONST PO_STATUS_OPEN = 'open';
    CONST PO_STATUS_CLOSE = 'close';
    CONST PO_STATUS_ARRIVE = 'arrive';

    /**
     * Relationship to `products` table
     *
     * @return mixed
     */
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id')
                ->withDefault([
                    'part_name' => '',
                    'part_no' => ''
                ])
                ->with('getQuantity')
                ->with('getIncoming')
                ->with('productCostDetails');
    }



     /**
     * Relationship to `order_purchase_details` table
     *
     * @return mixed
     */
    public function getShipped(){
        return $this->hasMany(PoShipmentDetail::class, 'purchase_id', 'purchase_id')
        ->select('product_id',DB::raw('po_shipment_details.purchase_id,sum(ship_quantity) as totalShipped'))
        ->groupBy(['product_id','purchase_id']);
    }

    
    /**
     * Relationship to `order_purchases` table
     *
     * @return mixed
     */
    public function orderPurchase()
    {
        return $this->belongsTo(OrderPurchase::class,'purchase_id', 'id');
    }

    /**
     * Relationsip to `exchange_rate` table
     *
     * @return mixed
     */
    public function exchange_rate()
    {
        return $this->belongsTo(ExchangeRate::class, 'exchange_rate_id', 'id');
    }
    
 /**
     * Relationship to `suppliers` table
     *
     * @return mixed
     */
    public function supplier()
    {
        return $this->belongsTo(Supplier::class,'supplier_id', 'id');
    }
   
    
    // Delete Exisiting data from po_shipment_details by po_shipment_id
    public static function getDataByPoShipmentID($purchase_id){
        DB::table('po_shipment_details')->where('purchase_id', $purchase_id)->get();  
    }

    // Delete Exisiting data from po_shipment_details by po_shipment_id
    public static function deleteByPoShipmentID($po_shipment_id){
        DB::table('po_shipment_details')->where('po_shipment_id', $po_shipment_id)->delete();  
   }

   /**
     * Delete From `order_purchase_details` table By purchase_id
     *
     * @return 
     */
    public static function deletePoShipmentDetailsByPOID($purchase_id)
    {
        DB::table('po_shipment_details')->where('purchase_id', $purchase_id)->delete(); 
    }


     /**
     * Update Po Shipments
     *
     * @param int old po id,new po id
     * @param null
     */
    public static function updatePoShipmentDetailsPurchaseID($old_purchase_id,$purchase_id){
        
        DB::table('po_shipment_details')->where('purchase_id', $old_purchase_id)
        ->update([
            'purchase_id' =>$purchase_id
        ]);
    }

   
}
