<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Partner extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Define table name
     *
     * @var string
     */
    protected $table = 'partners';

    /**
     * Mass fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'shop_id',
        'name',
        'phone',
        'email',
        'address'
    ];


    /**
     * Relationship to `users` table as a seller
     *
     * @return mixed
     */
    public function shop()
    {
        return $this->belongsTo(Shop::class)->withDefault();
    }

    /**
     * Filter by `order_type` custom only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeCustomOrder($query)
    {
        return $query->where('order_type', self::ORDER_TYPE_CUSTOM);
    }

    /**
     * Query to check if client is Dropshipper
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  int  $clientType
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeCustomerType($query, $clientType)
    {
        if ($clientType != '0') {
            return $query->where('is_dropshipper', '=', 1);
        }

        return;
    }
}
