<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderManagementDetail extends Model
{
    use HasFactory;


    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function order_management()
    {
        return $this->hasOne(OrderManagement::class, 'id','order_management_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id', 'id')
            ->withDefault()
            ->quantity();
    }

    /**
     * Relationship to `payments` table
     *
     * @return mixed
     */
    public function receive_payments()
    {
        return $this->hasOne(ReceivePayment::class, 'order_id','order_management_id');
    }

    /**
     * Relationship to `payment_method`
     *
     * @return mixed
     */
    public function payment_method()
    {
        return $this->hasOne(PaymentMethod::class,'id' ,'payment_method_id');
    }
}
