<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use PhpMyAdmin\SqlParser\Utils\Table;
use Illuminate\Database\Eloquent\SoftDeletes;

class MyBankings extends Model
{
    use HasFactory;

     /**
     * Define `Payment Method` value field
     *
     * @var string
     */
    CONST CASH = '1';
    CONST CHEQUE = '2';
    CONST MOBILE_BANKING = '3';
    CONST ONLINE = '4';

    protected $table = 'my_bankings';

    /**
     * Get all Payment Info
     *
     * @return array
     */
    public static function getAllPaymentByPOID($id)
    {
    return DB::table('my_bankings')
              ->where('order_id', $id)->first();

    }

         /**
     * Delete From `sales_details` table By order_id
     *
     * @return
     */
    public static function deleteSalePaymentID($order_id)
    {
        DB::table('my_bankings')->where('order_id', $order_id)->delete();
    }


     /**
     * Get Payment Details
     *
     * @return Int
     */
    public static function getPaymentDetails($arr_param)
    {
    $receivePaymentsTable = (new MyBankings())->getTable();
    $payment_methodsTable = (new PaymentMethods())->getTable();
    $banksOrMobilesTable = (new BanksOrMobiles())->getTable();
    $sellerId = $arr_param['sellerId'];
    $search = $arr_param['search'];
    $orderColumn = $arr_param['orderColumn'];
    $orderDir = $arr_param['orderDir'];
    $limit = $arr_param['limit'];
    $start = $arr_param['start'];

    $type = $arr_param['type'];
    $payment_methodID = $arr_param['payment_methodFilter'];


    $typeFilter = NULL;
    if ($type) {
        $typeFilter = "AND `type` = '{$type}'";
    }

    $payment_methodFilter = NULL;
    if ($payment_methodID > 0) {
        $payment_methodFilter = "AND `payment_method_id` = '{$payment_methodID}'";
    }


    $sql = "SELECT `{$receivePaymentsTable}`.*,
            `{$payment_methodsTable}`.name as payment_method,
            `{$banksOrMobilesTable}`.name as banks_or_mobile
            FROM `{$receivePaymentsTable}`
            LEFT JOIN  `{$payment_methodsTable}` ON  `{$payment_methodsTable}`.id = `{$receivePaymentsTable}`.payment_method_id
            LEFT JOIN  `{$banksOrMobilesTable}` ON  `{$banksOrMobilesTable}`.id = `{$receivePaymentsTable}`.bank_or_mobile_wallet_id
            ";

        $data =  DB::select(DB::raw("SELECT *
                        FROM (
                            $sql
                        ) `tb1`
                        WHERE 1 = 1
                        {$payment_methodFilter}
                        {$typeFilter}
                    "));

    return $data;



    }


     /**
     * Get Order Purchase Total
     *
     * @return Int
     */
    public static function getReceivePaymentsTotalByPaymentMethod($arr_param)
    {
        $receivePaymentsTable = (new MyBankings())->getTable();
        $payment_methodsTable = (new PaymentMethods())->getTable();
        $banksOrMobilesTable = (new BanksOrMobiles())->getTable();
        $sellerId = $arr_param['sellerId'];
        $type = $arr_param['type'];
        $payment_methodID = $arr_param['payment_methodFilter'];


        $typeFilter = NULL;
        if ($type) {
            $typeFilter = "AND `type` = '{$type}'";
        }
        $payment_methodFilter = NULL;
        if ($payment_methodID > 0) {
            $payment_methodFilter = "AND `payment_method_id` = '{$payment_methodID}'";
        }

        $sql = "SELECT `{$receivePaymentsTable}`.*,
        `{$payment_methodsTable}`.name as payment_method,
        `{$banksOrMobilesTable}`.name as banks_or_mobile
        FROM `{$receivePaymentsTable}`
        LEFT JOIN  `{$payment_methodsTable}` ON  `{$payment_methodsTable}`.id = `{$receivePaymentsTable}`.payment_method_id
        LEFT JOIN  `{$banksOrMobilesTable}` ON  `{$banksOrMobilesTable}`.id = `{$receivePaymentsTable}`.bank_or_mobile_wallet_id
        ";

  $resultQuery = DB::select(DB::raw("SELECT COUNT(*) AS total
  FROM (
      $sql
  ) tb1
  WHERE 1 = 1

"));

return $resultQuery[0]->total ?? 0;

    }



    /**
     * Insert Data into Tatble
     *
     * @return last insert id
     */

    public static function insertData($table,$data = []){
        DB::table($table)->insert($data);
        $id = DB::getPdo()->lastInsertId();
        return $id;
    }


    /**
     * Insert Data into Tatble
     *
     * @return last insert id
     */

    public static function insertTableData($table,$data = []){
        DB::table($table)->insert($data);
        $id = DB::getPdo()->lastInsertId();
        return $id;
    }



     /**
     * Update payment
     *
     * @param int $id
     * @param array $data
     */
    public static function updatePayment($table,$id,$data = []){
        DB::table($table)->where('id', $id)->update($data);
    }


}
