<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class MarksByClass extends Model
{
    use HasFactory;

     /**
     * Query for `Students with class,section,subject,marks columns` data
     *
     * @param  int  $personId
     * @param  int  $classId
     * @param  array|null  $sectionId
     * @param  array|null  $otherParams
     * @return mixed
     */
    public static function MarksEntryDataTable($personId, $sectionId, $otherParams = null){
        $studentsTable = (new Student())->getTable();
        $classesTable = (new Classes())->getTable();
        $sectionsTable = (new Sections())->getTable();
        $sessionsTable = (new Sessions())->getTable();
        $markTypesTable = (new MarkTypes())->getTable();
        $marksTable = (new Marks())->getTable();
        $currentAcadmicStatusTable = (new CurrentAcadmicStatus())->getTable();
        $subjectsTable = (new Subjects())->getTable();


        $orderPurchaseTableFilter = NULL;
        $poShipmentDetailTableFilter = NULL;


        $classId = isset($otherParams['class_id']) ? $otherParams['class_id'] : 0;
        $sessionId = isset($otherParams['session_id']) ? $otherParams['session_id'] : 0;
        $subjectId = isset($otherParams['subject_id']) ? $otherParams['subject_id'] : 0;
        $examId = isset($otherParams['exam_id']) ? $otherParams['exam_id'] : 0;
        $keyword = isset($otherParams['search']) ? $otherParams['search'] : null;

        $offset = isset($otherParams['offset']) ? $otherParams['offset'] : 0;
        $limit = isset($otherParams['limit']) ? $otherParams['limit'] : 10;

        $orderColumn = isset($otherParams['order_column']) ? $otherParams['order_column'] : 'id';
        $orderDir = isset($otherParams['order_dir']) ? $otherParams['order_dir'] : 'asc';

        $searchFilter = null;
        if (!empty($keyword)) {
            $searchFilter = "AND (
                    `name` LIKE '%{$keyword}%'
                    OR `roll_no` LIKE '%{$keyword}%'
                    OR `class_name` LIKE '%{$keyword}%'
                    OR `session_name` LIKE '%{$keyword}%'
                )";
        }


        $examIdFilter = null;
        if ($examId > 0) {
            $examIdFilter = "AND `{$marksTable}`.`exam_id` = '{$examId}'";
        }

        $sessionIdFilter = null;
        if ($sessionId > 0) {
            $sessionIdFilter = "AND `{$currentAcadmicStatusTable}`.session_id = '{$sessionId}'";
        }

        $sectionIdFilter = null;
        if ($sectionId > 0) {
            $sectionIdFilter = "AND `{$marksTable}`.`section_id` ='{$sectionId}'";
        }

        $classIdFilter = null;
        if ($classId > 0) {
            $classIdFilter = "AND  `{$marksTable}`.`class_id` = '{$classId}'";
        }



        $sql = "SELECT DISTINCT
        `{$studentsTable}`.roll_no,
        `{$studentsTable}`.name,
        `{$classesTable}`.class_name,
        `{$sectionsTable}`.section_name,
        `{$sessionsTable}`.session_name,
        `{$subjectsTable}`.name as subject_name,
        `{$marksTable}`.*
        FROM `{$studentsTable}`
        JOIN `{$currentAcadmicStatusTable}` ON `{$studentsTable}`.id = `{$currentAcadmicStatusTable}`.student_id
        JOIN `{$classesTable}` ON `{$currentAcadmicStatusTable}`.class_id = `{$classesTable}`.id
        JOIN `{$sectionsTable}` ON `{$currentAcadmicStatusTable}`.section_id = `{$sectionsTable}`.id
        JOIN `{$sessionsTable}` ON `{$currentAcadmicStatusTable}`.session_id = `{$sessionsTable}`.id
        JOIN `{$marksTable}` ON `{$studentsTable}`.id = `{$marksTable}`.student_id
        JOIN `{$subjectsTable}` ON `{$marksTable}`.subject_id = `{$subjectsTable}`.id
        ";

        $limitFilter = NULL;
        if ($limit > 0) {
            $limitFilter = "LIMIT {$limit} OFFSET {$offset}";
        }

        return DB::select(DB::raw("
                    $sql
                    WHERE 1 = 1
                    {$searchFilter}
                    {$classIdFilter}
                    {$sessionIdFilter}
                    {$examIdFilter}
                    ORDER BY `{$orderColumn}` {$orderDir}
                    {$limitFilter}

                "));

    }


    /**
     * Query for `Students with class,section,subject,marks columns` data
     *
     * @param  int  $personId
     * @param  int  $classId
     * @param  array|null  $sectionId
     * @param  array|null  $otherParams
     * @return mixed
     */
    public static function countMarksEntryDataTable($personId, $sectionId, $otherParams = null){
        $studentsTable = (new Student())->getTable();
        $classesTable = (new Classes())->getTable();
        $sectionsTable = (new Sections())->getTable();
        $sessionsTable = (new Sessions())->getTable();
        $markTypesTable = (new MarkTypes())->getTable();
        $marksTable = (new Marks())->getTable();
        $currentAcadmicStatusTable = (new CurrentAcadmicStatus())->getTable();
        $subjectsTable = (new Subjects())->getTable();

        $orderPurchaseTableFilter = NULL;
        $poShipmentDetailTableFilter = NULL;


        $classId = isset($otherParams['class_id']) ? $otherParams['class_id'] : 0;
        $sessionId = isset($otherParams['session_id']) ? $otherParams['session_id'] : 0;
        $subjectId = isset($otherParams['subject_id']) ? $otherParams['subject_id'] : 0;
        $examId = isset($otherParams['exam_id']) ? $otherParams['exam_id'] : 0;
        $keyword = isset($otherParams['search']) ? $otherParams['search'] : null;

        $offset = isset($otherParams['offset']) ? $otherParams['offset'] : 0;
        $limit = isset($otherParams['limit']) ? $otherParams['limit'] : 10;

        $orderColumn = isset($otherParams['order_column']) ? $otherParams['order_column'] : 'roll_no';
        $orderDir = isset($otherParams['order_dir']) ? $otherParams['order_dir'] : 'asc';

        $searchFilter = null;
        if (!empty($keyword)) {
            $searchFilter = "AND (
                    `name` LIKE '%{$keyword}%'
                    OR `roll_no` LIKE '%{$keyword}%'
                    OR `class_name` LIKE '%{$keyword}%'
                    OR `session_name` LIKE '%{$keyword}%'
                )";
        }

        $examIdFilter = null;
        if ($examId > 0) {
            $examIdFilter = "AND `{$marksTable}`.`exam_id` = '{$examId}'";
        }

        $sessionIdFilter = null;
        if ($sessionId > 0) {
            $sessionIdFilter = "AND `{$currentAcadmicStatusTable}`.session_id = '{$sessionId}'";
        }

        $sectionIdFilter = null;
        if ($sectionId > 0) {
            $sectionIdFilter = "AND `{$marksTable}`.`section_id` ='{$sectionId}'";
        }

        $classIdFilter = null;
        if ($classId > 0) {
            $classIdFilter = "AND  `{$marksTable}`.`class_id` = '{$classId}'";
        }



        $sql = "SELECT DISTINCT
        `{$studentsTable}`.roll_no,
        `{$studentsTable}`.name,
        `{$classesTable}`.class_name,
        `{$sectionsTable}`.section_name,
        `{$sessionsTable}`.session_name,
        `{$subjectsTable}`.name as subject_name,
        `{$marksTable}`.*
        FROM `{$studentsTable}`
        JOIN `{$currentAcadmicStatusTable}` ON `{$studentsTable}`.id = `{$currentAcadmicStatusTable}`.student_id
        JOIN `{$classesTable}` ON `{$currentAcadmicStatusTable}`.class_id = `{$classesTable}`.id
        JOIN `{$sectionsTable}` ON `{$currentAcadmicStatusTable}`.section_id = `{$sectionsTable}`.id
        JOIN `{$sessionsTable}` ON `{$currentAcadmicStatusTable}`.session_id = `{$sessionsTable}`.id
        JOIN `{$marksTable}` ON `{$studentsTable}`.id = `{$marksTable}`.student_id
        JOIN `{$subjectsTable}` ON `{$marksTable}`.subject_id = `{$subjectsTable}`.id
        ";

        $limitFilter = NULL;
        if ($limit > 0) {
            $limitFilter = "LIMIT {$limit} OFFSET {$offset}";
        }

        $resultQuery = DB::select(DB::raw("

                    $sql
                    WHERE 1 = 1
                    {$searchFilter}
                    {$classIdFilter}
                    {$sessionIdFilter}
                    {$examIdFilter}
                    ORDER BY `{$orderColumn}` {$orderDir}
                    {$limitFilter}

                "));
        return count($resultQuery) ?? 0;
    }


     /**
     * Query for `Students with class,section,subject,marks columns` data
     *
     * @param  int  $personId
     * @param  int  $classId
     * @param  array|null  $sectionId
     * @param  array|null  $otherParams
     * @return mixed
     */
    public static function MarksEntryExcelExport($personId, $sectionId, $otherParams = null){
        $studentsTable = (new Student())->getTable();
        $classesTable = (new Classes())->getTable();
        $sectionsTable = (new Sections())->getTable();
        $sessionsTable = (new Sessions())->getTable();
        $markTypesTable = (new MarkTypes())->getTable();
        $marksTable = (new Marks())->getTable();
        $currentAcadmicStatusTable = (new CurrentAcadmicStatus())->getTable();

       // $subjectsTable = (new Subjects())->getTable();


        $orderPurchaseTableFilter = NULL;
        $poShipmentDetailTableFilter = NULL;


        $classId = isset($otherParams['class_id']) ? $otherParams['class_id'] : 0;
        $sessionId = isset($otherParams['session_id']) ? $otherParams['session_id'] : 0;
        $keyword = isset($otherParams['search']) ? $otherParams['search'] : null;

        $offset = isset($otherParams['offset']) ? $otherParams['offset'] : 0;
        $limit = isset($otherParams['limit']) ? $otherParams['limit'] : 10;

        $orderColumn = isset($otherParams['order_column']) ? $otherParams['order_column'] : 'id';
        $orderDir = isset($otherParams['order_dir']) ? $otherParams['order_dir'] : 'asc';

        $searchFilter = null;
        if (!empty($keyword)) {
            $searchFilter = "AND (
                    `name` LIKE '%{$keyword}%'
                    OR `roll_no` LIKE '%{$keyword}%'
                    OR `class_name` LIKE '%{$keyword}%'
                    OR `session_name` LIKE '%{$keyword}%'
                )";
        }


        $sessionIdFilter = null;
        if ($sessionId > 0) {
            $sessionIdFilter = "AND `session_id` = '{$sessionId}'";
        }

        $sectionIdFilter = null;
        if ($sectionId > 0) {
            $sectionIdFilter = "AND `section_id` ='{$sectionId}'";
        }

        $classIdFilter = null;
        if ($classId > 0) {
            $classIdFilter = "AND  `class_id` = '{$classId}'";
        }

        $sql = "SELECT DISTINCT
        classes.class_name,
        sections.section_name,
        subjects.name,
        marks.*
        FROM students
        JOIN current_academic_status ON students.id = current_academic_status.student_id
        JOIN classes ON current_academic_status.class_id = classes.id
        JOIN sections ON current_academic_status.section_id = sections.id
        JOIN marks ON students.id = marks.student_id
        JOIN subjects ON marks.subject_id = subjects.id
        WHERE marks.session_id=4 ORDER BY marks.student_id asc";
            $sql1 = "
                SELECT `{$studentsTable}`.*,
                `tb_current_class`.class_id,
                `tb_current_class`.class_name,
                `tb_current_section`.section_id,
                `tb_current_section`.section_name,
                `tb_current_session`.session_id,
                `tb_current_session`.session_name
                    FROM `{$studentsTable}`

                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                                `{$currentAcadmicStatusTable}`.`class_id`,
                               `{$classesTable}`.`class_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$classesTable}` ON `{$classesTable}`.id = `{$currentAcadmicStatusTable}`.class_id

                    ) `tb_current_class` ON `tb_current_class`.student_id = `{$studentsTable}`.id


                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                                `{$currentAcadmicStatusTable}`.`section_id`,
                               `{$sectionsTable}`.`section_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sectionsTable}` ON `{$sectionsTable}`.id = `{$currentAcadmicStatusTable}`.section_id

                    ) `tb_current_section` ON `tb_current_section`.student_id = `{$studentsTable}`.id


                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                        `{$currentAcadmicStatusTable}`.`session_id`,
                        `{$sessionsTable}`.`session_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sessionsTable}` ON `{$sessionsTable}`.id = `{$currentAcadmicStatusTable}`.session_id

                    ) `tb_current_session` ON `tb_current_session`.student_id = `{$studentsTable}`.id

                ";

        $limitFilter = NULL;
        if ($limit > 0) {
            $limitFilter = "LIMIT {$limit} OFFSET {$offset}";
        }

        return DB::select(DB::raw("SELECT *
                    FROM (
                        $sql
                    ) `tb1`
                    WHERE 1 = 1
                    {$sectionIdFilter}
                    {$searchFilter}
                    {$classIdFilter}
                    {$sessionIdFilter}
                    ORDER BY `{$orderColumn}` {$orderDir}
                    {$limitFilter}

                "));
    }


    /**
     * Query for `Students with class,section,subject,marks columns` data
     *
     * @param  int  $personId
     * @param  int  $classId
     * @param  array|null  $sectionId
     * @param  array|null  $otherParams
     * @return mixed
     */
    public static function countMarksEntryExcelExport($personId, $sectionId, $otherParams = null){
        $studentsTable = (new Student())->getTable();
        $classesTable = (new Classes())->getTable();
        $sectionsTable = (new Sections())->getTable();
        $sessionsTable = (new Sessions())->getTable();
        $marksTable = (new Marks())->getTable();
        $currentAcadmicStatusTable = (new CurrentAcadmicStatus())->getTable();


        $orderPurchaseTableFilter = NULL;
        $poShipmentDetailTableFilter = NULL;


        $classId = isset($otherParams['class_id']) ? $otherParams['class_id'] : 0;
        $sessionId = isset($otherParams['session_id']) ? $otherParams['session_id'] : 0;
        $keyword = isset($otherParams['search']) ? $otherParams['search'] : null;

        $offset = isset($otherParams['offset']) ? $otherParams['offset'] : 0;
        $limit = isset($otherParams['limit']) ? $otherParams['limit'] : 10;

        $orderColumn = isset($otherParams['order_column']) ? $otherParams['order_column'] : 'roll_no';
        $orderDir = isset($otherParams['order_dir']) ? $otherParams['order_dir'] : 'asc';

        $searchFilter = null;
        if (!empty($keyword)) {
            $searchFilter = "AND (
                    `name` LIKE '%{$keyword}%'
                    OR `roll_no` LIKE '%{$keyword}%'
                    OR `class_name` LIKE '%{$keyword}%'
                    OR `session_name` LIKE '%{$keyword}%'
                )";
        }

        $sessionIdFilter = null;
        if ($sessionId > 0) {
            $sessionIdFilter = "AND `session_id` = '{$sessionId}'";
        }

        $sectionIdFilter = null;
        if ($sectionId > 0) {
            $sectionIdFilter = "AND `section_id` ='{$sectionId}'";
        }

        $classIdFilter = null;
        if ($classId > 0) {
            $classIdFilter = "AND  `class_id` = '{$classId}'";
        }

        $sql = "";
            $sql = "
                SELECT `{$studentsTable}`.*,
                `tb_current_class`.class_id,
                `tb_current_class`.class_name,
                `tb_current_section`.section_id,
                `tb_current_section`.section_name,
                `tb_current_session`.session_id,
                `tb_current_session`.session_name
                    FROM `{$studentsTable}`

                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                               `{$currentAcadmicStatusTable}`.`class_id`,
                               `{$classesTable}`.`class_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$classesTable}` ON `{$classesTable}`.id = `{$currentAcadmicStatusTable}`.class_id

                    ) `tb_current_class` ON `tb_current_class`.student_id = `{$studentsTable}`.id


                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                        `{$currentAcadmicStatusTable}`.`section_id`,
                               `{$sectionsTable}`.`section_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sectionsTable}` ON `{$sectionsTable}`.id = `{$currentAcadmicStatusTable}`.section_id

                    ) `tb_current_section` ON `tb_current_section`.student_id = `{$studentsTable}`.id

                    LEFT JOIN (
                        SELECT `{$currentAcadmicStatusTable}`.student_id,
                                `{$currentAcadmicStatusTable}`.`session_id`,
                               `{$sessionsTable}`.`session_name`
                        FROM `{$currentAcadmicStatusTable}`
                        LEFT JOIN `{$sessionsTable}` ON `{$sessionsTable}`.id = `{$currentAcadmicStatusTable}`.session_id

                    ) `tb_current_session` ON `tb_current_session`.student_id = `{$studentsTable}`.id


                ";

        $limitFilter = NULL;
        if ($limit > 0) {
            $limitFilter = "LIMIT {$limit} OFFSET {$offset}";
        }

        $resultQuery = DB::select(DB::raw("SELECT COUNT(*) AS total
                    FROM (
                        $sql
                    ) `tb1`
                    WHERE 1 = 1
                    {$sectionIdFilter}
                    {$searchFilter}
                    {$classIdFilter}
                    {$sessionIdFilter}
                    ORDER BY `{$orderColumn}` {$orderDir}
                    {$limitFilter}

                "));

        return $resultQuery[0]->total ?? 0;
    }





}
