<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Marks extends Model
{
    use HasFactory;

    protected $table = 'marks';


    /**
     * Mass fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'student_id',
        'session_id',
        'status'
    ];

    /**
     * Relationship to `marks` table
     *
     * @return mixed
     */
    public function subject()
    {
        return $this->belongsTo(Subjects::class, 'subject_id', 'id')
                ->withDefault([
                    'name' => ''
                ]);
    }

       /**
     * Relationship to `students` table
     *
     * @return mixed
     */
    public function students()
    {
        return $this->hasOne(Student::class,'id','student_id')->with('currentAcademicStatus');

    }
    /**
     * Relationship to `classes` table
     *
     * @return mixed
     */
    public function class()
    {
        return $this->belongsTo(Classes::class, 'class_id', 'id');
    }

    /**
     * Relationship to `exams` table
     *
     * @return mixed
     */
    public function exam()
    {
        return $this->belongsTo(Exams::class, 'exam_id', 'id');
    }



    public function scopeFilterWithSession($query,$session_id) {
        return $query->where('session_id', '=', $session_id);
    }


    public static function getMarkDetailsBySessionIDAndStudentID($session_id,$exam_id,$student_id){
        $marksDetails = Marks::with('subject')
       // ->filterWithSession($session_id)
        ->where('exam_id',$exam_id)
        ->where('student_id',$student_id)
        ->get();
        $arrSubject = array();
        $i=0;
        foreach($marksDetails as $row){
            $subject_name = $row->subject->name;
            $full_marks = $row->fullmarks;
            $total_obtained_marks = array_sum(explode(",",$row->marks));
            $arrSubject[$i]['subject_name'] = $subject_name ;
            $arrSubject[$i]['full_marks'] = $full_marks ;
            $arrSubject[$i]['mark_type_ids'] = $row->mark_type_ids ;
            $arrSubject[$i]['marks'] = $row->marks ;
            $arrSubject[$i]['total_obtained_marks'] = $total_obtained_marks ;
            $arrSubject[$i]['grade_point'] = Marks::PerSubjectGPAGeneratorByTotal($total_obtained_marks);
            $arrSubject[$i]['letter_grade'] = Marks::PerSubjectLetterGradeGeneratorByTotal($total_obtained_marks);
            $i++;
        }

        return $arrSubject;
    }
    /**
     * Return grade by total
     *
     * @return mixed
     */
    public static function PerSubjectGPAGeneratorByTotal($total)
    {

        if($total>=80){
            $grade= "5.0";
        }elseif($total>=70 && $total < 80){
            $grade= "4.0";
        }elseif($total>=60 && $total < 70){
            $grade= "3.5";
        }elseif($total>=50 && $total < 60){
            $grade= "3.0";
        }elseif($total>=40 && $total < 50){
            $grade= "2.0";
        }elseif($total>=33 && $total < 40){
            $grade= "1.0";
        }else{
            $grade= "0.0";
        }
        return $grade;
    }

     /**
     * Return grade by total
     *
     * @return mixed
     */
    public static function PerSubjectLetterGradeGeneratorByTotal($total)
    {

        if($total>=80){
            $grade= "A+";
        }elseif($total>=70 && $total < 80){
            $grade= "A";
        }elseif($total>=60 && $total < 70){
            $grade= "A-";
        }elseif($total>=50 && $total < 60){
            $grade= "B";
        }elseif($total>=40 && $total < 50){
            $grade= "C";
        }elseif($total>=33 && $total < 40){
            $grade= "D";
        }else{
            $grade= "F";
        }

        return $grade;
    }


         /**
     * Return grade by GPA
     *
     * @return mixed
     */
    public static function PerSubjectLetterGradeGeneratorByGPA($GPA)
    {

        if($GPA>='5'){
            $grade = "A+";
        }elseif($GPA >='4' && $GPA < '5'){
            $grade= "A";
        }elseif($GPA >='3.5' && $GPA < '4'){
            $grade= "A-";
        }elseif($GPA >='3' && $GPA < '3.5'){
            $grade= "B";
        }elseif($GPA >='2' && $GPA < '3.0'){
            $grade= "C";
        }elseif($GPA >= '1' && $GPA < '2'){
            $grade= "D";
        }else{
            $grade= "F";
        }

        return $grade;
    }


    /**
     * Return Students With Marks
     *
     * @return mixed
     */
    public static function getStudentsWithMarkDetails($exam_id,$student_id){

        $data = Student::with(['MarksDetails' => function ($query)  use ($exam_id) {
                $query->where('exam_id',$exam_id);
                }])
                ->with(['currentAcademicStatus' => function ($query){
                    $query->orderBy('id','desc');
                }])
                ->where('id',$student_id)->first();

        return $data;
    }


public static function getMarksGPADetails($students){

    // MERIT LIST GENERATOR
    $total_full_marks = 0;
    $total_subjects = array();
    $arr_gp_per_student = array();
    $arr_marks_per_student = array();
    if($students){
        foreach($students as $row){

            $student_id = $row->student_id;
            if(isset($row->MarksDetails)){
                foreach ($row->MarksDetails as $marks) {

                    $marks = explode(",",$marks->marks);
                    $total = array_sum($marks);

                    $gp = Marks::PerSubjectGPAGeneratorByTotal($total);
                    $letter_grade = Marks::PerSubjectLetterGradeGeneratorByTotal($total);

                    $arr_gp_per_student[$student_id][] = $gp;
                    $arr_letter_grade_per_student[$student_id][] = $letter_grade;
                    $arr_marks_per_student[$student_id][] = $total;

                }
                $total_subjects[] =  count($row->MarksDetails);
            }

        }
        if(count($total_subjects) > 0 && $arr_letter_grade_per_student && $arr_gp_per_student){
            return [
                'arr_per_student_total_gp' => array_map('array_sum', $arr_gp_per_student),
                'total_subjects' => isset($total_subjects) ? max($total_subjects) : 0,
                'arr_per_student_student_marks_total' => array_map('array_sum', $arr_marks_per_student),
                'arr_per_student_letter_grade_count' => array_map('array_count_values', $arr_letter_grade_per_student),
                'merit_list_by_section' => Marks::merit_list_generator($arr_gp_per_student, $arr_marks_per_student),
            ];
        }

    }

}
public static function getMeritList($students){

    // MERIT LIST GENERATOR
    $total_full_marks = 0;
    $arr_gp_per_student = array();
    $arr_marks_per_student = array();

    foreach($students as $row){

        if (isset($row->MarksDetails)) {
            foreach ($row->MarksDetails as $marks) {
                    if (isset($marks->marks)) {
                        $marks = explode(",", $marks->marks);
                        $total = array_sum($marks);

                        $gp = Marks::PerSubjectGPAGeneratorByTotal($total);
                        $student_id = $row->student_id;
                        $arr_gp_per_student[$student_id][] = $gp;
                        $arr_marks_per_student[$student_id][] = $total;
                    }
            }
        }
    }
    $merit_list_by_section = Marks::merit_list_generator($arr_gp_per_student, $arr_marks_per_student);

    return $merit_list_by_section ;
}



    /**
     * Return Merit List
     *
     * @return array
     */
    public static function merit_list_generator($arr_gp_per_student,$arr_marks_per_student){
        $arr_final_student_gp_count = array();
        if(!empty($arr_gp_per_student)){
            $arr_final_student_gp_count =  array_map('array_count_values', $arr_gp_per_student);
            $arr_final_student_gp_total =  array_map('array_sum', $arr_gp_per_student);
            $arr_final_student_marks_total =  array_map('array_sum', $arr_marks_per_student);
            arsort($arr_final_student_gp_total);
            arsort($arr_final_student_marks_total);

        }

        $arr_merit = [];
        if(!empty($arr_final_student_gp_total)){
            foreach ($arr_final_student_gp_total as $first_student_id => $first_gpa) {
                $arr_merit[] = $first_student_id; // put first_student on merit list
                unset($arr_final_student_gp_total[$first_student_id]); // unset the first student from students list

                // start with next student to compare with first student
                foreach ($arr_final_student_gp_total as $next_student_id => $second_gpa) {
                    if($first_gpa==$second_gpa){
                        arsort($arr_final_student_gp_count[$first_student_id]);
                        arsort($arr_final_student_gp_count[$next_student_id]);
                        $first = $arr_final_student_gp_count[$first_student_id];
                        $next = $arr_final_student_gp_count[$next_student_id];

                        $match = FALSE;
                        foreach($first as $gp=>$count){
                            if($first[$gp] < $next[$gp]){
                                $match = TRUE;
                                // Search value and delete
                                if(($key = array_search($first_student_id, $arr_merit)) !== false) {
                                    unset($arr_merit[$key]);
                                }

                                $arr_merit[]= $next_student_id;
                                $arr_merit[]= $first_student_id;
                                break;
                            }
                        }

                        //if gpa count same for both students then will match by total marks
                        if(!$match){
                            if($arr_final_student_marks_total[$first_student_id]< $arr_final_student_marks_total[$first_student_id]){
                                $arr_merit[]= $next_student_id;
                                $arr_merit[]= $first_student_id;
                            }else{
                                $arr_merit[]= $first_student_id;
                                $arr_merit[]= $next_student_id;
                            }
                        }
                    }
                }
            }
        }

        $arr_merit = array_unique($arr_merit); // [2 => 15, 7 => 4, 11 => 7]
        $arr_merit = array_values($arr_merit); // re index key [0 => 15, 1 => 4, 2 => 7]
        $arr_merit = array_flip($arr_merit); //  [15 => 0, 4 => 1, 7 => 2]
        return $arr_merit;
    }



}
