<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Lenders extends Model
{
    use HasFactory;

    public function shop()
    {
        return $this->belongsTo(Shop::class, 'shop_id', 'id')->withDefault(['name' => '']);
    }

    public function opening_due()
    {
        return $this->hasOne(InitialTransaction::class, 'lender_id', 'id')->withDefault(['amount' => '']);
    }
    
    /**
     * Query to search by name from table
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param string|null $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchTable($query, $keyword = null)
    {
        if (!empty($keyword)) {
            $productTable = $this->getTable();
            $query->Where('lender_name', 'like', "%$keyword%")
                    ->orWhere('phone', 'like', "%$keyword%")
                    ->orWhere('email', 'like', "%$keyword%")
                    ->orWhere('address', 'like', "%$keyword%");
        }
        return;
    }

/**
     * Query to search from quantity logs table page.
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  string|null  $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeFilterByShop($query, $shop_id = '')
    {
        if($shop_id) return $query->whereIn('shop_id', explode(",",$shop_id));

        return;
    }

    /**
     * Query to filter by `stock_status`
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  int  $stockStatus
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeFilterByStatus($query, $status = '-1')
    {
        if($status>=0) return $query->where('status', $status);
    }


}