<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Json extends Model
{
    use HasFactory;


    /**
     * Get data from json file
     *
     * @return array
     */
    public static function getAllDivision()
    {
        $path_divisions = storage_path() . "/json/bd-divisions.json";
        $bd_divisions= json_decode(file_get_contents($path_divisions), true); 
        return $bd_divisions;
    }


    

    /**
     * Get data from json file
     *
     * @return array
     */
    public static function getAllDistrict()
    {

        $path_districts = storage_path() . "/json/bd-districts.json";
        $bd_districts = json_decode(file_get_contents($path_districts), true); 
        return $bd_districts;
    }

    

    /**
     * Get data from json file
     *
     * @return array
     */
    public static function getAllPostCodes()
    {
        $path_postcodes = storage_path() . "/json/bd-postcodes.json";
        $postcodes = json_decode(file_get_contents($path_postcodes), true); 

        return $postcodes;
    }


        /**
     * Get data from json file
     *
     * @return array
     */
    public static function getAllUpazilas()
    {
        $path_upazilas = storage_path() . "/json/bd-upazilas.json";
        $upazilas = json_decode(file_get_contents($path_upazilas), true); 

        return $upazilas;
    }




}
