<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class FeeTypes extends Model
{
    use HasFactory;

    protected $table = 'fee_types';

    /**
     * Define status field value
     *
     * @var mixed
     */
    CONST ACTIVE = '1';
    CONST DEACTIVE = '0';

    /**
     * Relationship to `fee_types_amount` table
     *
     * @return mixed
     */
    public function fee_types_amount()
    {
        return $this->hasMany(FeeTypesAmount::class,'fee_type_id','id');
    }

  

}
