<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DailyExpenses extends Model
{
    use HasFactory;

    protected $table = 'daily_expenses';
    protected $fillable = ['details', 'amount','entry_date', 'note','status','payment_method','bank_or_wallet_id','acc_or_mobile_no'];

    /**
     * Relationship to `expense_types` table
     *
     * @return mixed
     */
    public function expense_type()
    {
        return $this->belongsTo(ExpenseType::class, 'expense_type_id', 'id');
    }

}
