<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Customers extends Model
{
    use HasFactory;
    protected $table = 'clients';
    public function shop()
    {
        return $this->belongsTo(Shop::class, 'shop_id', 'id')->withDefault(['name' => '']);
    }

    public function opening_due()
    {
        return $this->hasOne(InitialTransaction::class, 'client_id', 'id')->withDefault(['amount' => '']);
    }

    
    
    /**
     * Query to search by name from table
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param string|null $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeSearchTable($query, $keyword = null)
    {
        if (!empty($keyword)) {
            $productTable = $this->getTable();
            $query->Where('company_name', 'like', "%$keyword%")
                    ->orWhere('php_no', 'like', "%$keyword%")
                    ->orWhere('expire_date', 'like', "%$keyword%");
        }
        return;
    }

    /**
     * Query to search from quantity logs table page.
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  string|null  $keyword
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopefilterByMemberType($query, $member_type = '')
    {
        if($member_type) return $query->where('member_type', $member_type);

        return;
    }

       /**
     * Query to filter by `stock_status`
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  int  $stockStatus
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeFilterByPermissionType($query, $permission = '')
    {
        if($permission=='permission_of_secretary') return $query->where('permission_of_secretary', 1);
        if($permission=='permission_of_gs') return $query->where('permission_of_gs', 1);
        if($permission=='permission_of_president') return $query->where('permission_of_president', 1);
    }


}