<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * Define `order_type` field value
     *
     * @var string
     */
    CONST ORDER_TYPE_DEFAULT = 1;
    CONST ORDER_TYPE_CUSTOM = 2;

    /**
     * Define table name
     *
     * @var string
     */
    protected $table = 'customers';

    /**
     * Mass fillable fields
     *
     * @var array
     */
    protected $fillable = [
        'customer_name',
        'contact_phone',
        'person_id',
        'order_type'
    ];

    public function orderProduct()
    {
        return $this->hasMany(OrderManagement::class);
    }

    /**
     * Relationship to `users` table as a person
     *
     * @return mixed
     */
    public function person()
    {
        return $this->belongsTo(User::class)->withDefault();
    }



    /**
     * Query to check if customer is Dropshipper
     *
     * @param  \Illuminate\Database\Query\Builder  $query
     * @param  int  $customerType
     * @return \Illuminate\Database\Query\Builder
     */
    public function scopeCustomerType($query, $customerType)
    {
        if ($customerType != '0') {
            return $query->where('is_dropshipper', '=', 1);
        }

        return;
    }
}
